/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.boot.starter.job.config;

import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import lombok.Generated;
import org.jeecg.boot.starter.job.prop.XxlJobProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={XxlJobProperties.class})
@ConditionalOnProperty(value={"jeecg.xxljob.enabled"}, havingValue="true", matchIfMissing=true)
public class XxlJobConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XxlJobConfiguration.class);
    @Autowired
    private XxlJobProperties xxlJobProperties;

    @Bean
    @ConditionalOnClass
    public XxlJobSpringExecutor xxlJobExecutor() {
        log.info(">>>>>>>>>>> xxl-job config init.");
        XxlJobSpringExecutor xxlJobSpringExecutor = new XxlJobSpringExecutor();
        xxlJobSpringExecutor.setAdminAddresses(this.xxlJobProperties.getAdminAddresses());
        xxlJobSpringExecutor.setAppname(this.xxlJobProperties.getAppname());
        String ip = this.xxlJobProperties.getIp();
        Integer port = this.xxlJobProperties.getPort();
        if (StringUtils.hasText((String)ip)) {
            xxlJobSpringExecutor.setIp(ip);
        }
        if (port != null && port > 0) {
            xxlJobSpringExecutor.setPort(port.intValue());
        }
        xxlJobSpringExecutor.setAccessToken(this.xxlJobProperties.getAccessToken());
        xxlJobSpringExecutor.setLogPath(this.xxlJobProperties.getLogPath());
        xxlJobSpringExecutor.setLogRetentionDays(this.xxlJobProperties.getLogRetentionDays().intValue());
        return xxlJobSpringExecutor;
    }
}

