/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.airag.flow.vo.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.airag.flow.entity.AiragFlow;
import org.jeecg.modules.airag.flow.vo.flow.config.FlowNode;
import org.jeecg.modules.airag.flow.vo.flow.config.FlowNodeConfig;
import org.springframework.util.CollectionUtils;

public class SubFlowResult {
    private String id;
    private String name;
    private String descr;
    private String status;
    private List<FlowNodeConfig.NodeParam> inputParams;
    private List<FlowNodeConfig.NodeParam> outputParams;

    public SubFlowResult(AiragFlow flow) {
        this.id = flow.getId();
        this.name = flow.getName();
        this.descr = flow.getDescr();
        this.status = flow.getStatus();
        this.inputParams = new ArrayList<FlowNodeConfig.NodeParam>();
        this.outputParams = new ArrayList<FlowNodeConfig.NodeParam>();
        this.initParams(flow);
    }

    private void initParams(AiragFlow flow) {
        JSONObject design;
        try {
            design = JSONObject.parseObject((String)flow.getDesign());
        }
        catch (Exception e2) {
            return;
        }
        if (null == design || !design.containsKey((Object)"nodes")) {
            return;
        }
        JSONArray nodes = design.getJSONArray("nodes");
        if (CollectionUtils.isEmpty((Collection)nodes)) {
            return;
        }
        HashMap<String, FlowNodeConfig.NodeParam> outputParamMap = new HashMap<String, FlowNodeConfig.NodeParam>();
        for (Object node : nodes) {
            FlowNode flowNodeObj = (FlowNode)((JSONObject)node).toJavaObject(FlowNode.class);
            FlowNodeConfig properties = flowNodeObj.getProperties();
            if ("start".equals(flowNodeObj.getType())) {
                this.inputParams = properties.getInputParams();
                continue;
            }
            if (!"end".equals(flowNodeObj.getType())) continue;
            boolean outputText = false;
            if (oConvertUtils.isObjectNotEmpty(properties.getOptions())) {
                outputText = (Boolean)properties.getOptions().get("outputText");
            }
            if (outputText) {
                FlowNodeConfig.NodeParam nodeParam2 = new FlowNodeConfig.NodeParam();
                nodeParam2.setName("outputText");
                nodeParam2.setField("outputText");
                outputParamMap.put(nodeParam2.getField(), nodeParam2);
                continue;
            }
            properties.getOutputParams().forEach(nodeParam -> outputParamMap.put(nodeParam.getName(), (FlowNodeConfig.NodeParam)nodeParam));
        }
        this.outputParams = new ArrayList(outputParamMap.values());
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescr() {
        return this.descr;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public List<FlowNodeConfig.NodeParam> getInputParams() {
        return this.inputParams;
    }

    @Generated
    public List<FlowNodeConfig.NodeParam> getOutputParams() {
        return this.outputParams;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescr(String descr) {
        this.descr = descr;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setInputParams(List<FlowNodeConfig.NodeParam> inputParams) {
        this.inputParams = inputParams;
    }

    @Generated
    public void setOutputParams(List<FlowNodeConfig.NodeParam> outputParams) {
        this.outputParams = outputParams;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubFlowResult)) {
            return false;
        }
        SubFlowResult other = (SubFlowResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$descr = this.getDescr();
        String other$descr = other.getDescr();
        if (this$descr == null ? other$descr != null : !this$descr.equals(other$descr)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        List<FlowNodeConfig.NodeParam> this$inputParams = this.getInputParams();
        List<FlowNodeConfig.NodeParam> other$inputParams = other.getInputParams();
        if (this$inputParams == null ? other$inputParams != null : !((Object)this$inputParams).equals(other$inputParams)) {
            return false;
        }
        List<FlowNodeConfig.NodeParam> this$outputParams = this.getOutputParams();
        List<FlowNodeConfig.NodeParam> other$outputParams = other.getOutputParams();
        return !(this$outputParams == null ? other$outputParams != null : !((Object)this$outputParams).equals(other$outputParams));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SubFlowResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $descr = this.getDescr();
        result = result * 59 + ($descr == null ? 43 : $descr.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        List<FlowNodeConfig.NodeParam> $inputParams = this.getInputParams();
        result = result * 59 + ($inputParams == null ? 43 : ((Object)$inputParams).hashCode());
        List<FlowNodeConfig.NodeParam> $outputParams = this.getOutputParams();
        result = result * 59 + ($outputParams == null ? 43 : ((Object)$outputParams).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SubFlowResult(id=" + this.getId() + ", name=" + this.getName() + ", descr=" + this.getDescr() + ", status=" + this.getStatus() + ", inputParams=" + this.getInputParams() + ", outputParams=" + this.getOutputParams() + ")";
    }
}

