/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.desreport.service.a;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.jeecg.modules.jmreport.b.a.b.a;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.util.c;
import org.jeecg.modules.jmreport.common.util.j;
import org.jeecg.modules.jmreport.common.util.l;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.jeecg.modules.jmreport.config.oss.JmReportUploadConfig;
import org.jeecg.modules.jmreport.desreport.entity.JimuReport;
import org.jeecg.modules.jmreport.desreport.service.IJimuReportService;
import org.jeecg.modules.jmreport.desreport.service.IJmReportExportExcel;
import org.jeecg.modules.jmreport.desreport.service.IJmReportExportService;
import org.jeecg.modules.jmreport.form.service.IJimuFormService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="JmReportExportServiceImpl")
public class p
implements IJmReportExportService {
    private static final Logger a = LoggerFactory.getLogger(p.class);
    @Autowired
    private IJmReportExportExcel reportExportExcel;
    @Autowired
    private IJimuReportService jmReportDesignService;
    @Autowired
    private IJimuFormService jmReportFormService;
    @Autowired
    private JmReportUploadConfig jimuReportUploadConfig;

    @Override
    public void exportReport(HttpServletResponse response, HttpServletRequest request, String exportParams, String zipName) {
        try {
            String decode = URLDecoder.decode(exportParams, "UTF-8");
            JSONArray jsonArray = JSONArray.parseArray((String)decode);
            if (jsonArray.size() == 1) {
                JSONObject jsonObject = jsonArray.getJSONObject(0);
                this.a(jsonObject, response, request);
            } else {
                String downPath = this.jimuReportUploadConfig.getPath().getUpload() + File.separator + "apiExport" + File.separator + l.getInstance().a();
                this.exportMore(jsonArray, request, response, downPath);
                this.a(zipName, downPath, response);
            }
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a(JSONObject jsonObject, HttpServletResponse response, HttpServletRequest request) {
        String reportId = jsonObject.getString("reportId");
        String exportType = jsonObject.getString("exportType");
        Object queryParam = jsonObject.get((Object)"queryParam");
        Object fileName = jsonObject.get((Object)"fileName");
        Object sheetId = jsonObject.get((Object)"sheetId");
        JSONObject exportAllObj = new JSONObject();
        exportAllObj.put("excelConfigId", (Object)reportId);
        if (null != sheetId) {
            exportAllObj.put("sheetId", sheetId);
        }
        if (OkConvertUtils.isNotEmpty(queryParam)) {
            try {
                exportAllObj.put("queryParam", JSONObject.parse((String)URLDecoder.decode(queryParam.toString(), "UTF-8")));
            }
            catch (UnsupportedEncodingException e2) {
                throw new RuntimeException(e2);
            }
        } else {
            exportAllObj.put("queryParam", (Object)new JSONObject());
        }
        if ("excel".equalsIgnoreCase(exportType)) {
            try {
                Map<String, Object> result = this.a(reportId, exportAllObj);
                if (null == result) return;
                this.b(result, fileName, response);
                return;
            }
            catch (IOException e3) {
                throw new JimuReportException("\u5bfc\u51fa\u5931\u8d25\uff01");
            }
        }
        if ("pdf".equalsIgnoreCase(exportType)) {
            try {
                Map<String, Object> result = this.a(response, request, reportId, exportAllObj);
                if (null == result) return;
                this.a(result, fileName, response);
                return;
            }
            catch (IOException e4) {
                throw new JimuReportException("\u5bfc\u51fa\u5931\u8d25\uff01");
            }
        }
        if (!"word".equalsIgnoreCase(exportType)) return;
        try {
            org.jeecg.modules.jmreport.b.a.a.a exportHandler = this.a(request, reportId, exportAllObj);
            exportHandler.a(response, (String)fileName);
            return;
        }
        catch (IOException e5) {
            throw new JimuReportException("\u5bfc\u51fa\u5931\u8d25\uff01");
        }
    }

    @Override
    public void exportMore(JSONArray jsonArray, HttpServletRequest request, HttpServletResponse response, String downloadPath) {
        c.b("\u4e0b\u8f7d\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", downloadPath);
        int size = jsonArray.size();
        int digits = String.valueOf(size).length();
        Pattern numberedPattern = Pattern.compile("^\\d+([ _-]).*");
        for (int i2 = 0; i2 < jsonArray.size(); ++i2) {
            JSONObject jsonObject = jsonArray.getJSONObject(i2);
            String reportId = jsonObject.getString("reportId");
            String exportType = jsonObject.getString("exportType");
            Object queryParam = jsonObject.get((Object)"queryParam");
            Object fileNameObj = jsonObject.get((Object)"fileName");
            Object sheetId = jsonObject.get((Object)"sheetId");
            JSONObject exportAllObj = new JSONObject();
            exportAllObj.put("excelConfigId", (Object)reportId);
            try {
                String finalFileName;
                String originalName;
                if (OkConvertUtils.isNotEmpty(queryParam)) {
                    exportAllObj.put("queryParam", JSONObject.parse((String)URLDecoder.decode(queryParam.toString(), "UTF-8")));
                } else {
                    exportAllObj.put("queryParam", (Object)new JSONObject());
                }
                if (OkConvertUtils.isNotEmpty(sheetId)) {
                    exportAllObj.put("sheetId", sheetId);
                }
                String indexPrefix = String.format("%0" + digits + "d", i2 + 1);
                String rawFileName = OkConvertUtils.getString(fileNameObj, "");
                String suffix = "";
                Map<String, Object> result = null;
                if ("excel".equalsIgnoreCase(exportType)) {
                    result = this.a(reportId, exportAllObj);
                    suffix = ".xlsx";
                    originalName = OkConvertUtils.getString(result.get("name"), "");
                    finalFileName = this.a(indexPrefix, rawFileName, originalName, numberedPattern);
                    p.a(result, suffix, finalFileName, downloadPath);
                    continue;
                }
                if ("pdf".equalsIgnoreCase(exportType)) {
                    result = this.a(response, request, reportId, exportAllObj);
                    suffix = ".pdf";
                    originalName = OkConvertUtils.getString(result.get("name"), "");
                    finalFileName = this.a(indexPrefix, rawFileName, originalName, numberedPattern);
                    p.a(result, suffix, finalFileName, downloadPath);
                    continue;
                }
                if (!"word".equalsIgnoreCase(exportType)) continue;
                JSONObject exportQueryParam = exportAllObj.getJSONObject("queryParam");
                Result<JimuReport> show = this.jmReportDesignService.show(reportId, exportQueryParam.toJSONString(), null);
                String originalName2 = OkConvertUtils.getString(show.getResult() != null ? show.getResult().getName() : "", "");
                finalFileName = this.a(indexPrefix, rawFileName, originalName2, numberedPattern);
                org.jeecg.modules.jmreport.b.a.a.a exportHandler = this.a(request, reportId, exportAllObj);
                exportHandler.a(downloadPath, finalFileName);
                continue;
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    private static void a(Map<String, Object> result, String suffix, Object fileName, String downPath) throws IOException {
        if (null != result) {
            Object file = result.get("file");
            Object name = result.get("name");
            String filename = name.toString();
            if (OkConvertUtils.isNotEmpty(fileName)) {
                filename = fileName + suffix;
            }
            if (!filename.endsWith(suffix)) {
                filename = filename + suffix;
            }
            byte[] bytes = Base64.decodeBase64((String)file.toString());
            ByteArrayInputStream input = new ByteArrayInputStream(bytes);
            String finalFilePath = downPath + File.separator + filename;
            finalFilePath = j.e(finalFilePath);
            j.a(input, finalFilePath);
        }
    }

    private void a(Map<String, Object> result, Object fileName, HttpServletResponse response) throws IOException {
        Object o2 = result.get("file");
        Object name = result.get("name");
        String filename = URLEncoder.encode(name.toString() + ".pdf", "UTF-8");
        if (OkConvertUtils.isNotEmpty(fileName)) {
            filename = URLEncoder.encode(fileName + ".pdf", "UTF-8");
        }
        String disposition = "attachment; filename=" + filename;
        response.addHeader("Content-Disposition", disposition);
        byte[] bytes = Base64.decodeBase64((String)o2.toString());
        ServletOutputStream outputStream = response.getOutputStream();
        outputStream.write(bytes);
        outputStream.flush();
        outputStream.close();
    }

    private void b(Map<String, Object> result, Object fileName, HttpServletResponse response) throws IOException {
        Object o2 = result.get("file");
        Object name = result.get("name");
        String filename = name.toString();
        if (OkConvertUtils.isNotEmpty(fileName)) {
            filename = URLEncoder.encode(fileName + ".xlsx", "UTF-8");
        }
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        String disposition = "attachment; filename=" + filename;
        response.addHeader("Content-Disposition", disposition);
        byte[] bytes = Base64.decodeBase64((String)o2.toString());
        ServletOutputStream outputStream = response.getOutputStream();
        outputStream.write(bytes);
        outputStream.flush();
        outputStream.close();
    }

    private Map<String, Object> a(HttpServletResponse response, HttpServletRequest request, String reportId, JSONObject exportAllObj) throws IOException {
        if (OkConvertUtils.isEmpty(reportId)) {
            throw new JimuReportException("\u5bfc\u51fa\u5931\u8d25\uff0c\u62a5\u8868id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null != response) {
            response.setContentType("text/plain;charaset=utf-8");
            response.setContentType("application/vnd.ms-pdf");
        }
        return this.a(request, exportAllObj);
    }

    private Map<String, Object> a(String reportId, JSONObject exportAllObj) throws IOException {
        if (OkConvertUtils.isEmpty(reportId)) {
            throw new JimuReportException("\u5bfc\u51fa\u5931\u8d25\uff0c\u62a5\u8868id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.a(exportAllObj);
    }

    private org.jeecg.modules.jmreport.b.a.a.a a(HttpServletRequest request, String reportId, JSONObject exportAllObj) {
        String dpiString;
        JSONObject queryParam = exportAllObj.getJSONObject("queryParam");
        queryParam.put("printAll", (Object)true);
        Result<JimuReport> show = this.jmReportDesignService.show(reportId, queryParam.toJSONString(), null);
        JSONObject jsonObject = this.jmReportFormService.fillInRender(show.getResult(), queryParam);
        JimuReport result = show.getResult();
        result.setJsonStrJson(jsonObject);
        int dpi = 96;
        if (null != request && OkConvertUtils.isNotEmpty(dpiString = request.getParameter("dpi"))) {
            dpi = Integer.parseInt(dpiString);
        }
        JSONArray layerData = exportAllObj.getJSONArray("base64Arry");
        return new a(result, dpi, layerData, queryParam);
    }

    private void a(String zipName, String downPath, HttpServletResponse response) {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/force-download");
        try (ZipOutputStream ziops = new ZipOutputStream(new BufferedOutputStream((OutputStream)response.getOutputStream()));){
            String fileName = "\u6279\u91cf\u5bfc\u51fa" + new Date().getTime() + ".zip";
            if (OkConvertUtils.isNotEmpty(zipName)) {
                fileName = zipName + ".zip";
            }
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            ziops.setMethod(8);
            Path sourcePath = Paths.get(downPath, new String[0]);
            Files.walk(sourcePath, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                ZipEntry zipEntry = new ZipEntry(sourcePath.relativize((Path)path).toString());
                try {
                    ziops.putNextEntry(zipEntry);
                    Files.copy(path, ziops);
                    ziops.closeEntry();
                    j.a(path.toFile());
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            });
            response.flushBuffer();
        }
        catch (IOException e2) {
            System.err.println("Error zipping files: " + e2);
        }
    }

    public Map<String, Object> a(JSONObject exportAllObj) throws IOException {
        String excelConfigId = exportAllObj.getString("excelConfigId");
        JSONObject queryParam = exportAllObj.getJSONObject("queryParam");
        long startTime = System.currentTimeMillis();
        JSONArray echartBase = exportAllObj.getJSONArray("base64Arry");
        Object bigDataMode = false;
        if (null != queryParam) {
            bigDataMode = queryParam.get((Object)"bigDataMode");
        }
        String sheetId = exportAllObj.getString("sheetId");
        Map<String, Object> map = this.reportExportExcel.exportExcel(excelConfigId, queryParam, (List)echartBase, Boolean.parseBoolean(OkConvertUtils.getString(bigDataMode, "false")), sheetId);
        File file = new File(map.get("name").toString());
        SXSSFWorkbook workbook = (SXSSFWorkbook)map.get("workbook");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        HashMap<String, Object> mape = new HashMap<String, Object>(5);
        workbook.write((OutputStream)bos);
        String fileBase = Base64.encodeBase64String((byte[])bos.toByteArray());
        mape.put("file", fileBase);
        mape.put("success", true);
        mape.put("name", file.getName());
        bos.close();
        long endTime = System.currentTimeMillis();
        return mape;
    }

    public Map<String, Object> a(HttpServletRequest request, JSONObject exportAllObj) throws IOException {
        String dpiString;
        String excelConfigId = exportAllObj.getString("excelConfigId");
        JSONObject queryParam = exportAllObj.getJSONObject("queryParam");
        queryParam.put("printAll", (Object)true);
        String sheetId = exportAllObj.getString("sheetId");
        Result<JimuReport> show = this.jmReportDesignService.show(excelConfigId, queryParam.toJSONString(), null, sheetId);
        JSONObject jsonObject = this.jmReportFormService.fillInRender(show.getResult(), queryParam);
        JimuReport result = show.getResult();
        result.setJsonStrJson(jsonObject);
        float dpi = 96.0f;
        if (null != request && OkConvertUtils.isNotEmpty(dpiString = request.getParameter("dpi"))) {
            dpi = Float.parseFloat(dpiString);
        }
        org.jeecg.modules.jmreport.desreport.pdf.b.c tableRender = new org.jeecg.modules.jmreport.desreport.pdf.b.c(result.getJsonStrJson(), dpi, null, queryParam);
        HashMap<String, Object> map = new HashMap<String, Object>();
        byte[] bytes = tableRender.a();
        String fileBase = Base64.encodeBase64String((byte[])bytes);
        map.put("file", fileBase);
        map.put("success", true);
        map.put("name", result.getName());
        return map;
    }

    private String a(String indexPrefix, String rawFileName, String originalName, Pattern numberedPattern) {
        rawFileName = this.a(rawFileName);
        originalName = this.a(originalName);
        boolean hasCustom = OkConvertUtils.isNotEmpty(rawFileName);
        if (!hasCustom) {
            if (OkConvertUtils.isNotEmpty(originalName)) {
                return indexPrefix + "_" + originalName;
            }
            return indexPrefix;
        }
        if (numberedPattern.matcher(rawFileName).matches()) {
            return rawFileName;
        }
        return indexPrefix + "_" + rawFileName;
    }

    private String a(String name) {
        if (OkConvertUtils.isEmpty(name)) {
            return name;
        }
        int dot = name.lastIndexOf(46);
        if (dot > 0) {
            return name.substring(0, dot);
        }
        return name;
    }
}

