/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.desreport.service.a;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.desreport.dao.JimuReportSheetDao;
import org.jeecg.modules.jmreport.desreport.entity.JimuReport;
import org.jeecg.modules.jmreport.desreport.entity.JimuReportSheet;
import org.jeecg.modules.jmreport.desreport.service.IJimuReportSheetService;
import org.jeecgframework.minidao.util.SnowflakeIdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="jimuReportSheetServiceImpl")
public class i
implements IJimuReportSheetService {
    @Autowired
    private JimuReportSheetDao reportSheetDao;

    @Override
    public List<JimuReportSheet> getAllSheets(JimuReport report) {
        ArrayList<JimuReportSheet> sheetList = new ArrayList<JimuReportSheet>();
        List<JimuReportSheet> sheets = this.reportSheetDao.selectByReportId(report.getId());
        ArrayList<JimuReportSheet> extraSheets = new ArrayList<JimuReportSheet>();
        if (sheets != null && sheets.size() > 0) {
            extraSheets.addAll(sheets);
        }
        JimuReportSheet defaultSheet = new JimuReportSheet();
        defaultSheet.setId("default");
        defaultSheet.setSheetName("\u9ed8\u8ba4Sheet");
        defaultSheet.setSheetOrder(0);
        defaultSheet.setJsonStrJson(report.getJsonStrJson());
        for (JimuReportSheet sheet : extraSheets) {
            if (sheet.getSheetOrder() >= 0) continue;
            sheetList.add(sheet);
        }
        sheetList.add(defaultSheet);
        for (JimuReportSheet sheet : extraSheets) {
            if (sheet.getSheetOrder() <= 0) continue;
            sheetList.add(sheet);
        }
        return sheetList;
    }

    @Override
    public JSONObject getSheetJsonStr(JimuReport report, String sheetId) {
        if (OkConvertUtils.isEmpty(sheetId) || "default".equals(sheetId)) {
            return report.getJsonStrJson();
        }
        JimuReportSheet sheet = this.reportSheetDao.getByReportIdAndSheetId(report.getId(), sheetId);
        if (sheet != null) {
            report.setCurrentSheetName(sheet.getSheetName());
            return sheet.getJsonStrJson();
        }
        return report.getJsonStrJson();
    }

    @Override
    public void saveSheetJsonStr(JimuReport report, String sheetId, JSONObject sheetJsonStr, String sheetName, String sheetOrder) {
        if (OkConvertUtils.isEmpty(sheetId) || "default".equals(sheetId)) {
            int count;
            report.setJsonStrJson(sheetJsonStr);
            if (report.getIsMultiSheet() != null && report.getIsMultiSheet() == 1 && (count = this.reportSheetDao.countByReportId(report.getId())) == 0) {
                report.setIsMultiSheet(0);
            }
            return;
        }
        JimuReportSheet sheet = this.reportSheetDao.getByReportIdAndSheetId(report.getId(), sheetId);
        Date now = new Date();
        if (sheet == null) {
            sheet = new JimuReportSheet();
            sheet.setId(sheetId);
            sheet.setReportId(report.getId());
            sheet.setSheetName("Sheet" + (this.a(report) + 1));
            if (OkConvertUtils.isNotEmpty(sheetName)) {
                sheet.setSheetName(sheetName);
            }
            sheet.setSheetOrder(this.a(report) + 1);
            if (OkConvertUtils.isNotEmpty(sheetOrder)) {
                try {
                    sheet.setSheetOrder(Integer.parseInt(sheetOrder));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            sheet.setCreateTime(now);
            sheet.setJsonStrJson(sheetJsonStr);
            sheet.setUpdateTime(now);
            this.reportSheetDao.insert(sheet);
            report.setIsMultiSheet(1);
        } else {
            sheet.setJsonStrJson(sheetJsonStr);
            sheet.setUpdateTime(now);
            this.reportSheetDao.update(sheet);
        }
    }

    @Override
    public void deleteSheet(JimuReport report, String sheetId) {
        if ("default".equals(sheetId)) {
            throw new JimuReportException("\u4e0d\u80fd\u5220\u9664\u9ed8\u8ba4Sheet");
        }
        JimuReportSheet sheet = this.reportSheetDao.getByReportIdAndSheetId(report.getId(), sheetId);
        if (sheet != null) {
            this.reportSheetDao.deleteById(sheet.getId());
            int count = this.reportSheetDao.countByReportId(report.getId());
            if (count == 0) {
                report.setIsMultiSheet(0);
            }
        }
    }

    @Override
    public String addSheet(JimuReport report, String sheetName, Integer order) {
        String sheetId = String.valueOf(SnowflakeIdWorker.generateId());
        JimuReportSheet newSheet = new JimuReportSheet();
        Date now = new Date();
        newSheet.setId(sheetId);
        newSheet.setReportId(report.getId());
        newSheet.setSheetName(sheetName);
        if (order != null) {
            newSheet.setSheetOrder(order);
        } else {
            newSheet.setSheetOrder(this.a(report) + 1);
        }
        newSheet.setJsonStr("{}");
        newSheet.setCreateTime(now);
        newSheet.setUpdateTime(now);
        this.reportSheetDao.insert(newSheet);
        report.setIsMultiSheet(1);
        return sheetId;
    }

    @Override
    public void renameSheet(JimuReport report, String sheetId, String newName) {
        if ("default".equals(sheetId)) {
            throw new JimuReportException("\u4e0d\u80fd\u91cd\u547d\u540d\u9ed8\u8ba4Sheet");
        }
        JimuReportSheet sheet = this.reportSheetDao.getByReportIdAndSheetId(report.getId(), sheetId);
        if (sheet != null) {
            sheet.setSheetName(newName);
            sheet.setUpdateTime(new Date());
            this.reportSheetDao.update(sheet);
        }
    }

    @Override
    public void reorderSheets(JimuReport report, List<String> sheetIds) {
        List<JimuReportSheet> sheets = this.reportSheetDao.selectByReportId(report.getId());
        if (sheets == null || sheets.size() == 0) {
            return;
        }
        int defaultIndex = sheetIds.indexOf("default");
        Date now = new Date();
        block0: for (int i2 = 0; i2 < sheetIds.size(); ++i2) {
            String sheetId = sheetIds.get(i2);
            if ("default".equals(sheetId)) continue;
            for (JimuReportSheet sheet : sheets) {
                if (!sheetId.equals(sheet.getId())) continue;
                if (defaultIndex == -1) {
                    sheet.setSheetOrder(i2 + 1);
                } else if (i2 < defaultIndex) {
                    sheet.setSheetOrder(-(defaultIndex - i2));
                } else {
                    sheet.setSheetOrder(i2 - defaultIndex);
                }
                sheet.setUpdateTime(now);
                this.reportSheetDao.update(sheet);
                continue block0;
            }
        }
    }

    @Override
    public boolean isMultiSheet(JimuReport report) {
        return report.getIsMultiSheet() != null && report.getIsMultiSheet() == 1;
    }

    private int a(JimuReport report) {
        return this.reportSheetDao.countByReportId(report.getId());
    }
}

