/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.desreport.service.a;

import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.util.g;
import org.jeecg.modules.jmreport.common.util.n;
import org.jeecg.modules.jmreport.config.JmReportBaseConfig;
import org.jeecg.modules.jmreport.config.client.JmReportTokenClient;
import org.jeecg.modules.jmreport.config.firewall.interceptor.enums.ShareUrlEnum;
import org.jeecg.modules.jmreport.desreport.dao.JimuReportDao;
import org.jeecg.modules.jmreport.desreport.dao.JimuReportDbDao;
import org.jeecg.modules.jmreport.desreport.dao.JimuReportLinkDao;
import org.jeecg.modules.jmreport.desreport.dao.JimuReportShareDao;
import org.jeecg.modules.jmreport.desreport.entity.JimuReport;
import org.jeecg.modules.jmreport.desreport.entity.JimuReportLink;
import org.jeecg.modules.jmreport.desreport.entity.JimuReportShare;
import org.jeecg.modules.jmreport.desreport.entity.JmReportDb;
import org.jeecg.modules.jmreport.desreport.model.JmPage;
import org.jeecg.modules.jmreport.desreport.model.JmReportShareVo;
import org.jeecg.modules.jmreport.desreport.service.IJimuReportShareService;
import org.jeecg.modules.jmreport.desreport.util.e;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.jeecgframework.minidao.util.SnowflakeIdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.HandlerMapping;

@Service(value="jimuReportShareServiceImpl")
public class h
implements IJimuReportShareService {
    private static final Logger a = LoggerFactory.getLogger(h.class);
    private static final PathMatcher b = new AntPathMatcher();
    @Value(value="${jeecg.shiro.excludeUrls:}")
    private String excludeUrls;
    @Autowired
    private JimuReportShareDao jimuReportShareDao;
    @Autowired
    private JimuReportDao jimuReportDao;
    @Autowired
    private JimuReportDbDao jimuReportDbDao;
    @Autowired
    private JimuReportLinkDao jimuReportLinkDao;
    @Autowired
    private JmReportBaseConfig jmBaseConfig;
    @Autowired
    private JmReportTokenClient jimuTokenClient;

    @Override
    public JimuReportShare selectJurisdiction(String reportId) {
        return this.jimuReportShareDao.selectJurisdiction(reportId);
    }

    @Override
    public boolean isSharingEffective(String reportIdUrl, HttpServletRequest request) {
        String[] excludeUrlArr;
        boolean exists = ShareUrlEnum.getShareUrls().stream().anyMatch(url -> b.match(url, reportIdUrl));
        if (exists) {
            String reportId = this.a(reportIdUrl, request);
            if (OkConvertUtils.isEmpty(reportId)) {
                return false;
            }
            JimuReportShare jurisdiction = this.selectJurisdiction(reportId);
            a.info("\u5206\u4eab\u62a5\u8868\u9a8c\u8bc1\u6709\u6548\u6027\uff0creportId\uff1a{}\uff0c\u5206\u4eab\u8bbe\u7f6e\uff1a{}", (Object)reportId, (Object)JSONObject.toJSONString((Object)jurisdiction));
            if (jurisdiction == null) {
                return false;
            }
            if (OkConvertUtils.isNotEmpty(jurisdiction.getShareToken())) {
                return this.isShareingToken(reportIdUrl, request);
            }
            jurisdiction = this.compareToDate(jurisdiction);
            return "0".equals(jurisdiction.getStatus());
        }
        exists = ShareUrlEnum.getDragShareUrls().stream().anyMatch(url -> b.match(url, reportIdUrl));
        if (!exists && OkConvertUtils.isNotEmpty(this.excludeUrls) && OkConvertUtils.isNotEmpty(excludeUrlArr = this.excludeUrls.split(","))) {
            exists = Arrays.stream(excludeUrlArr).anyMatch(excludeUrl -> b.match(excludeUrl, reportIdUrl));
        }
        return exists;
    }

    @Override
    public String getExtractionCode() {
        String str = "0123456789abcdefghijklmnopqrstuvwxyz";
        StringBuilder sb = new StringBuilder(4);
        for (int i2 = 0; i2 < 4; ++i2) {
            char ch = str.charAt(new Random().nextInt(str.length()));
            sb.append(ch);
        }
        return sb.toString();
    }

    @Override
    public JimuReportShare compareToDate(JimuReportShare jurisdiction) {
        Date lastUpdateTime = jurisdiction.getLastUpdateTime();
        String termOfValidity = jurisdiction.getTermOfValidity();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(lastUpdateTime);
        if ("2".equals(termOfValidity)) {
            calendar.add(5, 7);
        } else if ("3".equals(termOfValidity)) {
            calendar.add(5, 1);
        } else {
            return jurisdiction;
        }
        Date time = calendar.getTime();
        Date date = new Date();
        boolean before = date.before(time);
        if (!before) {
            jurisdiction.setStatus("1");
            this.jimuReportShareDao.update(jurisdiction);
            return jurisdiction;
        }
        return jurisdiction;
    }

    @Override
    public String passwordVerification(String reportId, String lock, HttpServletResponse response) {
        Long count = this.jimuReportDao.count(reportId);
        if (null == count || 0L == count) {
            return "noExist";
        }
        JimuReportShare jurisdiction = this.jimuReportShareDao.selectJurisdiction(reportId);
        if (null == jurisdiction) {
            return "3";
        }
        if ("1".equals((jurisdiction = this.compareToDate(jurisdiction)).getStatus())) {
            return "1";
        }
        if ("0".equals(jurisdiction.getPreviewLockStatus())) {
            return "0";
        }
        if (OkConvertUtils.isEmpty(lock)) {
            return "2";
        }
        String previewLock = jurisdiction.getPreviewLock();
        if (previewLock.equals(lock)) {
            if (response != null && OkConvertUtils.isNotEmpty(jurisdiction.getShareToken())) {
                String jwtToken = n.a(jurisdiction.getShareToken(), reportId);
                n.a(response, jwtToken, reportId);
            }
            return "0";
        }
        return "2";
    }

    @Override
    public JimuReportShare addAndEdit(JimuReportShare jurisdiction) {
        String reportId = jurisdiction.getReportId();
        String previewLockStatus = jurisdiction.getPreviewLockStatus();
        if ("1".equals(previewLockStatus)) {
            String extractionCode = this.getExtractionCode();
            jurisdiction.setPreviewLock(extractionCode);
        }
        JimuReportShare diction = this.jimuReportShareDao.selectJurisdiction(reportId);
        jurisdiction.setLastUpdateTime(new Date());
        if (OkConvertUtils.isNotEmpty(jurisdiction.getStatus()) && "1".equals(jurisdiction.getStatus())) {
            jurisdiction.setPreviewUrl("");
        } else {
            try {
                if (OkConvertUtils.isNotEmpty(jurisdiction.getVerifyShareToken()) && "1".equals(jurisdiction.getVerifyShareToken())) {
                    String mdStr = g.g(SnowflakeIdWorker.generateId().toString());
                    jurisdiction.setPreviewUrl("/jmreport/shareView/" + jurisdiction.getReportId() + "?shareToken=" + mdStr);
                    jurisdiction.setShareToken(mdStr);
                } else {
                    jurisdiction.setPreviewUrl("/jmreport/shareView/" + jurisdiction.getReportId());
                    jurisdiction.setShareToken("");
                }
            }
            catch (Exception e2) {
                a.error("\u6d4f\u89c8\u94fe\u63a5\u751f\u6210\u5931\u8d25");
                a.error(e2.getMessage(), (Throwable)e2);
            }
        }
        if (null == diction) {
            String uuid = String.valueOf(SnowflakeIdWorker.generateId());
            jurisdiction.setId(uuid);
            this.jimuReportShareDao.insert(jurisdiction);
        } else {
            jurisdiction.setId(diction.getId());
            this.jimuReportShareDao.update(jurisdiction);
        }
        return jurisdiction;
    }

    private void a(JimuReportShare jurisdiction) {
        Object useQueryForm;
        JSONObject jsonObject;
        JimuReport jimuReport;
        JSONObject jsonStrJson;
        String reportId = jurisdiction.getReportId();
        if (OkConvertUtils.isNotEmpty(jurisdiction.getStatus()) && !"1".equals(jurisdiction.getStatus()) && (jsonStrJson = (jimuReport = this.jimuReportDao.get(reportId)).getJsonStrJson()).containsKey((Object)"queryFormSetting") && null != (jsonObject = jsonStrJson.getJSONObject("queryFormSetting")) && jsonObject.containsKey((Object)"useQueryForm") && null != (useQueryForm = jsonObject.get((Object)"useQueryForm")) && Boolean.parseBoolean(useQueryForm.toString())) {
            throw new JimuReportException("\u67e5\u8be2\u586b\u62a5\u7981\u6b62\u5206\u4eab\uff01");
        }
    }

    @Override
    public boolean isShareingToken(String requestPath, HttpServletRequest request) {
        String jmLink;
        Object shareToken = request.getHeader("JmReport-Share-Token");
        Object linkId = "";
        if (OkConvertUtils.isEmpty(shareToken)) {
            shareToken = request.getParameter("shareToken");
        }
        if (OkConvertUtils.isNotEmpty(jmLink = request.getParameter("jmLink"))) {
            try {
                byte[] bytes = Base64.decodeBase64((String)jmLink);
                String str = new String(bytes);
                Object[] split = str.split("\\|\\|");
                if (ArrayUtils.isNotEmpty((Object[])split) && split.length == 2) {
                    shareToken = split[0];
                    linkId = split[1];
                }
            }
            catch (IllegalArgumentException e2) {
                a.error("\u89e3\u5bc6\u5931\u8d25\uff1a" + e2.getMessage());
                a.error(e2.getMessage(), (Throwable)e2);
                return false;
            }
        }
        if (OkConvertUtils.isEmpty(shareToken)) {
            return false;
        }
        JimuReportShare jurisdiction = this.jimuReportShareDao.getShareByShareToken((String)shareToken);
        if (jurisdiction != null) {
            if (!"0".equals((jurisdiction = this.compareToDate(jurisdiction)).getStatus())) {
                return false;
            }
        } else {
            return false;
        }
        if (requestPath.startsWith("/jmreport/view")) {
            if (OkConvertUtils.isNotEmpty(linkId)) {
                Long count = this.jimuReportLinkDao.selectLinkCountByLinkId((String)linkId);
                if (null != count && count > 0L) {
                    return true;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public JmPage<JmReportShareVo> getSharePageList(Integer pageNo, Integer pageSize, String reportName, HttpServletRequest request) {
        String username = "";
        String tenantId = "";
        if ("created".equals(this.jmBaseConfig.getSaasMode())) {
            username = OkConvertUtils.getString(this.jimuTokenClient.getUsername(request), "\u83b7\u53d6\u4e0d\u5230\u7528\u6237\u8d26\u53f7");
        }
        if ("tenant".equals(this.jmBaseConfig.getSaasMode())) {
            tenantId = OkConvertUtils.getString(this.jimuTokenClient.getTenantId(), "\u83b7\u53d6\u4e0d\u5230\u79df\u6237ID");
        }
        if (OkConvertUtils.isNotEmpty(reportName)) {
            reportName = "%" + reportName + "%";
        }
        MiniDaoPage<JmReportShareVo> all = this.jimuReportLinkDao.getSharePageList(pageNo, pageSize, reportName, username, tenantId);
        return org.jeecg.modules.jmreport.desreport.util.h.a(all);
    }

    @Override
    public void batchCancelShareByIds(String ids) {
        if (OkConvertUtils.isNotEmpty(ids)) {
            this.jimuReportLinkDao.batchCancelShareByIds(Arrays.asList(ids.split(",")));
        }
    }

    @Override
    public boolean verifyShareTokenWithJwt(String requestPath, HttpServletRequest request, HttpServletResponse response) {
        String reportId = this.a(requestPath, request);
        if (OkConvertUtils.isEmpty(reportId)) {
            return false;
        }
        String jwtToken = n.a(request, reportId);
        if (OkConvertUtils.isNotEmpty(jwtToken)) {
            String jwtReportId = n.b(jwtToken);
            if (OkConvertUtils.isNotEmpty(jwtReportId) && reportId.equals(jwtReportId)) {
                if (n.d(jwtToken)) {
                    String mainShareToken = n.f(jwtToken);
                    String mainReportId = n.e(jwtToken);
                    if (OkConvertUtils.isNotEmpty(mainReportId)) {
                        JimuReportShare mainJurisdiction = null;
                        mainJurisdiction = OkConvertUtils.isNotEmpty(mainShareToken) ? this.jimuReportShareDao.getShareByShareToken(mainShareToken) : this.jimuReportShareDao.selectJurisdiction(mainReportId);
                        if (mainJurisdiction != null) {
                            String dbShareToken;
                            if (!mainReportId.equals(mainJurisdiction.getReportId())) {
                                return false;
                            }
                            if (OkConvertUtils.isNotEmpty(mainShareToken) && (OkConvertUtils.isEmpty(dbShareToken = mainJurisdiction.getShareToken()) || !mainShareToken.equals(dbShareToken))) {
                                return false;
                            }
                            mainJurisdiction = this.compareToDate(mainJurisdiction);
                            return "0".equals(mainJurisdiction.getStatus());
                        }
                    }
                } else {
                    String shareToken = n.c(jwtToken);
                    JimuReportShare jurisdiction = null;
                    jurisdiction = OkConvertUtils.isNotEmpty(shareToken) ? this.jimuReportShareDao.getShareByShareToken(shareToken) : this.jimuReportShareDao.selectJurisdiction(reportId);
                    if (jurisdiction != null) {
                        String dbShareToken;
                        if (!reportId.equals(jurisdiction.getReportId())) {
                            return false;
                        }
                        if (OkConvertUtils.isNotEmpty(shareToken) && (OkConvertUtils.isEmpty(dbShareToken = jurisdiction.getShareToken()) || !shareToken.equals(dbShareToken))) {
                            return false;
                        }
                        jurisdiction = this.compareToDate(jurisdiction);
                        return "0".equals(jurisdiction.getStatus());
                    }
                }
            }
        } else if (requestPath.startsWith("/jmreport/view")) {
            this.processDrillDownReport(reportId, request, response);
            return true;
        }
        return false;
    }

    @Override
    public boolean processDrillDownReport(String reportId, HttpServletRequest request, HttpServletResponse response) {
        String jwtToken = n.b(request, reportId);
        if (OkConvertUtils.isNotEmpty(jwtToken)) {
            return true;
        }
        String jmLink = request.getParameter("jmLink");
        if (OkConvertUtils.isEmpty(jmLink)) {
            return false;
        }
        try {
            byte[] bytes = Base64.decodeBase64((String)jmLink);
            String str = new String(bytes, StandardCharsets.UTF_8);
            Object[] split = str.split("\\|\\|");
            if (ArrayUtils.isNotEmpty((Object[])split) && split.length == 2) {
                String mainReportId;
                String mainJwtToken;
                Object mainShareToken = split[0];
                Object linkId = split[1];
                JimuReportLink link = this.jimuReportLinkDao.get((String)linkId);
                if (link == null) {
                    a.debug("linkId\u5bf9\u5e94\u7684link\u6570\u636e\u4e0d\u5b58\u5728: {}", linkId);
                    return false;
                }
                if (!reportId.equals(link.getReportId())) {
                    a.debug("\u5f53\u524d\u62a5\u8868id\u4e0elink\u7684\u62a5\u8868id\u4e0d\u4e00\u81f4, \u5f53\u524d\u62a5\u8868id: {}, link\u62a5\u8868id: {}", (Object)reportId, (Object)link.getReportId());
                    return false;
                }
                JimuReportShare mainJurisdiction = this.jimuReportShareDao.getShareByShareToken((String)mainShareToken);
                if (mainJurisdiction != null && "0".equals((mainJurisdiction = this.compareToDate(mainJurisdiction)).getStatus()) && OkConvertUtils.isNotEmpty(mainJwtToken = n.a(request, mainReportId = mainJurisdiction.getReportId()))) {
                    String drillJwtToken = n.a(reportId, (String)mainShareToken, mainReportId);
                    n.a(response, drillJwtToken, reportId);
                    return true;
                }
            }
        }
        catch (Exception e2) {
            a.debug("\u89e3\u6790jmLink\u5931\u8d25: {}", (Object)e2.getMessage());
        }
        return false;
    }

    @Override
    public void processShareView(String reportId, HttpServletRequest request, HttpServletResponse response) {
        String urlShareToken;
        JimuReportShare jurisdiction = this.jimuReportShareDao.selectJurisdiction(reportId);
        if (OkConvertUtils.isEmpty(jurisdiction)) {
            n.a(response, reportId);
            return;
        }
        if ("1".equals((jurisdiction = this.compareToDate(jurisdiction)).getStatus())) {
            n.a(response, reportId);
            return;
        }
        String shareToken = jurisdiction.getShareToken();
        String existsJwtToken = n.b(request, reportId);
        if (OkConvertUtils.isNotEmpty(existsJwtToken)) {
            String jwtShareToken = n.c(existsJwtToken);
            if (OkConvertUtils.isNotEmpty(jwtShareToken) && !jwtShareToken.equals(shareToken)) {
                n.a(response, reportId);
            } else {
                return;
            }
        }
        if (OkConvertUtils.isNotEmpty(jurisdiction.getShareToken()) && (OkConvertUtils.isEmpty(urlShareToken = request.getParameter("shareToken")) || !urlShareToken.equals(shareToken))) {
            n.a(response, reportId);
            return;
        }
        if ("0".equals(jurisdiction.getPreviewLockStatus())) {
            String jwtToken = n.a(shareToken, reportId);
            n.a(response, jwtToken, reportId);
        }
    }

    private String a(String requestPath, HttpServletRequest request) {
        String reportId = "";
        if (requestPath.startsWith(ShareUrlEnum.GET_QUERY_INFO.getValue())) {
            String method = request.getMethod();
            reportId = RequestMethod.POST.name().equals(method) ? e.a(request, "reportId") : request.getParameter("reportId");
        } else if (requestPath.startsWith(ShareUrlEnum.SHARE_VERIFICATION.getValue()) || requestPath.startsWith(ShareUrlEnum.DICTCODE_SEARCH.getValue()) || requestPath.startsWith(ShareUrlEnum.MULTIPLE_INIT_VALUE.getValue())) {
            reportId = request.getParameter("reportId");
        } else if (requestPath.startsWith(ShareUrlEnum.QUERYMAP_BY_CODE.getValue()) || requestPath.startsWith(ShareUrlEnum.GET_CHAR_DATA.getValue())) {
            reportId = e.a(request, "reportId");
        } else if (requestPath.startsWith(ShareUrlEnum.EXPORT_PDF_STREAM.getValue()) || requestPath.startsWith(ShareUrlEnum.EXPORT_ALL_EXCEL_STREAM.getValue()) || requestPath.startsWith(ShareUrlEnum.EXPORT_WORD_STREAM.getValue())) {
            reportId = e.a(request, "excelConfigId");
        } else if (requestPath.startsWith(ShareUrlEnum.QUREST_SQL.getValue()) || requestPath.startsWith(ShareUrlEnum.QUREST_API.getValue())) {
            JmReportDb jmReportDb;
            String apiSelectId = e.a(request, "apiSelectId");
            if (OkConvertUtils.isNotEmpty(apiSelectId) && (jmReportDb = this.jimuReportDbDao.get(apiSelectId)) != null) {
                reportId = jmReportDb.getJimuReportId();
            }
        } else if (requestPath.startsWith(ShareUrlEnum.SHOW_DATA.getValue())) {
            reportId = request.getParameter("id");
            if (OkConvertUtils.isEmpty(reportId)) {
                reportId = e.a(request, "id");
            }
        } else if (b.match(ShareUrlEnum.FORM_REPEAT_SUBMIT.getValue(), requestPath)) {
            reportId = e.a(request, "reportId");
        } else {
            Map pathVars = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
            if (pathVars != null && OkConvertUtils.isEmpty(reportId = (String)pathVars.get("id"))) {
                reportId = (String)pathVars.get("reportId");
            }
        }
        return reportId;
    }
}

