/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.desreport.service.a;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.modules.jmreport.common.constant.a;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.jeecg.modules.jmreport.config.JmReportBaseConfig;
import org.jeecg.modules.jmreport.config.client.JmReportTokenClient;
import org.jeecg.modules.jmreport.desreport.dao.JimuReportCategoryDao;
import org.jeecg.modules.jmreport.desreport.dao.JimuReportDao;
import org.jeecg.modules.jmreport.desreport.entity.JimuReport;
import org.jeecg.modules.jmreport.desreport.entity.JimuReportCategory;
import org.jeecg.modules.jmreport.desreport.model.JmMoVeFilesVo;
import org.jeecg.modules.jmreport.desreport.model.JmPage;
import org.jeecg.modules.jmreport.desreport.model.TreeModel;
import org.jeecg.modules.jmreport.desreport.service.IJimuReportCategoryService;
import org.jeecg.modules.jmreport.desreport.util.h;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="jimuReportCategoryServiceImpl")
public class b
implements IJimuReportCategoryService {
    private static final Logger a = LoggerFactory.getLogger(b.class);
    @Autowired
    private JimuReportCategoryDao categoryDao;
    @Autowired
    private JmReportTokenClient jimuTokenClient;
    @Autowired
    private JmReportBaseConfig jmBaseConfig;
    @Autowired
    private JimuReportDao jimuReportDao;

    @Override
    public List<TreeModel> queryList(JimuReportCategory category) {
        ArrayList<TreeModel> list = new ArrayList<TreeModel>();
        List<JimuReportCategory> categoryList = this.categoryDao.queryList(category);
        categoryList.forEach(item -> {
            TreeModel treeModel = new TreeModel(item.getId(), item.getParentId(), item.getId(), item.getName(), item.getIzLeaf(), item.getSortNo());
            list.add(treeModel);
        });
        return list;
    }

    @Override
    public void save(JimuReportCategory reportCategory) {
        String parentId;
        int count;
        String username = this.jimuTokenClient.getUsername();
        String tenantId = this.jimuTokenClient.getTenantId();
        reportCategory.setCreateBy(username);
        reportCategory.setTenantId(tenantId);
        reportCategory.setCreateTime(new Date());
        reportCategory.setDelFlag(org.jeecg.modules.jmreport.common.constant.a.b);
        reportCategory.setIzLeaf(org.jeecg.modules.jmreport.common.constant.a.a);
        reportCategory.setSourceType("report");
        if (OkConvertUtils.isNotEmpty(reportCategory.getParentId()) && (count = this.categoryDao.count(parentId = reportCategory.getParentId())) > 0) {
            JimuReportCategory category = new JimuReportCategory();
            category.setId(parentId);
            category.setIzLeaf(org.jeecg.modules.jmreport.common.constant.a.b);
            this.categoryDao.update(category);
        }
        this.categoryDao.insert(reportCategory);
    }

    @Override
    public void updateById(JimuReportCategory reportCategory, String parentId) {
        this.b(reportCategory.getParentId());
        this.categoryDao.update(reportCategory);
        this.a(parentId);
    }

    @Override
    public JimuReportCategory updateDelFlag(Integer delFlag, String id) {
        int count;
        JimuReportCategory reportCategory = this.categoryDao.get(id);
        if (null == reportCategory) {
            throw new JimuReportException("\u4fee\u6539\u5931\u8d25,\u672a\u627e\u5230\u8be5\u6587\u4ef6\u5939\uff01");
        }
        JimuReportCategory category = new JimuReportCategory();
        category.setId(id);
        category.setDelFlag(delFlag);
        if (OkConvertUtils.isNotEmpty(reportCategory.getParentId()) && (count = this.categoryDao.count(reportCategory.getParentId())) == 0) {
            category.setParentId("0");
        }
        this.categoryDao.update(category);
        if (org.jeecg.modules.jmreport.common.constant.a.b.equals(delFlag)) {
            this.b(reportCategory.getParentId());
        } else {
            this.a(reportCategory.getParentId());
        }
        List<String> idList = this.categoryDao.selectIdsByParentId(reportCategory.getId());
        this.a(delFlag, idList);
        return reportCategory;
    }

    private void a(Integer delFlag, List<String> idList) {
        if (!CollectionUtils.isEmpty(idList)) {
            for (String id : idList) {
                JimuReportCategory category = new JimuReportCategory();
                category.setId(id);
                if (org.jeecg.modules.jmreport.common.constant.a.a.equals(delFlag)) {
                    delFlag = 2;
                }
                category.setDelFlag(delFlag);
                this.categoryDao.update(category);
                List<String> list = this.categoryDao.selectIdsByParentId(id);
                if (CollectionUtils.isEmpty(idList)) continue;
                this.a(delFlag, list);
            }
        }
    }

    @Override
    public JimuReportCategory getById(String id) {
        return this.categoryDao.get(id);
    }

    @Override
    public void completelyDeleteById(String id) {
        JimuReportCategory reportCategory = this.categoryDao.get(id);
        if (null == reportCategory) {
            throw new JimuReportException("\u5220\u9664\u5931\u8d25,\u672a\u627e\u5230\u8be5\u6587\u4ef6\u5939\uff01");
        }
        this.a(reportCategory.getParentId());
        this.categoryDao.completelyDeleteByCategoryId(id);
        this.categoryDao.delete(id);
        this.a(reportCategory);
    }

    private void a(JimuReportCategory reportCategory) {
        List<String> idList;
        if (null != reportCategory && !CollectionUtils.isEmpty(idList = this.categoryDao.getIdsByParentId(reportCategory.getId()))) {
            this.categoryDao.deleteBatch(idList);
            this.categoryDao.completelyDeleteByCategoryIds(idList);
            for (int i2 = 0; i2 < idList.size(); ++i2) {
                JimuReportCategory category = this.getById(idList.get(i2));
                this.a(category);
            }
        }
    }

    private void a(String parentId) {
        int count;
        if (OkConvertUtils.isNotEmpty(parentId) && (count = this.categoryDao.countByParentId(parentId)) == 0) {
            JimuReportCategory category = new JimuReportCategory();
            category.setId(parentId);
            category.setIzLeaf(org.jeecg.modules.jmreport.common.constant.a.a);
            this.categoryDao.update(category);
        }
    }

    private void b(JimuReportCategory reportCategory) {
        String tenantId;
        if ("created".equals(this.jmBaseConfig.getSaasMode())) {
            String username = this.jimuTokenClient.getUsername();
            if (OkConvertUtils.isEmpty(username) || !username.equals(reportCategory.getCreateBy())) {
                throw new JimuReportException("\u5f00\u542f\u4e86Saas\u6a21\u5f0f\uff1a\u7528\u6237\u53ea\u80fd\u770b\u81ea\u5df1\u7684\u6570\u636e\uff01");
            }
        } else if ("tenant".equals(this.jmBaseConfig.getSaasMode()) && (OkConvertUtils.isEmpty(tenantId = this.jimuTokenClient.getTenantId()) || !tenantId.equals(reportCategory.getTenantId()))) {
            throw new JimuReportException("\u5f00\u542f\u4e86Saas\u6a21\u5f0f\uff1a\u7528\u6237\u53ea\u80fd\u770b\u81ea\u5df1\u79df\u6237\u4e0b\u7684\u6570\u636e\uff01");
        }
    }

    private void b(String parentId) {
        JimuReportCategory category;
        if (OkConvertUtils.isNotEmpty(parentId) && null != (category = this.categoryDao.get(parentId)) && org.jeecg.modules.jmreport.common.constant.a.a.equals(category.getIzLeaf())) {
            JimuReportCategory jimuReportCategory = new JimuReportCategory();
            jimuReportCategory.setId(parentId);
            jimuReportCategory.setIzLeaf(org.jeecg.modules.jmreport.common.constant.a.b);
            this.categoryDao.update(jimuReportCategory);
        }
    }

    @Override
    public Result<JmPage<JimuReport>> queryRecycleBin(String reportType, String name, HttpServletRequest request, Integer pageNo, Integer pageSize) {
        JimuReport report = new JimuReport();
        if (OkConvertUtils.isNotEmpty(name)) {
            report.setName("%" + name + "%");
        }
        if ("created".equals(this.jmBaseConfig.getSaasMode())) {
            String userName = OkConvertUtils.getString(this.jimuTokenClient.getUsername(request), "\u83b7\u53d6\u4e0d\u5230\u7528\u6237\u8d26\u53f7");
            report.setCreateBy(userName);
        }
        if ("tenant".equals(this.jmBaseConfig.getSaasMode())) {
            String tenantId = OkConvertUtils.getString(this.jimuTokenClient.getTenantId(), "\u83b7\u53d6\u4e0d\u5230\u79df\u6237ID");
            report.setTenantId(tenantId);
        }
        MiniDaoPage<JimuReport> pageList = this.categoryDao.queryRecycleBin(report, pageNo, pageSize);
        return Result.OK(h.a(pageList));
    }

    @Override
    public void updateJmTypeByCategoryId(JimuReport report) {
        String id = report.getId();
        String type = report.getType();
        this.categoryDao.updateJmTypeByCategoryId(id, type);
    }

    @Override
    public void batchMoveFilesAndFolder(JmMoVeFilesVo filesVo) {
        List<JimuReport> jimuReportList = filesVo.getJimuReportList();
        ArrayList<String> fileIds = new ArrayList<String>();
        ArrayList<String> folderIds = new ArrayList<String>();
        String categoryId = filesVo.getToParentId();
        for (JimuReport report : jimuReportList) {
            if ("report".equals(report.getType())) {
                if (report.getId().equals(categoryId)) continue;
                folderIds.add(report.getId());
                continue;
            }
            fileIds.add(report.getId());
        }
        if (!CollectionUtils.isEmpty(fileIds)) {
            this.categoryDao.batchMoveFiles(fileIds, categoryId);
        }
        if (!CollectionUtils.isEmpty(folderIds)) {
            String formParentId = filesVo.getFormParentId();
            for (String folderId : folderIds) {
                JimuReportCategory category = new JimuReportCategory();
                category.setId(folderId);
                category.setParentId(categoryId);
                this.updateById(category, formParentId);
            }
        }
    }

    @Override
    public Integer getMinSortByParentId(String parentId, String categoryId) {
        MiniDaoPage<JimuReportCategory> maxSortPage = this.categoryDao.getMinSortByParentId(parentId, categoryId, 1, 1);
        List results = maxSortPage.getResults();
        if (!CollectionUtils.isEmpty((Collection)results)) {
            if (null == results.get(0) || null == ((JimuReportCategory)results.get(0)).getSortNo()) {
                this.categoryDao.updateSort(parentId, 0);
                return 0;
            }
            return ((JimuReportCategory)results.get(0)).getSortNo();
        }
        return 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void folderSort(JSONObject jsonObject) {
        String dragstartData = jsonObject.getString("dragstartData");
        String updateSort = jsonObject.getString("updateSort");
        Object type = jsonObject.get((Object)"type");
        if (type != null && OkConvertUtils.isNotEmpty(updateSort) && OkConvertUtils.isNotEmpty(dragstartData)) {
            int sortType = Integer.parseInt(type.toString());
            JSONObject dragstartDataObject = JSONObject.parseObject((String)dragstartData);
            String startId = dragstartDataObject.getString("id");
            JimuReportCategory jimuReportCategory = this.categoryDao.get(startId);
            if (null == jimuReportCategory) {
                throw new JimuReportException("\u79fb\u52a8\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01");
            }
            int sortNoInt = 0;
            String parentId = "0";
            if (dragstartDataObject.containsKey((Object)"parentId")) {
                parentId = OkConvertUtils.getString(dragstartDataObject.getString("parentId"), "0");
            }
            JimuReportCategory reportCategory = new JimuReportCategory();
            reportCategory.setId(startId);
            reportCategory.setUpdateTime(new Date());
            sortNoInt = sortType == 0 ? this.getMinSortByParentId(parentId, "").intValue() : this.a(updateSort, startId);
            reportCategory.setParentId(parentId);
            reportCategory.setSortNo(sortNoInt);
            this.updateById(reportCategory, jimuReportCategory.getParentId());
        }
    }

    private int a(String updateSort, String startId) {
        int sort = 0;
        JSONArray sortArray = JSONArray.parseArray((String)updateSort);
        for (int i2 = 0; i2 < sortArray.size(); ++i2) {
            String id = sortArray.getJSONObject(i2).getString("id");
            Integer sortNo = sortArray.getJSONObject(i2).getInteger("sortNo");
            if (id.equals(startId)) {
                sort = sortNo;
                continue;
            }
            this.categoryDao.updateSort(id, sortNo);
        }
        return sort;
    }

    @Override
    public Long queryReportCount(String categoryId) {
        Long reportCount = this.jimuReportDao.selectCountByCategoryId(categoryId);
        List<String> idsList = this.categoryDao.selectIdsByParentId(categoryId);
        HashMap<String, Long> reportCountMap = new HashMap<String, Long>();
        reportCountMap.put("reportCount", reportCount);
        this.a(idsList, reportCountMap);
        return (Long)reportCountMap.get("reportCount");
    }

    private void a(List<String> idsList, Map<String, Long> reportCountMap) {
        if (!CollectionUtils.isEmpty(idsList)) {
            for (String id : idsList) {
                List<String> childrenIdsList;
                Long count = this.jimuReportDao.selectCountByCategoryId(id);
                if (reportCountMap.containsKey("reportCount")) {
                    if (null != count) {
                        long reportCount = reportCountMap.get("reportCount") + count;
                        reportCountMap.put("reportCount", reportCount);
                    }
                } else {
                    reportCountMap.put("reportCount", null != count ? count : 0L);
                }
                if (CollectionUtils.isEmpty(childrenIdsList = this.categoryDao.selectIdsByParentId(id))) continue;
                this.a(childrenIdsList, reportCountMap);
            }
        }
    }
}

