/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.desreport.render.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.desreport.model.ReportDbInfo;
import org.jeecg.modules.jmreport.desreport.render.b.d;
import org.jeecg.modules.jmreport.desreport.render.utils.FreeMarkerUtils;
import org.jeecg.modules.jmreport.desreport.render.utils.RegexMatches;
import org.jeecg.modules.jmreport.desreport.util.JmReportUtil;
import org.jeecg.modules.jmreport.desreport.util.k;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportUtil {
    private static final Logger a = LoggerFactory.getLogger(ReportUtil.class);

    public static List<d> a(JSONObject rows) {
        LinkedList<d> list = new LinkedList<d>();
        for (Map.Entry rowEntry : rows.entrySet()) {
            List<d> groupColumnList;
            Object row = rowEntry.getValue();
            Object rowKey = rowEntry.getKey();
            if ("com.alibaba.fastjson2.JSONObject".equals(row.getClass().getName())) {
                row = JSONObject.parseObject((String)JSONObject.toJSONString(row), (Feature[])new Feature[]{Feature.OrderedField});
            }
            if (!(row instanceof JSONObject) || !OkConvertUtils.isNotEmpty(groupColumnList = ReportUtil.a((JSONObject)row, rowKey, "\\{([a-zA-Z0-9_\\u4e00-\\u9fa5]+).(\\S+)}"))) continue;
            list.addAll(groupColumnList);
        }
        return list;
    }

    public static List<d> a(JSONObject row, Object rowKey, String pattern) {
        LinkedList<d> list = new LinkedList<d>();
        JSONObject cells = row.getJSONObject("cells");
        if (cells instanceof JSONObject) {
            for (Map.Entry cellEntity : cells.entrySet()) {
                String fieldName;
                JSONObject cellObject = (JSONObject)cellEntity.getValue();
                if (!OkConvertUtils.isNotEmpty(cellObject)) continue;
                String cellText = cellObject.getString("text");
                String sort = OkConvertUtils.getString(cellObject.getString("sort"), "asc");
                if (!OkConvertUtils.isNotEmpty(cellText) || !OkConvertUtils.isNotEmpty(fieldName = RegexMatches.a(cellText, 2, pattern))) continue;
                Boolean flag2 = fieldName.indexOf("groupRight(") != -1;
                Boolean flag3 = fieldName.indexOf("group(") != -1;
                Boolean flag4 = fieldName.indexOf("customGroup(") != -1;
                if (!flag2.booleanValue() && !flag3.booleanValue() && !flag4.booleanValue()) continue;
                d groupColumn = new d();
                String column = RegexMatches.c(fieldName, 2).replace(")", "").replace("}", "");
                String suffix = cellText.substring(cellText.lastIndexOf("}") + 1);
                String dataSetKey = RegexMatches.a(cellText, 1);
                groupColumn.setDataSetKey(dataSetKey);
                groupColumn.setColumn(column);
                groupColumn.setSort(sort);
                groupColumn.setSuffixText(suffix);
                if (flag3.booleanValue()) {
                    groupColumn.setDirection("up");
                }
                if (flag2.booleanValue()) {
                    groupColumn.setDirection("right");
                }
                if (flag4.booleanValue()) {
                    groupColumn.setDirection("customGroup");
                }
                groupColumn.setRow(row);
                groupColumn.setRowKey(rowKey.toString());
                String textOrders = cellObject.getString("textOrders");
                if (OkConvertUtils.isNotEmpty(textOrders)) {
                    groupColumn.setTextOrders(textOrders);
                }
                list.add(groupColumn);
            }
        }
        return list;
    }

    public static Boolean a(String field, List<d> groupColumnList) {
        for (d groupColumn : groupColumnList) {
            String column = groupColumn.getNoSuffixColumn();
            if (!column.equals(field)) continue;
            return true;
        }
        return false;
    }

    public static void a(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            map.put(entry.getKey(), "0");
        }
    }

    public static List<Map<String, Object>> a(List<Map<String, Object>> list) {
        a.debug("----------\u8c03\u7528\u65b9\u6cd5 coverToJSONObject----------lise size: " + list.size());
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (OkConvertUtils.isNotEmpty(list)) {
            for (Map<String, Object> stringObjectMap : list) {
                JSONObject jsonObject = new JSONObject();
                stringObjectMap.forEach((key, value) -> {
                    if (OkConvertUtils.isNotEmpty(value)) {
                        if (value instanceof Clob) {
                            value = JmReportUtil.a((Clob)value);
                        } else if (value instanceof byte[]) {
                            value = new String((byte[])value);
                        } else if (value instanceof Blob) {
                            try {
                                if (value != null) {
                                    Blob valB = (Blob)value;
                                    value = new String(valB.getBytes(1L, (int)valB.length()), "UTF-8");
                                }
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                            }
                        } else if (value instanceof LocalDateTime) {
                            value = JmReportUtil.a((LocalDateTime)value);
                        } else if (value instanceof Timestamp) {
                            Timestamp timestamp = (Timestamp)value;
                            value = JmReportUtil.a(timestamp.toLocalDateTime());
                        } else if (value instanceof BigDecimal) {
                            BigDecimal bigDecimal = (BigDecimal)value;
                            value = bigDecimal.toPlainString();
                        }
                        jsonObject.put(key.toLowerCase(), (Object)value.toString());
                    } else {
                        jsonObject.put(key.toLowerCase(), (Object)"");
                    }
                });
                result.add((Map<String, Object>)jsonObject);
            }
        }
        return result;
    }

    public static JSONObject a(Map<String, Object> dataList, JSONObject json) {
        JSONArray qrcodeList;
        JSONArray barcodeList;
        String barcodeContent;
        String barcodeContentExp;
        JSONObject temp;
        JSONObject config = json.getJSONObject("displayConfig");
        if (config != null) {
            for (String key : config.keySet()) {
                temp = config.getJSONObject(key);
                String textExp = temp.getString("text");
                String textContent = ReportUtil.a(dataList, textExp);
                temp.put("text", (Object)textContent);
                barcodeContentExp = temp.getString("barcodeContent");
                barcodeContent = ReportUtil.a(dataList, barcodeContentExp);
                temp.put("barcodeContent", (Object)barcodeContent);
            }
        }
        if ((barcodeList = json.getJSONArray("barcodeList")) != null && barcodeList.size() > 0) {
            for (int i2 = 0; i2 < barcodeList.size(); ++i2) {
                temp = barcodeList.getJSONObject(i2);
                String jsonString = temp.getString("jsonString");
                JSONObject barCodeJson = JSONObject.parseObject((String)jsonString);
                barcodeContentExp = barCodeJson.getString("barcodeContent");
                barcodeContent = ReportUtil.a(dataList, barcodeContentExp);
                barCodeJson.put("barcodeContent", (Object)barcodeContent);
                temp.put("jsonString", (Object)barCodeJson.toJSONString());
            }
        }
        if ((qrcodeList = json.getJSONArray("qrcodeList")) != null && qrcodeList.size() > 0) {
            for (int i3 = 0; i3 < qrcodeList.size(); ++i3) {
                JSONObject temp2 = qrcodeList.getJSONObject(i3);
                String jsonString = temp2.getString("jsonString");
                JSONObject qrCodeJson = JSONObject.parseObject((String)jsonString);
                String textExp = qrCodeJson.getString("text");
                String textContent = ReportUtil.a(dataList, textExp);
                qrCodeJson.put("text", (Object)textContent);
                temp2.put("jsonString", (Object)qrCodeJson.toJSONString());
            }
        }
        return json;
    }

    private static String a(Map<String, Object> dataList, String express) {
        if (express != null && !"".equals(express)) {
            express = express.trim();
            String reg = "^\\$\\{([0-9a-zA-z_]+)\\.([0-9a-zA-z_]+)}$";
            Pattern p2 = Pattern.compile(reg);
            Matcher m2 = p2.matcher(express);
            if (m2.find()) {
                String dbCode = m2.group(1);
                String fieldName = m2.group(2);
                ReportDbInfo info = (ReportDbInfo)dataList.get(dbCode);
                List<Map<String, Object>> list = info.getList();
                if (OkConvertUtils.isNotEmpty(list)) {
                    Object content = list.get(0).get(fieldName);
                    if (content == null) {
                        return "";
                    }
                    return content.toString();
                }
            }
        }
        return express;
    }

    public static void main(String[] args) {
    }

    public static JSONObject a(JSONObject json, JSONObject paramsJson) {
        JSONObject rowJsons = json.getJSONObject("rows");
        for (String row : rowJsons.keySet()) {
            if ("cells".equals(row) || "isDrag".equals(row) || "len".equals(row) || "NaN".equals(row)) continue;
            JSONObject jsonObject = rowJsons.getJSONObject(row);
            JSONObject cellJson = jsonObject.getJSONObject("cells");
            for (String cell : cellJson.keySet()) {
                JSONObject cellTextJson;
                if ("-1".equals(cell) || !(cellTextJson = cellJson.getJSONObject(cell)).containsKey((Object)"text")) continue;
                String cellText = cellTextJson.getString("text");
                Pattern p2 = Pattern.compile("eval\\((.*)\\)");
                Matcher m2 = p2.matcher(cellText);
                if (m2.find()) {
                    throw new RuntimeException("\u5b58\u5728XSS\u653b\u51fb\uff0c\u8bf7\u68c0\u67e5\u8bbe\u8ba1\u9875\u9762");
                }
                if (cellText.trim().length() > 0) {
                    cellText = cellText.trim();
                }
                a.debug("param\u53c2\u6570\u66ff\u6362\u6587\u672c\u521d\u59cb: " + cellText);
                if (!cellText.contains("${param.")) continue;
                a.debug("param\u53c2\u6570\u66ff\u6362\u6587\u672c = " + cellText);
                String textDate = cellText;
                textDate = textDate.replaceAll("\\$\\{", "\u262f{");
                textDate = textDate.replaceAll("\u262f\\{param\\.", "\\${param.");
                HashMap<String, Object> map = new HashMap<String, Object>(5);
                map.put("param", paramsJson);
                textDate = FreeMarkerUtils.a(textDate, map);
                if ((textDate = textDate.replaceAll("\u262f\\{", "\\${")).equals(cellText)) continue;
                a.debug("param\u53c2\u6570\u66ff\u6362\u4e4b\u540e\u6587\u672c = " + textDate);
                cellTextJson.put("text", (Object)textDate);
            }
        }
        return json;
    }

    public static void a(JSONObject cellTextJson, String cellText) {
        if (k.m.matcher(cellText).find()) {
            Matcher countNzMatcher = k.o.matcher(cellText);
            StringBuffer modifiedText = new StringBuffer();
            boolean modified = false;
            while (countNzMatcher.find()) {
                String countNzExpr = countNzMatcher.group(1);
                Matcher dataSetMatcher = k.n.matcher(countNzExpr);
                ArrayList<String> textList = new ArrayList<String>();
                boolean replaceText = false;
                String modifiedCountNzExpr = countNzExpr;
                while (dataSetMatcher.find()) {
                    String text = dataSetMatcher.group(2) != null ? dataSetMatcher.group(2) : dataSetMatcher.group(3);
                    if (!OkConvertUtils.isNotEmpty(text) || textList.contains(text)) continue;
                    modifiedCountNzExpr = modifiedCountNzExpr.replace("{" + text + "}", "{((" + text + "!'')?length>0)?string((" + text + "!''),'nil')}");
                    textList.add(text);
                    replaceText = true;
                }
                if (replaceText) {
                    countNzMatcher.appendReplacement(modifiedText, Matcher.quoteReplacement(modifiedCountNzExpr));
                    modified = true;
                    continue;
                }
                countNzMatcher.appendReplacement(modifiedText, Matcher.quoteReplacement(countNzExpr));
            }
            countNzMatcher.appendTail(modifiedText);
            if (modified) {
                a.debug("\u8868\u8fbe\u5f0f\u66ff\u6362\u540e\u7684\u6587\u672c\uff1a{}", (Object)modifiedText.toString());
                cellTextJson.put("text", (Object)modifiedText.toString());
            }
        }
    }
}

