/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.desreport.render.method;

import com.googlecode.aviator.AviatorEvaluator;
import freemarker.ext.beans.HashAdapter;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.desreport.render.utils.RegexMatches;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerMethod {
    private static final Logger log = LoggerFactory.getLogger(FreemarkerMethod.class);

    public String min(List<HashAdapter> list, Object obj, String field) {
        Double d2 = list.stream().mapToDouble(o2 -> Double.parseDouble(o2.get((Object)field).toString())).min().getAsDouble();
        return d2.toString();
    }

    public String max(List<HashAdapter> list, Object obj, String field) {
        Double d2 = list.stream().mapToDouble(o2 -> Double.parseDouble(o2.get((Object)field).toString())).max().getAsDouble();
        return d2.toString();
    }

    public String sum(List<HashAdapter> list, Object obj, String field) {
        List<String> fields = RegexMatches.g(field);
        BigDecimal result = new BigDecimal("0");
        if (OkConvertUtils.isNotEmpty(fields)) {
            for (String s : fields) {
                Double d2 = list.stream().mapToDouble(o2 -> {
                    Object r2 = o2.get((Object)s);
                    if (OkConvertUtils.isNotEmpty(r2)) {
                        return Double.parseDouble(o2.get((Object)s).toString());
                    }
                    return 0.0;
                }).sum();
                result = result.add(new BigDecimal(d2));
            }
        }
        return result.toString();
    }

    public String compute(List<HashAdapter> list, Object obj, String field) {
        List<String> fields = RegexMatches.g(field);
        BigDecimal result = new BigDecimal("0");
        HashAdapter map = (HashAdapter)obj;
        if (OkConvertUtils.isNotEmpty(fields)) {
            List<String> fieldList = RegexMatches.g(field);
            HashMap<String, Number> params = new HashMap<String, Number>(5);
            if (OkConvertUtils.isNotEmpty(fieldList)) {
                for (String s : fieldList) {
                    Object o2 = map.get((Object)(s = s.replace("(", "").replace(")", "")));
                    if (OkConvertUtils.isNotEmpty(o2)) {
                        params.put(s, new BigDecimal(o2.toString()));
                        continue;
                    }
                    params.put(s, 0);
                }
            }
            try {
                Object o3 = AviatorEvaluator.execute((String)field, params);
                if (!OkConvertUtils.isNotEmpty(o3)) {
                    return "";
                }
                result = new BigDecimal(o3.toString());
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), (Throwable)e2);
                String error = "Division undefined";
                String message = e2.getMessage();
                if (StringUtils.isNotBlank((CharSequence)message) && (message.contains(error) || message.contains("Division by zero"))) {
                    return "0";
                }
                return "";
            }
        }
        return result.toPlainString();
    }

    public String average(List<HashAdapter> list, Object obj, String field) {
        Double d2 = list.stream().mapToDouble(o2 -> Double.parseDouble(o2.get((Object)field).toString())).average().getAsDouble();
        return d2.toString();
    }
}

