/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.desreport.b;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.jeecg.modules.jmreport.desreport.entity.JimuReport;
import org.jeecg.modules.jmreport.desreport.entity.JimuReportSheet;
import org.jeecg.modules.jmreport.desreport.service.IJimuReportService;
import org.jeecg.modules.jmreport.desreport.service.IJimuReportSheetService;
import org.jeecgframework.minidao.util.SnowflakeIdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="jimuReportSheetController")
@RequestMapping(value={"/jmreport/sheet"})
public class j {
    private static final Logger a = LoggerFactory.getLogger(j.class);
    @Autowired
    private IJimuReportService jmReportDesignService;
    @Autowired
    private IJimuReportSheetService jimuReportSheetService;

    @GetMapping(value={"/getSheetList/{id}"})
    public Result<?> a(@PathVariable(value="id") String id) {
        try {
            JimuReport report = this.jmReportDesignService.getById(id);
            if (report == null) {
                return Result.error("\u62a5\u8868\u4e0d\u5b58\u5728");
            }
            List<JimuReportSheet> sheets = this.jimuReportSheetService.getAllSheets(report);
            ArrayList result = new ArrayList();
            for (JimuReportSheet sheet : sheets) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", sheet.getId());
                map.put("name", sheet.getSheetName());
                map.put("order", sheet.getSheetOrder());
                result.add(map);
            }
            return Result.OK(result);
        }
        catch (Exception e2) {
            a.error("\u83b7\u53d6sheet\u5217\u8868\u5931\u8d25", (Throwable)e2);
            return Result.error("\u83b7\u53d6sheet\u5217\u8868\u5931\u8d25\uff1a" + e2.getMessage());
        }
    }

    @PostMapping(value={"/addSheet"})
    public Result<?> a(@RequestBody JSONObject jsonObject) {
        try {
            String reportId = jsonObject.getString("reportId");
            String sheetName = jsonObject.getString("sheetName");
            Integer order = jsonObject.getInteger("order");
            if (OkConvertUtils.isEmpty(reportId)) {
                return Result.error("\u62a5\u8868ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (OkConvertUtils.isEmpty(sheetName)) {
                return Result.error("Sheet\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            JimuReport report = this.jmReportDesignService.getById(reportId);
            if (report == null) {
                return Result.error("\u62a5\u8868\u4e0d\u5b58\u5728");
            }
            String sheetId = String.valueOf(SnowflakeIdWorker.generateId());
            return Result.OK(sheetId);
        }
        catch (Exception e2) {
            a.error("\u65b0\u589esheet\u5931\u8d25", (Throwable)e2);
            return Result.error("\u65b0\u589esheet\u5931\u8d25\uff1a" + e2.getMessage());
        }
    }

    @DeleteMapping(value={"/deleteSheet"})
    public Result<?> a(@RequestParam(name="reportId") String reportId, @RequestParam(name="sheetId") String sheetId) {
        try {
            if (OkConvertUtils.isEmpty(reportId) || OkConvertUtils.isEmpty(sheetId)) {
                return Result.error("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            JimuReport report = this.jmReportDesignService.getById(reportId);
            if (report == null) {
                return Result.error("\u62a5\u8868\u4e0d\u5b58\u5728");
            }
            this.jimuReportSheetService.deleteSheet(report, sheetId);
            this.jmReportDesignService.updateById(report);
            return Result.OK("\u5220\u9664\u6210\u529f", null);
        }
        catch (JimuReportException e2) {
            return Result.error(e2.getMessage());
        }
        catch (Exception e3) {
            a.error("\u5220\u9664sheet\u5931\u8d25", (Throwable)e3);
            return Result.error("\u5220\u9664sheet\u5931\u8d25\uff1a" + e3.getMessage());
        }
    }

    @PostMapping(value={"/renameSheet"})
    public Result<?> b(@RequestBody JSONObject jsonObject) {
        try {
            String reportId = jsonObject.getString("reportId");
            String sheetId = jsonObject.getString("sheetId");
            String newName = jsonObject.getString("newName");
            if (OkConvertUtils.isEmpty(reportId) || OkConvertUtils.isEmpty(sheetId) || OkConvertUtils.isEmpty(newName)) {
                return Result.error("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            JimuReport report = this.jmReportDesignService.getById(reportId);
            if (report == null) {
                return Result.error("\u62a5\u8868\u4e0d\u5b58\u5728");
            }
            this.jimuReportSheetService.renameSheet(report, sheetId, newName);
            return Result.OK("\u91cd\u547d\u540d\u6210\u529f", null);
        }
        catch (JimuReportException e2) {
            return Result.error(e2.getMessage());
        }
        catch (Exception e3) {
            a.error("\u91cd\u547d\u540dsheet\u5931\u8d25", (Throwable)e3);
            return Result.error("\u91cd\u547d\u540dsheet\u5931\u8d25\uff1a" + e3.getMessage());
        }
    }

    @PostMapping(value={"/reorderSheets"})
    public Result<?> c(@RequestBody JSONObject jsonObject) {
        try {
            String reportId = jsonObject.getString("reportId");
            List sheetIds = jsonObject.getJSONArray("sheetIds").toJavaList(String.class);
            if (OkConvertUtils.isEmpty(reportId) || sheetIds == null || sheetIds.isEmpty()) {
                return Result.error("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            JimuReport report = this.jmReportDesignService.getById(reportId);
            if (report == null) {
                return Result.error("\u62a5\u8868\u4e0d\u5b58\u5728");
            }
            this.jimuReportSheetService.reorderSheets(report, sheetIds);
            return Result.OK("\u8c03\u6574\u987a\u5e8f\u6210\u529f", null);
        }
        catch (Exception e2) {
            a.error("\u8c03\u6574\u987a\u5e8f\u5931\u8d25", (Throwable)e2);
            return Result.error("\u8c03\u6574\u987a\u5e8f\u5931\u8d25\uff1a" + e2.getMessage());
        }
    }

    @GetMapping(value={"/getSheetData"})
    public Result<?> b(@RequestParam(name="reportId") String reportId, @RequestParam(name="sheetId") String sheetId) {
        try {
            if (OkConvertUtils.isEmpty(reportId) || OkConvertUtils.isEmpty(sheetId)) {
                return Result.error("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            JimuReport report = this.jmReportDesignService.getById(reportId);
            if (report == null) {
                return Result.error("\u62a5\u8868\u4e0d\u5b58\u5728");
            }
            JSONObject sheetJsonStr = this.jimuReportSheetService.getSheetJsonStr(report, sheetId);
            return Result.OK(sheetJsonStr);
        }
        catch (Exception e2) {
            a.error("\u83b7\u53d6sheet\u6570\u636e\u5931\u8d25", (Throwable)e2);
            return Result.error("\u83b7\u53d6sheet\u6570\u636e\u5931\u8d25\uff1a" + e2.getMessage());
        }
    }
}

