/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.desreport.b;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import org.jeecg.modules.jmreport.common.annotation.Logical;
import org.jeecg.modules.jmreport.common.annotation.RequiresRoles;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.jeecg.modules.jmreport.desreport.entity.JimuReport;
import org.jeecg.modules.jmreport.desreport.entity.JimuReportExtData;
import org.jeecg.modules.jmreport.desreport.model.JmPage;
import org.jeecg.modules.jmreport.desreport.service.IJimuReportExtDataService;
import org.jeecg.modules.jmreport.desreport.service.IJimuReportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="jimuReportGroupController")
@RequestMapping(value={"/jmreport/group"})
public class f {
    private static final Logger a = LoggerFactory.getLogger(f.class);
    @Autowired
    private IJimuReportExtDataService jimuReportExtDataService;
    @Autowired
    private IJimuReportService jimuReportService;

    @GetMapping(value={"/query"})
    @RequiresRoles(value={"admin", "lowdeveloper"}, logical=Logical.OR)
    public Result<?> a(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="name", required=false) String name) {
        try {
            JmPage<JimuReportExtData> page;
            JimuReportExtData queryParam = new JimuReportExtData();
            queryParam.setBizType("report_group");
            if (OkConvertUtils.isNotEmpty(name)) {
                queryParam.setName("%" + name + "%");
            }
            if ((page = this.jimuReportExtDataService.pageList(queryParam, pageNo, pageSize)).getRecords() != null) {
                for (Object obj : page.getRecords()) {
                    JimuReportExtData item = (JimuReportExtData)obj;
                    if (!OkConvertUtils.isNotEmpty(item.getDataValue())) continue;
                    try {
                        JSONArray reportDataArray = JSONArray.parseArray((String)item.getDataValue());
                        ArrayList<String> reportDisplayList = new ArrayList<String>();
                        for (int i2 = 0; i2 < reportDataArray.size(); ++i2) {
                            JSONObject reportData = reportDataArray.getJSONObject(i2);
                            if (reportData == null || !reportData.containsKey((Object)"reportId")) continue;
                            String reportId = reportData.getString("reportId");
                            JimuReport report = this.jimuReportService.getById(reportId);
                            if (report != null) {
                                StringBuilder displayText = new StringBuilder(report.getName());
                                reportDisplayList.add(displayText.toString());
                                continue;
                            }
                            reportDisplayList.add(reportId);
                        }
                        item.setReportNames(String.join((CharSequence)" / ", reportDisplayList));
                    }
                    catch (Exception e2) {
                        a.warn("\u89e3\u6790\u62a5\u8868\u7ec4\u6570\u636e\u5931\u8d25\uff0cid: " + item.getId(), (Throwable)e2);
                    }
                }
            }
            return Result.OK("", page);
        }
        catch (Exception e3) {
            a.error("\u67e5\u8be2\u62a5\u8868\u7ec4\u5217\u8868\u5931\u8d25", (Throwable)e3);
            return Result.error("\u67e5\u8be2\u62a5\u8868\u7ec4\u5217\u8868\u5931\u8d25\uff1a" + e3.getMessage());
        }
    }

    @GetMapping(value={"/get"})
    @RequiresRoles(value={"admin", "lowdeveloper"}, logical=Logical.OR)
    public Result<?> a(@RequestParam(value="id") String id) {
        try {
            JimuReportExtData extData = this.jimuReportExtDataService.getById(id);
            if (extData == null) {
                return Result.error("\u62a5\u8868\u7ec4\u4e0d\u5b58\u5728");
            }
            if (OkConvertUtils.isNotEmpty(extData.getDataValue())) {
                try {
                    JSONArray reportDataArray = JSONArray.parseArray((String)extData.getDataValue());
                    ArrayList<String> reportIdList = new ArrayList<String>();
                    for (int i2 = 0; i2 < reportDataArray.size(); ++i2) {
                        JSONObject reportData = reportDataArray.getJSONObject(i2);
                        if (reportData == null || !reportData.containsKey((Object)"reportId")) continue;
                        reportIdList.add(reportData.getString("reportId"));
                    }
                    extData.setReportIds(String.join((CharSequence)",", reportIdList));
                }
                catch (Exception e2) {
                    a.warn("\u89e3\u6790\u62a5\u8868\u7ec4\u6570\u636e\u5931\u8d25\uff0cid: " + id, (Throwable)e2);
                }
            }
            return Result.OK("", extData);
        }
        catch (Exception e3) {
            a.error("\u67e5\u8be2\u62a5\u8868\u7ec4\u8be6\u60c5\u5931\u8d25", (Throwable)e3);
            return Result.error("\u67e5\u8be2\u62a5\u8868\u7ec4\u8be6\u60c5\u5931\u8d25\uff1a" + e3.getMessage());
        }
    }

    @PostMapping(value={"/save"})
    @RequiresRoles(value={"admin", "lowdeveloper"}, logical=Logical.OR)
    public Result<?> a(@RequestBody JimuReportExtData jimuReportExtData) {
        try {
            jimuReportExtData.setBizType("report_group");
            if (OkConvertUtils.isEmpty(jimuReportExtData.getDataValue())) {
                jimuReportExtData.setDataValue("[]");
            }
            this.jimuReportExtDataService.save(jimuReportExtData);
            return Result.OK("\u4fdd\u5b58\u6210\u529f", null);
        }
        catch (Exception e2) {
            a.error("\u4fdd\u5b58\u62a5\u8868\u7ec4\u5931\u8d25", (Throwable)e2);
            return Result.error("\u4fdd\u5b58\u62a5\u8868\u7ec4\u5931\u8d25\uff1a" + e2.getMessage());
        }
    }

    @DeleteMapping(value={"/delete"})
    @RequiresRoles(value={"admin", "lowdeveloper"}, logical=Logical.OR)
    public Result<?> b(@RequestParam(value="id") String id) {
        try {
            this.jimuReportExtDataService.deleteById(id);
            return Result.OK("\u5220\u9664\u6210\u529f", null);
        }
        catch (Exception e2) {
            a.error("\u5220\u9664\u62a5\u8868\u7ec4\u5931\u8d25", (Throwable)e2);
            return Result.error("\u5220\u9664\u62a5\u8868\u7ec4\u5931\u8d25\uff1a" + e2.getMessage());
        }
    }
}

