/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.desreport.b;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.modules.jmreport.common.constant.a;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.jeecg.modules.jmreport.config.JmReportBaseConfig;
import org.jeecg.modules.jmreport.config.client.JmReportTokenClient;
import org.jeecg.modules.jmreport.desreport.entity.JimuReportDict;
import org.jeecg.modules.jmreport.desreport.model.JmPage;
import org.jeecg.modules.jmreport.desreport.service.IJimuReportDictService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="jimuReportDictController")
@RequestMapping(value={"/jmreport/dict"})
public class d {
    @Autowired
    private IJimuReportDictService dictService;
    @Autowired
    private JmReportTokenClient jimuTokenClient;
    @Autowired
    private JmReportBaseConfig jmBaseConfig;

    @GetMapping(value={"/list"})
    public Result<JmPage<JimuReportDict>> a(JimuReportDict report, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result<JmPage<JimuReportDict>> result = new Result<JmPage<JimuReportDict>>();
        if ("created".equals(this.jmBaseConfig.getSaasMode())) {
            String username = OkConvertUtils.getString(this.jimuTokenClient.getUsername(req), "\u83b7\u53d6\u4e0d\u5230\u7528\u6237\u8d26\u53f7");
            report.setCreateBy(username);
        }
        if ("tenant".equals(this.jmBaseConfig.getSaasMode())) {
            String tenantId = OkConvertUtils.getString(this.jimuTokenClient.getTenantId(), "\u83b7\u53d6\u4e0d\u5230\u79df\u6237ID");
            report.setTenantId(tenantId);
        }
        report.setDelFlag(a.b);
        JmPage<JimuReportDict> page = this.dictService.queryPageList(report, pageNo, pageSize);
        result.setSuccess(true);
        result.setResult(page);
        return result;
    }

    @PostMapping(value={"/add"})
    public Result<JimuReportDict> a(@RequestBody JimuReportDict reportDict, HttpServletRequest req) {
        Result<JimuReportDict> result = new Result<JimuReportDict>();
        String username = this.jimuTokenClient.getUsername(req);
        Integer dictCount = this.dictService.getDictCount(reportDict.getDictCode());
        if (dictCount > 0) {
            result.setSuccess(false);
            result.setMessage("\u5b57\u5178\u7f16\u7801\u5df2\u5b58\u5728\uff01");
            return result;
        }
        reportDict.setCreateTime(new Date());
        reportDict.setDelFlag(a.b);
        reportDict.setCreateBy(username);
        reportDict.setType(a.b);
        this.dictService.save(reportDict);
        result.setSuccess(true);
        result.success("\u4fdd\u5b58\u6210\u529f\uff01");
        return result;
    }

    @PostMapping(value={"/edit"})
    @CacheEvict(value={"jmreport:cache:dict", "jmreport:cache:dictTxt"}, allEntries=true)
    public Result<JimuReportDict> a(@RequestBody JimuReportDict reportDict) {
        Result<JimuReportDict> result = new Result<JimuReportDict>();
        JimuReportDict sysdict = this.dictService.getById(reportDict.getId());
        Integer dictCount = this.dictService.getEditDictCount(reportDict.getDictCode(), reportDict.getId());
        if (dictCount > 0) {
            result.setSuccess(false);
            result.setMessage("\u5b57\u5178\u7f16\u7801\u5df2\u5b58\u5728\uff01");
            return result;
        }
        if (sysdict == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            reportDict.setType(a.b);
            reportDict.setUpdateTime(new Date());
            int i2 = this.dictService.updateById(reportDict);
            if (i2 > 0) {
                result.success("\u7f16\u8f91\u6210\u529f!");
            }
        }
        return result;
    }

    @DeleteMapping(value={"/delete"})
    public Result<JimuReportDict> a(@RequestParam(name="id") String id) {
        Result<JimuReportDict> result = new Result<JimuReportDict>();
        int i2 = this.dictService.updateDictDelFlag(a.a, id);
        if (i2 > 0) {
            result.success("\u5220\u9664\u6210\u529f!");
        } else {
            result.error500("\u5220\u9664\u5931\u8d25!");
        }
        return result;
    }

    @DeleteMapping(value={"/thoroughDelete"})
    @CacheEvict(value={"jmreport:cache:dict", "jmreport:cache:dictTxt"}, allEntries=true)
    public Result<?> b(@RequestParam(name="id") String id) {
        try {
            this.dictService.deleteOneDictPhysically(id);
            return Result.OK("\u5220\u9664\u6210\u529f!", null);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return Result.error("\u5220\u9664\u5931\u8d25!");
        }
    }

    @DeleteMapping(value={"/deleteBatch"})
    @CacheEvict(value={"jmreport:cache:dict", "jmreport:cache:dictTxt"}, allEntries=true)
    public Result<JimuReportDict> c(@RequestParam(name="ids") String ids) {
        Result<JimuReportDict> result = new Result<JimuReportDict>();
        if (OkConvertUtils.isEmpty(ids)) {
            result.error500("\u53c2\u6570\u4e0d\u8bc6\u522b\uff01");
        } else {
            this.dictService.updateDelFlagByIds(ids);
            result.success("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }

    @GetMapping(value={"/refleshCache"})
    @CacheEvict(value={"jmreport:cache:dict", "jmreport:cache:dictTxt"}, allEntries=true)
    public Result<String> a(HttpServletRequest request) {
        Result result = new Result();
        String username = this.jimuTokenClient.getUsername(request);
        return Result.OK("\u5237\u65b0\u7f13\u5b58\u6210\u529f!");
    }

    @GetMapping(value={"/deleteList"})
    public Result<List<JimuReportDict>> b(HttpServletRequest req) {
        String username = "";
        Result<List<JimuReportDict>> result = new Result<List<JimuReportDict>>();
        if ("created".equals(this.jmBaseConfig.getSaasMode())) {
            username = OkConvertUtils.getString(this.jimuTokenClient.getUsername(req), "\u83b7\u53d6\u4e0d\u5230\u7528\u6237\u8d26\u53f7");
        }
        String tenantId = "";
        if ("tenant".equals(this.jmBaseConfig.getSaasMode())) {
            tenantId = OkConvertUtils.getString(this.jimuTokenClient.getTenantId(), "\u83b7\u53d6\u4e0d\u5230\u79df\u6237ID");
        }
        List<JimuReportDict> list = this.dictService.queryDeleteList(username, tenantId);
        result.setSuccess(true);
        result.setResult(list);
        return result;
    }

    @PostMapping(value={"/back"})
    @CacheEvict(value={"jmreport:cache:dict", "jmreport:cache:dictTxt"}, allEntries=true)
    public Result<?> b(@RequestBody JimuReportDict reportDict) {
        try {
            this.dictService.updateDictDelFlag(a.b, reportDict.getId());
            return Result.OK("\u53d6\u56de\u6210\u529f!", null);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return Result.error("\u64cd\u4f5c\u5931\u8d25!");
        }
    }

    @PostMapping(value={"/batchRevert"})
    @CacheEvict(value={"jmreport:cache:dict", "jmreport:cache:dictTxt"}, allEntries=true)
    public Result<?> d(@RequestParam(name="ids") String ids) {
        try {
            this.dictService.updateBatchDictDelFlag(Arrays.asList(ids.split(",")));
            return Result.OK("\u53d6\u56de\u6210\u529f!", null);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return Result.error("\u64cd\u4f5c\u5931\u8d25!");
        }
    }

    @DeleteMapping(value={"/batchRealDelete"})
    @CacheEvict(value={"jmreport:cache:dict", "jmreport:cache:dictTxt"}, allEntries=true)
    public Result<?> e(@RequestParam(name="ids") String ids) {
        try {
            this.dictService.batchRealDelete(Arrays.asList(ids.split(",")));
            return Result.OK("\u6279\u91cf\u5220\u9664\u6210\u529f!", null);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return Result.error("\u64cd\u4f5c\u5931\u8d25!");
        }
    }
}

