/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.config.oss;

import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.util.a.a;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component(value="jimuMinioConfig")
@ConfigurationProperties(prefix="jeecg.minio")
@ConditionalOnProperty(value={"jeecg.uploadType"}, havingValue="minio", matchIfMissing=true)
public class JimuMinioConfig {
    private static final Logger log = LoggerFactory.getLogger(JimuMinioConfig.class);
    private String minioUrl;
    private String minioName;
    private String minioPass;
    private String bucketName;

    @Bean
    public JimuMinioConfig initJimuMinio() {
        if (OkConvertUtils.isNotEmpty(this.minioUrl)) {
            if (!this.minioUrl.startsWith("http")) {
                this.minioUrl = "http://" + this.minioUrl;
            }
            if (!this.minioUrl.endsWith("/")) {
                this.minioUrl = this.minioUrl.concat("/");
            }
        }
        try {
            a.setMinioUrl(this.minioUrl);
            a.setMinioName(this.minioName);
            a.setMinioPass(this.minioPass);
            a.setBucketName(this.bucketName);
        }
        catch (NoClassDefFoundError e2) {
            log.error("[JimuReport] \u52a0\u8f7d\u4e0a\u4f20\u914d\u7f6e\u5931\u8d25\uff0cMinio\u7248\u672c\u4e0d\u5339\u914d\uff0c\u8bf7\u5347\u7ea7Minio\u4f9d\u8d56\u52308.0.3+", (Throwable)e2);
        }
        return new JimuMinioConfig();
    }

    public String getMinioUrl() {
        return this.minioUrl;
    }

    public String getMinioName() {
        return this.minioName;
    }

    public String getMinioPass() {
        return this.minioPass;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setMinioUrl(String minioUrl) {
        this.minioUrl = minioUrl;
    }

    public void setMinioName(String minioName) {
        this.minioName = minioName;
    }

    public void setMinioPass(String minioPass) {
        this.minioPass = minioPass;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof JimuMinioConfig)) {
            return false;
        }
        JimuMinioConfig other = (JimuMinioConfig)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$minioUrl = this.getMinioUrl();
        String other$minioUrl = other.getMinioUrl();
        if (this$minioUrl == null ? other$minioUrl != null : !this$minioUrl.equals(other$minioUrl)) {
            return false;
        }
        String this$minioName = this.getMinioName();
        String other$minioName = other.getMinioName();
        if (this$minioName == null ? other$minioName != null : !this$minioName.equals(other$minioName)) {
            return false;
        }
        String this$minioPass = this.getMinioPass();
        String other$minioPass = other.getMinioPass();
        if (this$minioPass == null ? other$minioPass != null : !this$minioPass.equals(other$minioPass)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        return !(this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JimuMinioConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $minioUrl = this.getMinioUrl();
        result = result * 59 + ($minioUrl == null ? 43 : $minioUrl.hashCode());
        String $minioName = this.getMinioName();
        result = result * 59 + ($minioName == null ? 43 : $minioName.hashCode());
        String $minioPass = this.getMinioPass();
        result = result * 59 + ($minioPass == null ? 43 : $minioPass.hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        return result;
    }

    public String toString() {
        return "JimuMinioConfig(minioUrl=" + this.getMinioUrl() + ", minioName=" + this.getMinioName() + ", minioPass=" + this.getMinioPass() + ", bucketName=" + this.getBucketName() + ")";
    }
}

