/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.config.init;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import org.jeecg.modules.jmreport.common.a.a;
import org.jeecg.modules.jmreport.common.expetion.JimuAlertException;
import org.jeecg.modules.jmreport.common.interceptor.JimuReportSignatureInterceptor;
import org.jeecg.modules.jmreport.common.util.JimuI18nUtils;
import org.jeecg.modules.jmreport.config.firewall.interceptor.JimuReportTokenInterceptor;
import org.jeecg.modules.jmreport.config.firewall.interceptor.handlers.JmIPermissionsVerifyHandler;
import org.jeecg.modules.jmreport.config.init.LogoPrinter;
import org.jeecg.modules.jmreport.config.locale.JimuLocaleInterceptor;
import org.jeecg.modules.jmreport.config.locale.JimuLocaleResolver;
import org.jeecg.modules.jmreport.config.oss.JmReportUploadConfig;
import org.jeecg.modules.jmreport.desreport.render.echarts.IJimuEchartsRender;
import org.jeecg.modules.jmreport.desreport.render.echarts.model.JimuEchartsRenderParams;
import org.jeecg.modules.jmreport.desreport.service.IJmreportNoSqlService;
import org.jeecg.modules.jmreport.dyndb.vo.JmreportDynamicDataSourceVo;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.http.CacheControl;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(value="jimuReportConfiguration")
@PropertySource(value={"classpath:config/default-config.properties"})
@ComponentScan(basePackages={"org.jeecg.modules.jmreport", "org.jeecg.modules.drag"})
public class JimuReportConfiguration
implements InitializingBean,
WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(JimuReportConfiguration.class);
    @Autowired
    private JmReportUploadConfig jmReportUploadConfig;

    @Bean(value={"jmPermissionsVerifyHandler"})
    JmIPermissionsVerifyHandler jmPermissionsVerifyHandler() {
        return new JmIPermissionsVerifyHandler();
    }

    @Bean
    public JimuReportTokenInterceptor jimuReportInterceptor() {
        return new JimuReportTokenInterceptor();
    }

    @Bean
    public JimuReportSignatureInterceptor jmSignatureInterceptor() {
        return new JimuReportSignatureInterceptor();
    }

    @Bean
    public Filter jmFilter() {
        LogoPrinter.print();
        return new a();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        String[] excludes = new String[]{"/*.js", "/*.css", "/*.svg", "/*.pdf", "/*.jpg", "/*.png", "/*.ico", "/*.html", "/html/**", "/js/**", "/css/**", "/images/**"};
        registry.addInterceptor((HandlerInterceptor)this.jimuReportInterceptor()).excludePathPatterns(excludes).addPathPatterns(new String[]{"/jmreport/**", "/drag/**"});
        registry.addInterceptor((HandlerInterceptor)this.jmSignatureInterceptor()).excludePathPatterns(excludes).addPathPatterns(new String[]{"/jmreport/**", "/drag/**"});
        try {
            registry.addInterceptor((HandlerInterceptor)this.jimuLocaleInterceptor());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Bean
    public FilterRegistrationBean jmFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter(this.jmFilter());
        registration.setName("jmFilter");
        registration.addUrlPatterns(new String[]{"/jmreport/queryFieldBySql", "/jmreport/loadTableData", "/jmreport/show", "/jmreport/exportPdfStream", "/jmreport/exportAllExcelStream", "/jmreport/qurestSql", "/jmreport/map/queryMapByCode", "/jmreport/qurestApi", "/jmreport/getCharData", "/jmreport/testConnection", "/jmreport/save", "/jmreport/form/submit", "/jmreport/getQueryInfo"});
        return registration;
    }

    public void afterPropertiesSet() throws Exception {
        log.info(" Init JimuReport Config [ Token Interceptor & Resource Locations ] ");
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/jmreport/desreport_/**"}).addResourceLocations(new String[]{"classpath:/static/jmreport/desreport_/"}).setCacheControl(CacheControl.maxAge((long)30L, (TimeUnit)TimeUnit.DAYS));
        registry.addResourceHandler(new String[]{"/drag/lib/**"}).addResourceLocations(new String[]{"classpath:/static/drag/lib/"}).setCacheControl(CacheControl.maxAge((long)30L, (TimeUnit)TimeUnit.DAYS));
        registry.addResourceHandler(new String[]{"/drag/list/**"}).addResourceLocations(new String[]{"classpath:/static/drag/list/"}).setCacheControl(CacheControl.maxAge((long)30L, (TimeUnit)TimeUnit.DAYS));
        registry.addResourceHandler(new String[]{"/jmreport/img/**"}).addResourceLocations(new String[]{"file:" + this.jmReportUploadConfig.getPath().getUpload() + "//"}).setCacheControl(CacheControl.maxAge((long)10L, (TimeUnit)TimeUnit.DAYS));
    }

    @Bean(name={"jmTaskScheduler"})
    protected TaskScheduler jmTaskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(8);
        scheduler.setThreadNamePrefix("scheduled-thread-jm-");
        return scheduler;
    }

    @Bean(name={"jmreportNoSqlServiceImpl"})
    @ConditionalOnMissingBean(value={IJmreportNoSqlService.class})
    public IJmreportNoSqlService defaultJmreportNoSqlService() {
        return new IJmreportNoSqlService(){

            @Override
            public List<Map<String, Object>> findList(String sql, String dbKey) {
                throw new JimuAlertException("\u4e0d\u652f\u6301\u7684\u67e5\u8be2\uff0c\u8bf7\u5148\u4f9d\u8d56NoSQL\u6269\u5c55\u6a21\u5757!");
            }

            @Override
            public Boolean testConnection(JmreportDynamicDataSourceVo dbSource) {
                throw new JimuAlertException("\u4e0d\u652f\u6301\u7684\u67e5\u8be2\uff0c\u8bf7\u5148\u4f9d\u8d56NoSQL\u6269\u5c55\u6a21\u5757!");
            }

            @Override
            public List<Map<String, Object>> findListByCalcite(String dbKey, String sql, Map<String, Object> param) {
                throw new JimuAlertException("\u4e0d\u652f\u6301\u7684\u67e5\u8be2\uff0c\u8bf7\u5148\u4f9d\u8d56NoSQL\u6269\u5c55\u6a21\u5757!");
            }

            @Override
            public Object findOneByCalcite(String dbKey, String sql, Map<String, Object> param) {
                throw new JimuAlertException("\u4e0d\u652f\u6301\u7684\u67e5\u8be2\uff0c\u8bf7\u5148\u4f9d\u8d56NoSQL\u6269\u5c55\u6a21\u5757!");
            }
        };
    }

    @Bean(name={"jimuI18nUtils"})
    @ConditionalOnProperty(name={"jeecg.jmreport.i18n.enable"}, havingValue="true", matchIfMissing=false)
    public JimuI18nUtils jimuI18nUtils() {
        return new JimuI18nUtils();
    }

    @Bean(name={"jimuLocaleInterceptor"})
    @ConditionalOnProperty(name={"jeecg.jmreport.i18n.enable"}, havingValue="true", matchIfMissing=false)
    public JimuLocaleInterceptor jimuLocaleInterceptor() {
        return new JimuLocaleInterceptor(new JimuLocaleResolver());
    }

    @Bean(name={"jimuEchartsRender"})
    @ConditionalOnMissingBean(value={IJimuEchartsRender.class})
    public IJimuEchartsRender defaultIJimuEchartsRender() {
        return new IJimuEchartsRender(){

            @Override
            @Nullable
            public String render(JimuEchartsRenderParams params) {
                log.warn("\u76ee\u524d\u4e0d\u652f\u6301\u540e\u7aef\u6e32\u67d3Echarts\u56fe\u8868\uff0c\u8bf7\u4f9d\u8d56\u56fe\u8868\u6e32\u67d3\u6269\u5c55\u6a21\u5757(org.jeecgframework.jimureport:jimureport-echarts-starter)\u3002");
                return null;
            }
        };
    }
}

