/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.config.firewall.interceptor;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.modules.jmreport.common.annotation.JimuNoLoginRequired;
import org.jeecg.modules.jmreport.common.annotation.RequiresPermissions;
import org.jeecg.modules.jmreport.common.annotation.RequiresRoles;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.util.e;
import org.jeecg.modules.jmreport.common.util.o;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.jeecg.modules.jmreport.config.JmReportBaseConfig;
import org.jeecg.modules.jmreport.config.client.JmReportTokenClient;
import org.jeecg.modules.jmreport.config.firewall.interceptor.handlers.JmIPermissionsVerifyHandler;
import org.jeecg.modules.jmreport.desreport.service.IJimuReportShareService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class JimuReportTokenInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(JimuReportTokenInterceptor.class);
    @Autowired
    private JmReportTokenClient jimuTokenClient;
    @Autowired
    private JmReportBaseConfig jmBaseConfig;
    @Autowired
    private IJimuReportShareService jimuReportShareService;
    @Autowired
    private JmIPermissionsVerifyHandler permissionsVerifyHandler;
    private static String NO_PERMISSION_PROMPT_MSG = "\u6743\u9650\u4e0d\u8db3\uff0c\u8bf7\u5347\u7ea7\u4f1a\u5458\uff01";
    private static final Integer GEN_TEST_DATA_CODE = 402;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        String requestPath = e.j(request.getRequestURI().substring(request.getContextPath().length()));
        log.debug("JimuReportInterceptor check requestPath = " + requestPath);
        int msgCode = 500;
        if (o.a(requestPath)) {
            log.error("\u8bf7\u6ce8\u610f\uff0c\u8bf7\u6c42\u5730\u5740\u6709xss\u653b\u51fb\u98ce\u9669\uff01" + requestPath);
            this.backError(response, "\u8bf7\u6c42\u5730\u5740\u6709xss\u653b\u51fb\u98ce\u9669!", msgCode);
            return false;
        }
        String customPrePath = this.jmBaseConfig.getCustomPrePath();
        log.debug("customPrePath: {}", (Object)customPrePath);
        if (OkConvertUtils.isNotEmpty(customPrePath) && !customPrePath.startsWith("/")) {
            customPrePath = "/" + customPrePath;
        }
        request.setAttribute("customPrePath", (Object)customPrePath);
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        if (requestPath.contains("/jmreport/shareView/")) {
            return true;
        }
        JimuNoLoginRequired jimuNoLoginRequired = method.getAnnotation(JimuNoLoginRequired.class);
        if (OkConvertUtils.isNotEmpty(jimuNoLoginRequired)) {
            return true;
        }
        boolean isEffectiveToken = false;
        try {
            isEffectiveToken = this.verifyToken(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!isEffectiveToken) {
            if (this.jimuReportShareService.verifyShareTokenWithJwt(requestPath, request, response)) {
                return true;
            }
            if (this.jimuReportShareService.isSharingEffective(requestPath, request)) {
                return true;
            }
            String previousPage = request.getParameter("previousPage");
            if (OkConvertUtils.isNotEmpty(previousPage)) {
                if (!requestPath.startsWith("/jmreport/view")) {
                    log.error("\u4e0d\u88ab\u5141\u8bb8\u7684\u94bb\u53d6\u8bf7\u6c42\u5730\u5740(" + request.getMethod() + ")\uff1a" + requestPath);
                    this.backError(response, "Token\u6821\u9a8c\u5931\u8d25\uff0c\u65e0\u6743\u9650\u8bbf\u95ee\uff01", msgCode);
                    return false;
                }
                if (this.jimuReportShareService.isShareingToken(requestPath, request)) {
                    return true;
                }
                log.error("\u5206\u4eab\u94fe\u63a5\u5931\u6548\u6216\u5206\u4eabtoken\u4e0d\u5339\u914d(" + request.getMethod() + ")\uff1a" + requestPath);
                this.backError(response, "\u5206\u4eab\u94fe\u63a5\u5931\u6548\u6216\u5206\u4eabtoken\u4e0d\u5339\u914d\uff0c\u7981\u6b62\u94bb\u53d6!", msgCode);
                return false;
            }
            log.error("Token\u6821\u9a8c\u5931\u8d25\uff01\u8bf7\u6c42\u65e0\u6743\u9650(" + request.getMethod() + ")\uff1a" + requestPath);
            this.backError(response, "Token\u6821\u9a8c\u5931\u8d25\uff0c\u65e0\u6743\u9650\u8bbf\u95ee\uff01", msgCode);
            return false;
        }
        RequiresRoles requiresRoles = method.getAnnotation(RequiresRoles.class);
        Result<?> roleVerifyResp = this.permissionsVerifyHandler.verifyRoles(request, requiresRoles, requestPath);
        if (OkConvertUtils.isNotEmpty(roleVerifyResp) && !roleVerifyResp.isSuccess()) {
            this.backError(response, OkConvertUtils.getString(roleVerifyResp.getMessage(), "\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u914d\u6743\u9650\uff01"), OkConvertUtils.getInt(roleVerifyResp.getCode(), msgCode));
            return false;
        }
        RequiresPermissions requiresPermissions = method.getAnnotation(RequiresPermissions.class);
        Result<?> verifyPermissionsResp = this.permissionsVerifyHandler.verifyPermissions(request, requiresPermissions);
        if (OkConvertUtils.isNotEmpty(verifyPermissionsResp) && !verifyPermissionsResp.isSuccess()) {
            this.backError(response, OkConvertUtils.getString(verifyPermissionsResp.getMessage(), "\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u914d\u6743\u9650\uff01"), OkConvertUtils.getInt(verifyPermissionsResp.getCode(), msgCode));
            return false;
        }
        return true;
    }

    private boolean verifyToken(HttpServletRequest request) {
        return this.jimuTokenClient.verifyToken(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backError(HttpServletResponse response, String msg, Integer msgCode) {
        PrintWriter writer = null;
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        response.setHeader("auth", "fail");
        try {
            writer = response.getWriter();
            Result<Object> result = Result.error(msgCode, msg);
            writer.print(JSON.toJSON(result));
        }
        catch (IOException e2) {
            log.error(e2.getMessage());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = null;
        try {
            ip = request.getHeader("x-forwarded-for");
            if (StringUtils.isEmpty((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("Proxy-Client-IP");
            }
            if (StringUtils.isEmpty((CharSequence)ip) || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("WL-Proxy-Client-IP");
            }
            if (StringUtils.isEmpty((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_CLIENT_IP");
            }
            if (StringUtils.isEmpty((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_X_FORWARDED_FOR");
            }
            if (StringUtils.isEmpty((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getRemoteAddr();
            }
        }
        catch (Exception e2) {
            log.error("IPUtils ERROR ", (Throwable)e2);
        }
        return ip;
    }
}

