/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.config.firewall.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.modules.jmreport.common.constant.JmConst;
import org.jeecg.modules.jmreport.common.util.JimuSpringContextUtils;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.util.e;
import org.jeecg.modules.jmreport.common.util.wrapper.BodyReaderHttpServletRequestWrapper;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.jeecg.modules.jmreport.config.JmReportBaseConfig;
import org.jeecg.modules.jmreport.config.client.JmReportTokenClient;
import org.jeecg.modules.jmreport.config.firewall.interceptor.enums.JimuLowCodeUrlsEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class JimuLowCodeModeInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(JimuLowCodeModeInterceptor.class);
    public static final String LOW_CODE_MODE_DEV = "dev";
    public static final String LOW_CODE_MODE_PROD = "prod";
    public static final String LOW_CODE_MODE_PRODSF = "prodsf";
    @Resource
    private JmReportBaseConfig jmReportBaseConfig;
    @Resource
    private JmReportTokenClient jmReportTokenClient;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (this.jmReportBaseConfig == null) {
            this.jmReportBaseConfig = JimuSpringContextUtils.getBean(JmReportBaseConfig.class);
        }
        if (this.jmReportTokenClient == null) {
            this.jmReportTokenClient = JimuSpringContextUtils.getBean(JmReportTokenClient.class);
        }
        if (this.jmReportBaseConfig.getFirewall() != null && LOW_CODE_MODE_PROD.equals(this.jmReportBaseConfig.getFirewall().getLowCodeMode())) {
            BodyReaderHttpServletRequestWrapper requestWrapper;
            SortedMap<String, String> map;
            String requestURI = request.getRequestURI().substring(request.getContextPath().length());
            if (JimuLowCodeUrlsEnum.JIMU_QURESTSQL.getUrl().equals(requestURI) && (map = this.getQueryParams(requestWrapper = new BodyReaderHttpServletRequestWrapper(request))).containsKey("jmViewFirstLoad")) {
                return true;
            }
            String username = this.jmReportTokenClient.getUsername();
            String[] hasRoles = this.jmReportTokenClient.getRoles(request);
            boolean hasIntersection = e.a(hasRoles, JmConst.allowDevRoles);
            if ("admin".equals(username) || hasIntersection) {
                return true;
            }
            this.returnErrorMessage(response, "\u53d1\u5e03\u6a21\u5f0f");
            return false;
        }
        if (this.jmReportBaseConfig.getFirewall() != null && LOW_CODE_MODE_PRODSF.equals(this.jmReportBaseConfig.getFirewall().getLowCodeMode())) {
            BodyReaderHttpServletRequestWrapper requestWrapper;
            SortedMap<String, String> map;
            String requestURI = request.getRequestURI().substring(request.getContextPath().length());
            if (JimuLowCodeUrlsEnum.JIMU_QURESTSQL.getUrl().equals(requestURI) && (map = this.getQueryParams(requestWrapper = new BodyReaderHttpServletRequestWrapper(request))).containsKey("jmViewFirstLoad")) {
                return true;
            }
            this.returnErrorMessage(response, "\u53d1\u5e03\u5b89\u5168\u6a21\u5f0f");
            return false;
        }
        return true;
    }

    private void returnErrorMessage(HttpServletResponse response, String content) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        PrintWriter out = null;
        try {
            out = response.getWriter();
            Result<Object> result = Result.error("\u5f53\u524d\u79ef\u6728\u5e73\u53f0\u6a21\u5f0f\u4e3a\uff0c" + content + "\u4e0d\u5141\u8bb8\u4f7f\u7528\u5728\u7ebf\u914d\u7f6e\uff01\uff01");
            out.print(JSON.toJSON(result));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private SortedMap<String, String> getQueryParams(BodyReaderHttpServletRequestWrapper request) {
        String body;
        TreeMap<String, String> resultMap = new TreeMap<String, String>();
        if (RequestMethod.POST.name().equals(request.getMethod()) && OkConvertUtils.isNotEmpty(body = request.getBody())) {
            JSONObject json = JSON.parseObject((String)body);
            for (String key : json.keySet()) {
                String text = json.getString(key);
                resultMap.put(key, text);
            }
        }
        return resultMap;
    }
}

