/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.config.client;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.modules.jmreport.api.JmReportTokenServiceI;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.util.e;
import org.jeecg.modules.jmreport.common.vo.JmDictModel;
import org.jeecg.modules.jmreport.config.JmReportBaseConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;

@Component(value="jmReportTokenClient")
public class JmReportTokenClient {
    private static final Logger log = LoggerFactory.getLogger(JmReportTokenClient.class);
    @Autowired(required=false)
    private JmReportTokenServiceI jimuTokenService;
    @Autowired(required=false)
    private JmReportBaseConfig jmBaseConfig;

    public boolean isTokenServiceImplemented() {
        log.warn("\u6b63\u5728\u4f7f\u7528\u9ed8\u8ba4Token\u9274\u6743\uff0c\u6b63\u5f0f\u7248\u8bf7\u52a1\u5fc5\u81ea\u5b9a\u4e49\u5b9e\u73b0Token\u9274\u6743\u903b\u8f91\uff01\u53c2\u8003:https://help.jimureport.com/config/token");
        return null != this.jimuTokenService;
    }

    public String[] getRoles(HttpServletRequest request) {
        if (OkConvertUtils.isNotEmpty(this.jimuTokenService)) {
            return this.jimuTokenService.getRoles(this.getToken(request));
        }
        return null;
    }

    public String getToken(HttpServletRequest request) {
        String token = "";
        if (OkConvertUtils.isNotEmpty(this.jimuTokenService)) {
            token = this.jimuTokenService.getToken(request);
        }
        return token;
    }

    public String getToken() {
        String token = "";
        if (OkConvertUtils.isNotEmpty(this.jimuTokenService)) {
            token = this.jimuTokenService.getToken();
        }
        return token;
    }

    public String getUsername(String token) {
        String userName = "";
        if (OkConvertUtils.isNotEmpty(this.jimuTokenService) && OkConvertUtils.isNotEmpty(token)) {
            try {
                userName = this.jimuTokenService.getUsername(token);
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), (Throwable)e2);
            }
        }
        return userName;
    }

    public String getUsername(HttpServletRequest request) {
        String shareToken;
        String userName = "";
        String token = this.getToken(request);
        if (OkConvertUtils.isNotEmpty(this.jimuTokenService) && OkConvertUtils.isNotEmpty(token)) {
            try {
                userName = this.jimuTokenService.getUsername(token);
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), (Throwable)e2);
            }
        }
        if (OkConvertUtils.isEmpty(shareToken = request.getHeader("JmReport-Share-Token"))) {
            shareToken = request.getParameter("shareToken");
        }
        if ("created".equals(this.jmBaseConfig.getSaasMode()) && OkConvertUtils.isEmpty(shareToken)) {
            if (OkConvertUtils.isEmpty(token)) {
                throw new JimuReportException("token\u83b7\u53d6\u4e3a\u7a7a\uff0c\u8bf7\u5b9e\u73b0JmReportTokenServiceI\u4e2d\u7684getToken\u65b9\u6cd5\uff01");
            }
            if (OkConvertUtils.isEmpty(userName)) {
                throw new JimuReportException("\u7528\u6237\u8d26\u53f7\u83b7\u53d6\u4e3a\u7a7a\uff0c\u8bf7\u5b9e\u73b0JmReportTokenServiceI\u4e2d\u7684getUsername\u65b9\u6cd5\uff01");
            }
        }
        return userName;
    }

    public String getUsername() {
        String userName = "";
        try {
            String token = this.getToken();
            if (OkConvertUtils.isNotEmpty(this.jimuTokenService) && OkConvertUtils.isNotEmpty(token)) {
                userName = this.jimuTokenService.getUsername(token);
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        return userName;
    }

    public Boolean verifyToken(HttpServletRequest request) {
        Boolean result = true;
        if (OkConvertUtils.isNotEmpty(this.jimuTokenService)) {
            String token = this.getToken(request);
            result = this.jimuTokenService.verifyToken(token);
        }
        return result;
    }

    @Deprecated
    public Map<String, Object> getUserInfo(String token) {
        Map<String, Object> result = null;
        if (OkConvertUtils.isNotEmpty(this.jimuTokenService) && OkConvertUtils.isNotEmpty(token)) {
            try {
                result = this.jimuTokenService.getUserInfo(token);
                if (result == null) {
                    result = new HashMap<String, Object>(5);
                }
                Date now = new Date();
                if (result.get("sysDate") == null) {
                    result.put("sysDate", e.b(now));
                }
                if (result.get("sysDateTime") == null) {
                    result.put("sysDateTime", e.a(now));
                }
            }
            catch (Exception e2) {
                log.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38: " + e2.getMessage(), (Throwable)e2);
            }
        }
        return result;
    }

    public Map<String, Object> getUserInformation(String token) {
        Map<String, Object> result = new HashMap<String, Object>(5);
        if (OkConvertUtils.isNotEmpty(this.jimuTokenService)) {
            try {
                if (OkConvertUtils.isEmpty(token) && OkConvertUtils.isEmpty(token = this.jimuTokenService.getToken())) {
                    return result;
                }
                result = this.jimuTokenService.getUserInfo(token);
            }
            catch (Exception e2) {
                log.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38: " + e2.getMessage());
            }
        }
        return result;
    }

    public HttpHeaders customApiHeader() {
        HttpHeaders headers = null;
        if (OkConvertUtils.isNotEmpty(this.jimuTokenService)) {
            headers = this.jimuTokenService.customApiHeader();
        }
        return headers;
    }

    public String getTenantId() {
        String tenantId = "";
        try {
            if (OkConvertUtils.isNotEmpty(this.jimuTokenService)) {
                tenantId = this.jimuTokenService.getTenantId();
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
        if (OkConvertUtils.isEmpty(tenantId)) {
            return null;
        }
        return tenantId;
    }

    public String[] getPermissions(HttpServletRequest request) {
        if (OkConvertUtils.isNotEmpty(this.jimuTokenService)) {
            return this.jimuTokenService.getPermissions(this.getToken(request));
        }
        return null;
    }

    public List<JmDictModel> getDictItems(String dictCode) {
        if (OkConvertUtils.isNotEmpty(this.jimuTokenService)) {
            return this.jimuTokenService.getDictItems(dictCode);
        }
        log.info("\u9ed8\u8ba4\u5bf9\u5916\u6269\u5c55\u63a5\u53e3\u65b9\u6cd5getDictItems");
        return null;
    }
}

