/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.modules.jmreport.common.util.JimuSpringContextUtils;
import org.jeecg.modules.jmreport.config.oss.JmReportUploadConfig;
import org.jeecg.modules.jmreport.desreport.util.JmReportUtil;
import org.jeecg.modules.jmreport.desreport.util.e;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class j {
    private static final Logger a = LoggerFactory.getLogger(j.class);

    public static void a(InputStream sourceIs, String destFilePath) throws IOException {
        File destFile = j.b(destFilePath);
        try (FileOutputStream fileOut = null;){
            fileOut = new FileOutputStream(destFile);
            byte[] buf = new byte[8192];
            while (true) {
                int read = 0;
                if (sourceIs != null) {
                    read = sourceIs.read(buf);
                }
                if (read == -1) break;
                fileOut.write(buf, 0, read);
            }
            if (!fileOut.getFD().valid()) {
                throw new RuntimeException("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25,\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            fileOut.flush();
        }
    }

    public static void a(HttpServletResponse response, String storePath, String fileName) {
        response.setCharacterEncoding("UTF-8");
        File file = new File(storePath);
        if (!file.exists()) {
            throw new NullPointerException("Specified file not found");
        }
        if (fileName == null || fileName.isEmpty()) {
            throw new NullPointerException("The file name can not null");
        }
        response.setHeader("content-type", "application/octet-stream");
        response.setContentType("application/octet-stream");
        try {
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        }
        catch (UnsupportedEncodingException e2) {
            a.error(e2.getMessage(), (Throwable)e2);
        }
        byte[] buffer = new byte[1024];
        try (FileInputStream fis = new FileInputStream(file);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            ServletOutputStream os = response.getOutputStream();
            int i2 = bis.read(buffer);
            while (i2 != -1) {
                os.write(buffer, 0, i2);
                i2 = bis.read(buffer);
            }
        }
        catch (Exception e3) {
            a.error(e3.getMessage(), (Throwable)e3);
        }
    }

    public static boolean a(String oldPath) {
        if (StringUtils.isBlank((CharSequence)oldPath)) {
            return true;
        }
        return j.a(new File(oldPath));
    }

    public static boolean a(File oldPath) {
        File[] files;
        if (oldPath.isDirectory() && (files = oldPath.listFiles()) != null) {
            for (File file : files) {
                j.a(file);
            }
        }
        return oldPath.delete();
    }

    public static File b(String destFilePath) {
        File destFile = new File(destFilePath);
        j.b(destFile.getParentFile());
        return destFile;
    }

    public static void b(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static void a(String zipFileName, String sourceFileName) throws Exception {
        ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(Paths.get(zipFileName, new String[0]), new OpenOption[0]));
        BufferedOutputStream bos = new BufferedOutputStream(out);
        File sourceFile = new File(sourceFileName);
        j.a(out, bos, sourceFile, sourceFile.getName());
        bos.close();
        out.close();
    }

    private static void a(ZipOutputStream out, BufferedOutputStream bos, File sourceFile, String base) throws Exception {
        if (sourceFile.isDirectory()) {
            File[] flist = sourceFile.listFiles();
            if (flist == null || flist.length == 0) {
                out.putNextEntry(new ZipEntry(base + "/"));
            } else {
                Arrays.sort(flist, Comparator.comparing(File::getName));
                for (File file : flist) {
                    j.a(out, bos, file, base + "/" + file.getName());
                }
            }
        } else {
            int tag;
            out.putNextEntry(new ZipEntry(base));
            FileInputStream fos = new FileInputStream(sourceFile);
            BufferedInputStream bis = new BufferedInputStream(fos);
            while ((tag = bis.read()) != -1) {
                bos.write(tag);
            }
            bos.flush();
            bis.close();
            fos.close();
        }
    }

    public static boolean c(String userPath) {
        if (userPath == null || userPath.isEmpty()) {
            return true;
        }
        try {
            File file = new File(userPath).getCanonicalFile();
            String normalizedPath = file.getPath();
            return !normalizedPath.contains("..");
        }
        catch (IOException e2) {
            return false;
        }
    }

    public static byte[] d(String srcImg) {
        HttpURLConnection conn = null;
        byte[] byteData = new byte[]{};
        URL url = null;
        if ((srcImg = JmReportUtil.p(srcImg)).contains("http")) {
            try {
                url = new URL(srcImg);
            }
            catch (MalformedURLException e2) {
                e2.printStackTrace();
            }
            if (srcImg.contains("https")) {
                try {
                    byteData = e.a(srcImg);
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            } else {
                try {
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("GET");
                    conn.setConnectTimeout(50000);
                    InputStream inStream = conn.getInputStream();
                    byteData = j.a(inStream);
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
            }
        } else {
            byteData = j.f(srcImg);
        }
        return byteData;
    }

    private static byte[] a(InputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        inStream.close();
        return outStream.toByteArray();
    }

    private static byte[] f(String srcImg) {
        JmReportUploadConfig jmUploadConfig = JimuSpringContextUtils.getBean(JmReportUploadConfig.class);
        File imageDir = new File(jmUploadConfig.getPath().getUpload() + File.separator + srcImg);
        try {
            byte[] fileByte = Files.readAllBytes(imageDir.toPath());
            return fileByte;
        }
        catch (NoSuchFileException e2) {
            a.error("\u4e0b\u8f7d\u6587\u4ef6\u8def\u5f84\u672a\u627e\u5230:::" + jmUploadConfig.getPath().getUpload() + File.separator + srcImg);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        return null;
    }

    public static synchronized String e(String absolutePath) {
        String baseName;
        File file = new File(absolutePath);
        if (!file.exists()) {
            return absolutePath;
        }
        String parent = file.getParent();
        String name = file.getName();
        String extension = "";
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex != -1) {
            baseName = name.substring(0, dotIndex);
            extension = name.substring(dotIndex);
        } else {
            baseName = name;
        }
        int index = 1;
        do {
            String newName = baseName + "(" + index + ")" + extension;
            file = new File(parent, newName);
            ++index;
        } while (file.exists());
        return file.getAbsolutePath();
    }
}

