/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.util;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkConvertUtils {
    private static final Logger log = LoggerFactory.getLogger(OkConvertUtils.class);

    public static boolean isEmptyString(CharSequence str) {
        return str == null || str.length() == 0 || "null".equals(str) || "".equals(str);
    }

    public static boolean isEmptyMap(Map<?, ?> map) {
        return null == map || map.isEmpty();
    }

    public static boolean isEmptyIterable(Iterable<?> iterable) {
        return null == iterable || OkConvertUtils.isEmpty(iterable.iterator());
    }

    public static boolean isEmptyIterator(Iterator<?> iterator) {
        return null == iterator || false == iterator.hasNext();
    }

    public static boolean isArray(Object obj) {
        if (null == obj) {
            return false;
        }
        return obj.getClass().isArray();
    }

    public static boolean isEmptyArray(Object array) {
        if (null == array) {
            return true;
        }
        if (OkConvertUtils.isArray(array)) {
            return 0 == Array.getLength(array);
        }
        throw new JimuReportException("Object to provide is not a Array !");
    }

    public static boolean isEmpty(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return OkConvertUtils.isEmptyString((CharSequence)obj);
        }
        if (obj instanceof Map) {
            return OkConvertUtils.isEmptyMap((Map)obj);
        }
        if (obj instanceof Iterable) {
            return OkConvertUtils.isEmptyIterable((Iterable)obj);
        }
        if (obj instanceof Iterator) {
            return OkConvertUtils.isEmptyIterator((Iterator)obj);
        }
        if (OkConvertUtils.isArray(obj)) {
            return OkConvertUtils.isEmptyArray(obj);
        }
        return false;
    }

    public static boolean isNotEmpty(Object object) {
        return !OkConvertUtils.isEmpty(object);
    }

    public static String decode(String strIn, String sourceCode, String targetCode) {
        String temp = OkConvertUtils.code2code(strIn, sourceCode, targetCode);
        return temp;
    }

    public static boolean isNumeric(String str) {
        return str.matches("-?[0-9]+.?[0-9]*");
    }

    private static String code2code(String strIn, String sourceCode, String targetCode) {
        String strOut = null;
        if (strIn == null || "".equals(strIn.trim())) {
            return strIn;
        }
        try {
            byte[] b2 = strIn.getBytes(sourceCode);
            for (int i2 = 0; i2 < b2.length; ++i2) {
                System.out.print(b2[i2] + "  ");
            }
            strOut = new String(b2, targetCode);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
        return strOut;
    }

    public static int getInt(String s, int defval) {
        if (OkConvertUtils.isEmpty(s)) {
            return defval;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            return defval;
        }
    }

    public static int getInt(String s) {
        if (s == null || s == "") {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            return 0;
        }
    }

    public static int getInt(String s, Integer df) {
        if (s == null || s == "") {
            return df;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            return 0;
        }
    }

    public static int getInt(Object object, int defval) {
        if (OkConvertUtils.isEmpty(object)) {
            return defval;
        }
        try {
            if (object instanceof Float) {
                return ((Float)object).intValue();
            }
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            return defval;
        }
    }

    public static Integer getInt(Object object) {
        if (OkConvertUtils.isEmpty(object)) {
            return null;
        }
        try {
            if (object instanceof Float) {
                return ((Float)object).intValue();
            }
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            return null;
        }
    }

    public static int getInt(BigDecimal s, int defval) {
        if (s == null) {
            return defval;
        }
        return s.intValue();
    }

    public static String getString(String s) {
        return OkConvertUtils.getString(s, "");
    }

    public static String getString(Object object) {
        if (OkConvertUtils.isEmpty(object)) {
            return "";
        }
        return object.toString().trim();
    }

    public static String getString(int i2) {
        return String.valueOf(i2);
    }

    public static String getString(float i2) {
        return String.valueOf(i2);
    }

    public static String getString(String s, String defval) {
        if (OkConvertUtils.isEmpty(s)) {
            return defval;
        }
        return s.trim();
    }

    public static String getString(Object s, String defval) {
        if (OkConvertUtils.isEmpty(s)) {
            return defval;
        }
        return s.toString().trim();
    }

    public static String getJmString(Object s) {
        if (OkConvertUtils.isEmpty(s)) {
            return "";
        }
        return s.toString();
    }

    public static String getIp() {
        String ip = null;
        try {
            InetAddress address = InetAddress.getLocalHost();
            ip = address.getHostAddress();
        }
        catch (UnknownHostException e2) {
            e2.printStackTrace();
        }
        return ip;
    }

    public static String camelToUnderline(String para) {
        int stringMinLength = 3;
        if (para.length() < stringMinLength) {
            return para.toLowerCase();
        }
        StringBuilder sb = new StringBuilder(para);
        int temp = 0;
        for (int i2 = 2; i2 < para.length(); ++i2) {
            if (!Character.isUpperCase(para.charAt(i2))) continue;
            sb.insert(i2 + temp, "_");
            ++temp;
        }
        return sb.toString().toLowerCase();
    }

    public static Field[] getAllFields(Object object) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
        }
        Field[] fields = new Field[fieldList.size()];
        fieldList.toArray(fields);
        return fields;
    }

    public static String join(Object[] array, String separator, int startIndex, int endIndex) {
        int noOfItems;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        if ((noOfItems = endIndex - startIndex) <= 0) {
            return "";
        }
        StringBuilder buf = OkConvertUtils.newStringBuilder(noOfItems);
        if (array[startIndex] != null) {
            buf.append(array[startIndex]);
        }
        for (int i2 = startIndex + 1; i2 < endIndex; ++i2) {
            buf.append(separator);
            if (array[i2] == null) continue;
            buf.append(array[i2]);
        }
        return buf.toString();
    }

    private static StringBuilder newStringBuilder(int noOfItems) {
        return new StringBuilder(noOfItems * 16);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int startPos) {
        int endLimit;
        if (str == null || searchStr == null) {
            return -1;
        }
        if (startPos < 0) {
            startPos = 0;
        }
        if (startPos > (endLimit = str.length() - searchStr.length() + 1)) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return startPos;
        }
        for (int i2 = startPos; i2 < endLimit; ++i2) {
            if (!OkConvertUtils.regionMatches(str, true, i2, searchStr, 0, searchStr.length())) continue;
            return i2;
        }
        return -1;
    }

    public static boolean regionMatches(CharSequence cs, boolean ignoreCase, int thisStart, CharSequence substring, int start, int length) {
        if (cs instanceof String && substring instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, thisStart, (String)substring, start, length);
        }
        int index1 = thisStart;
        int index2 = start;
        int tmpLen = length;
        int srcLen = cs.length() - thisStart;
        int otherLen = substring.length() - start;
        if (thisStart < 0 || start < 0 || length < 0) {
            return false;
        }
        if (srcLen < length || otherLen < length) {
            return false;
        }
        while (tmpLen-- > 0) {
            char c2;
            char c1;
            if ((c1 = cs.charAt(index1++)) == (c2 = substring.charAt(index2++))) continue;
            if (!ignoreCase) {
                return false;
            }
            if (Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    public static byte[] decodeBase64(String base64Str) {
        byte[] byteContent = Base64.decodeBase64((String)base64Str);
        return byteContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> deepCopy(List<T> list) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream outputStream = null;
        ObjectInputStream inputStream = null;
        ByteArrayInputStream byteIn = null;
        try {
            outputStream = new ObjectOutputStream(byteOut);
            outputStream.writeObject(list);
            byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            inputStream = new ObjectInputStream(byteIn);
            List list2 = (List)inputStream.readObject();
            return list2;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            try {
                byteOut.flush();
                byteOut.close();
            }
            catch (IOException iOException) {}
            if (byteIn != null) {
                try {
                    byteIn.close();
                }
                catch (IOException iOException) {}
            }
        }
        return Collections.emptyList();
    }

    public static JSONObject jsonDeepClone(JSONObject jsonObject) {
        if (null != jsonObject && jsonObject.size() > 0) {
            return JSONObject.parseObject((String)jsonObject.toJSONString());
        }
        return new JSONObject();
    }

    public static <T> boolean isIn(T obj, T ... objs) {
        if (OkConvertUtils.isEmpty(objs)) {
            return false;
        }
        for (T obj1 : objs) {
            if (!OkConvertUtils.isEqualsRegardingNull(obj, obj1)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean isNotIn(T obj, T ... objs) {
        return !OkConvertUtils.isIn(obj, objs);
    }

    public static boolean isEqualsRegardingNull(Object expected, Object actual) {
        if (expected == null) {
            return actual == null;
        }
        return OkConvertUtils.isEquals(expected, actual);
    }

    public static boolean isEquals(Object expected, Object actual) {
        return expected.equals(actual);
    }

    public static boolean isGt(Date src, Date des) {
        if (null == src || null == des) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return DateUtils.a(src, des) == 1;
    }

    public static boolean isGt(Number src, Number des) {
        if (null == src || null == des) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return src.doubleValue() > des.doubleValue();
    }

    public static boolean isGe(Date src, Date des) {
        if (null == src || null == des) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int compareResult = DateUtils.a(src, des);
        return compareResult >= 0;
    }

    public static boolean isGe(Number src, Number des) {
        if (null == src || null == des) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return !(src.doubleValue() < des.doubleValue());
    }

    public static <T> T createFrom(Map<String, Object> source, Class<T> targetClazz) {
        if (OkConvertUtils.isEmpty(source)) {
            return null;
        }
        String sourceStr = JSONObject.toJSONString(source);
        return (T)JSONObject.parseObject((String)sourceStr, targetClazz);
    }

    public static <T> List<T> createFromListMap(List<Map<String, Object>> sources, Class<T> targetClazz) {
        ArrayList list = new ArrayList();
        if (OkConvertUtils.isNotEmpty(sources)) {
            sources.forEach(source -> list.add(OkConvertUtils.createFrom(source, targetClazz)));
        }
        return list;
    }
}

