/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.util;

import java.beans.PropertyEditorSupport;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.springframework.util.StringUtils;

public class DateUtils
extends PropertyEditorSupport {
    private static final Log r = LogFactory.getLog(DateUtils.class);
    public static final String a = "yyyy-MM-dd";
    public static final String b = "yyyy-MM";
    public static final String c = "yyyy_M_MDD";
    public static final String d = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String e = "yyyy-MM-dd HH:mm";
    public static final String f = "yyyyMMddHHmmss";
    public static final String g = "HH:mm";
    public static final String h = "HH:mm:ss";
    public static final String i = "yyyy-MM-dd HH:mm:ss";
    private static ThreadLocal<Map<String, SimpleDateFormat>> s = new ThreadLocal();
    public static final long j = 86400000L;
    public static final long k = 3600000L;
    public static final long l = 60000L;
    public static final long m = 1000L;
    public static final long n = 31536000L;
    public static final long o = 86400L;
    public static final long p = 3600L;
    public static final long q = 60L;

    public static SimpleDateFormat a(String pattern) {
        Map<String, SimpleDateFormat> dfMap = s.get();
        SimpleDateFormat df = null;
        if (dfMap == null) {
            dfMap = new HashMap<String, SimpleDateFormat>(16);
            df = new SimpleDateFormat(pattern);
            dfMap.put(pattern, df);
            s.set(dfMap);
        } else {
            df = dfMap.get(pattern);
            if (df == null) {
                df = new SimpleDateFormat(pattern);
                dfMap.put(pattern, df);
                s.set(dfMap);
            }
        }
        return df;
    }

    public static Calendar getCalendar() {
        return Calendar.getInstance();
    }

    public static Calendar a(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(millis));
        return cal;
    }

    public static Date getDate() {
        return new Date();
    }

    public static Date b(long millis) {
        return new Date(millis);
    }

    public static String a(Timestamp time) {
        Date date = null;
        if (null != time) {
            date = new Date(time.getTime());
        }
        return DateUtils.c(a);
    }

    public static Timestamp b(String str) {
        Date date = DateUtils.a(str, DateUtils.a(a));
        return new Timestamp(date.getTime());
    }

    public static Date a(String str, SimpleDateFormat sdf) {
        if (null == str || str.isEmpty()) {
            return null;
        }
        Date date = null;
        try {
            date = sdf.parse(str);
            return date;
        }
        catch (ParseException e2) {
            r.error((Object)e2.getMessage(), (Throwable)e2);
            return null;
        }
    }

    public static synchronized String c(String format) {
        Date date = DateUtils.getDate();
        return DateUtils.a(format).format(date);
    }

    public static String a(String date, String format) {
        SimpleDateFormat sformat = DateUtils.a(format);
        Date newDate = null;
        try {
            newDate = sformat.parse(date);
        }
        catch (ParseException e2) {
            r.error((Object)e2.getMessage(), (Throwable)e2);
        }
        return sformat.format(newDate);
    }

    public static synchronized String a(Date date, String format) {
        if (null == date) {
            return null;
        }
        if (null == format || format.isEmpty()) {
            return null;
        }
        return DateUtils.a(format).format(date);
    }

    public static String d(String format) {
        Date date = new Date();
        SimpleDateFormat sdf = DateUtils.a(format);
        return sdf.format(date);
    }

    public static Timestamp c(long millis) {
        return new Timestamp(millis);
    }

    public static Timestamp e(String time) {
        return new Timestamp(Long.parseLong(time));
    }

    public static Timestamp getTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Timestamp a(Date date) {
        return new Timestamp(date.getTime());
    }

    public static Timestamp a(Calendar cal) {
        return new Timestamp(cal.getTime().getTime());
    }

    public static long getMillis() {
        return System.currentTimeMillis();
    }

    public static long b(Calendar cal) {
        return cal.getTime().getTime();
    }

    public static long b(Date date) {
        return date.getTime();
    }

    public static long b(Timestamp ts) {
        return ts.getTime();
    }

    public static synchronized String a() {
        return DateUtils.a(a).format(DateUtils.getCalendar().getTime());
    }

    public static synchronized String a(SimpleDateFormat formatstr) {
        return formatstr.format(DateUtils.getCalendar().getTime());
    }

    public static synchronized String c(Calendar cal) {
        return DateUtils.a(a).format(cal.getTime());
    }

    public static synchronized String c(Date date) {
        return DateUtils.a(a).format(date);
    }

    public static synchronized String d(long millis) {
        return DateUtils.a(a).format(new Date(millis));
    }

    public static String f(String pattern) {
        return DateUtils.a(pattern).format(DateUtils.getCalendar().getTime());
    }

    public static String a(Calendar cal, String pattern) {
        return DateUtils.a(pattern).format(cal.getTime());
    }

    public static String b(Date date, String pattern) {
        return DateUtils.a(pattern).format(date);
    }

    public static synchronized String b() {
        return DateUtils.a(e).format(DateUtils.getCalendar().getTime());
    }

    public static synchronized String e(long millis) {
        return DateUtils.a(e).format(new Date(millis));
    }

    public static synchronized String d(Calendar cal) {
        return DateUtils.a(e).format(cal.getTime());
    }

    public static synchronized String d(Date date) {
        return DateUtils.a(e).format(date);
    }

    public static synchronized String c() {
        return DateUtils.a(g).format(DateUtils.getCalendar().getTime());
    }

    public static synchronized String f(long millis) {
        return DateUtils.a(g).format(new Date(millis));
    }

    public static synchronized String e(Calendar cal) {
        return DateUtils.a(g).format(cal.getTime());
    }

    public static synchronized String e(Date date) {
        return DateUtils.a(g).format(date);
    }

    public static synchronized String f(Date date) {
        return DateUtils.a(h).format(date);
    }

    public static Date b(String src, String pattern) throws ParseException {
        return DateUtils.a(pattern).parse(src);
    }

    public static Calendar c(String src, String pattern) throws ParseException {
        Date date = DateUtils.b(src, pattern);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static Timestamp d(String src, String pattern) throws ParseException {
        Date date = DateUtils.b(src, pattern);
        return new Timestamp(date.getTime());
    }

    public static String a(Date src, Date des, String format) {
        long diffSecond;
        long diffMinute;
        long diffHour;
        long diffDay;
        long diff;
        long diffYear;
        Calendar calSrc = Calendar.getInstance();
        calSrc.setTime(src);
        Calendar calDes = Calendar.getInstance();
        calDes.setTime(des);
        boolean doFormat = true;
        if (OkConvertUtils.isEmpty(format)) {
            doFormat = false;
            format = "";
        }
        if ((diffYear = (diff = DateUtils.a(DiffType.e, calSrc, calDes)) / 31536000L) > 0L) {
            diff %= 31536000L;
            if (!doFormat) {
                format = format + diffYear + "\u5e74";
            }
        }
        if ((diffDay = diff / 86400L) > 0L) {
            diff %= 86400L;
            if (!doFormat) {
                format = format + diffDay + "\u5929";
            }
        }
        if ((diffHour = diff / 3600L) > 0L) {
            diff %= 3600L;
            if (!doFormat) {
                format = format + diffHour + "\u5c0f\u65f6";
            }
        }
        if ((diffMinute = diff / 60L) > 0L) {
            diff %= 60L;
            if (!doFormat) {
                format = format + diffMinute + "\u5206\u949f";
            }
        }
        if ((diffSecond = diff) > 0L && !doFormat) {
            format = format + diffSecond + "\u79d2";
        }
        if (doFormat) {
            format = StringUtils.replace((String)format, (String)"$Y", (String)(diffYear + ""));
            format = StringUtils.replace((String)format, (String)"$D", (String)(diffDay + ""));
            format = StringUtils.replace((String)format, (String)"$H", (String)(diffHour + ""));
            format = StringUtils.replace((String)format, (String)"$m", (String)(diffMinute + ""));
            format = StringUtils.replace((String)format, (String)"$s", (String)(diffSecond + ""));
        }
        return format;
    }

    public static long a(DiffType flag, Date src, Date des) {
        Calendar calSrc = Calendar.getInstance();
        calSrc.setTime(src);
        Calendar calDes = Calendar.getInstance();
        calDes.setTime(des);
        return DateUtils.a(flag, calSrc, calDes);
    }

    public static long a(DiffType flag, Calendar calSrc, Calendar calDes) {
        long millisDiff = DateUtils.b(calSrc) - DateUtils.b(calDes);
        if (flag == DiffType.a) {
            return calSrc.get(1) - calDes.get(1);
        }
        if (flag == DiffType.b) {
            return millisDiff / 86400000L;
        }
        if (flag == DiffType.c) {
            return millisDiff / 3600000L;
        }
        if (flag == DiffType.d) {
            return millisDiff / 60000L;
        }
        if (flag == DiffType.e) {
            return millisDiff / 1000L;
        }
        return 0L;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.hasText((String)text)) {
            try {
                if (!text.contains(":") && text.length() == 10) {
                    this.setValue(DateUtils.a(a).parse(text));
                }
                if (text.indexOf(":") > 0 && text.length() == 19) {
                    this.setValue(DateUtils.a(i).parse(text));
                }
                throw new IllegalArgumentException("Could not parse date, date format is error ");
            }
            catch (ParseException ex) {
                IllegalArgumentException iae = new IllegalArgumentException("Could not parse date: " + ex.getMessage());
                iae.initCause(ex);
                throw iae;
            }
        } else {
            this.setValue(null);
        }
    }

    public static int getYear() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(DateUtils.getDate());
        return calendar.get(1);
    }

    public static int a(Date src, Date des) {
        if (src.getTime() < des.getTime()) {
            return -1;
        }
        if (src.getTime() > des.getTime()) {
            return 1;
        }
        return 0;
    }

    public static String a(int year, int week) {
        int targetNum = 0;
        if (week + targetNum > 52) {
            ++year;
            week += targetNum - 52;
        } else if (week + targetNum <= 0) {
            --year;
            week += targetNum + 52;
        } else {
            week += targetNum;
        }
        SimpleDateFormat sdf = DateUtils.a(a);
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(1);
        cal.set(1, year);
        cal.set(3, week);
        cal.set(7, cal.getFirstDayOfWeek());
        String beginDate = DateUtils.b(cal.getTime(), a);
        cal.add(7, 6);
        String endDate = DateUtils.b(cal.getTime(), a);
        return beginDate + "," + endDate;
    }

    public static String b(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        String beginDate = DateUtils.b(cal.getTime(), "yyyy-MM-01");
        String endDate = DateUtils.b(cal.getTime(), "yyyy-MM-" + cal.getActualMaximum(5));
        return beginDate + ',' + endDate;
    }

    public static Date getBeginDayOfLastWeek() {
        Date date = new Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek - 7);
        return DateUtils.g(cal.getTime());
    }

    public static Date getEndDayOfLastWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getBeginDayOfLastWeek());
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return DateUtils.h(weekEndSta);
    }

    public static Timestamp g(Date d2) {
        Calendar calendar = Calendar.getInstance();
        if (null != d2) {
            calendar.setTime(d2);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Timestamp h(Date d2) {
        Calendar calendar = Calendar.getInstance();
        if (null != d2) {
            calendar.setTime(d2);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static String a(int num, Date date, SimpleDateFormat sdf, int calendar) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(calendar, num);
        return sdf.format(ca.getTime());
    }

    public static Date a(int num, Date date, int calendar) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(calendar, num);
        return ca.getTime();
    }

    public static Date a(LocalDate localDate) {
        if (null == localDate) {
            return null;
        }
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static LocalDate i(Date date) {
        if (null == date) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static final class DiffType
    extends Enum<DiffType> {
        public static final /* enum */ DiffType a = new DiffType();
        public static final /* enum */ DiffType b = new DiffType();
        public static final /* enum */ DiffType c = new DiffType();
        public static final /* enum */ DiffType d = new DiffType();
        public static final /* enum */ DiffType e = new DiffType();
        private static final /* synthetic */ DiffType[] f;

        public static DiffType[] a() {
            return (DiffType[])f.clone();
        }

        public static DiffType a(String name) {
            return Enum.valueOf(DiffType.class, name);
        }

        static {
            f = new DiffType[]{a, b, c, d, e};
        }
    }
}

