/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.interceptor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jeecg.modules.jmreport.common.util.JimuSpringContextUtils;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.config.JmReportBaseConfig;
import org.jeecg.modules.jmreport.config.client.JmReportTokenClient;
import org.jeecg.modules.jmreport.desreport.service.IJimuReportShareService;
import org.jeecgframework.minidao.aspect.EmptyInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="jimureportMinidaoInterceptor")
public class JimureportMinidaoInterceptor
implements EmptyInterceptor {
    private static final Logger log = LoggerFactory.getLogger(JimureportMinidaoInterceptor.class);
    private JmReportTokenClient client;
    private JmReportBaseConfig jmBaseConfig;
    private IJimuReportShareService jimuReportShareService;

    public boolean onInsert(Field[] fields, Object obj) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(5);
        for (int j2 = 0; j2 < fields.length; ++j2) {
            Field field = fields[j2];
            String fieldName = field.getName();
            if (this.client == null) {
                try {
                    this.client = JimuSpringContextUtils.getBean(JmReportTokenClient.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.client != null) {
                try {
                    String tenantId;
                    String username = this.client.getUsername();
                    if (OkConvertUtils.isNotEmpty(username) && "createBy".equals(fieldName)) {
                        map.put("createBy", username);
                    }
                    if ("tenantId".equals(fieldName) && OkConvertUtils.isNotEmpty(tenantId = this.client.getTenantId())) {
                        if (field.getType().equals(String.class)) {
                            map.put("tenantId", tenantId);
                        } else {
                            map.put("tenantId", OkConvertUtils.getInt(tenantId, 0));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!"createTime".equals(fieldName)) continue;
            map.put("createTime", new Date());
        }
        try {
            JimureportMinidaoInterceptor.setFieldValue(map, obj);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return false;
    }

    public boolean onUpdate(Field[] fields, Object obj) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(5);
        for (int j2 = 0; j2 < fields.length; ++j2) {
            Field field = fields[j2];
            String fieldName = field.getName();
            if (this.client == null) {
                try {
                    this.client = JimuSpringContextUtils.getBean(JmReportTokenClient.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.client != null) {
                try {
                    String tenantId;
                    String username = this.client.getUsername();
                    if (OkConvertUtils.isNotEmpty(username) && "updateBy".equals(fieldName)) {
                        map.put("updateBy", username);
                    }
                    if ("tenantId".equals(fieldName) && OkConvertUtils.isNotEmpty(tenantId = this.client.getTenantId())) {
                        if (field.getType().equals(String.class)) {
                            map.put("tenantId", tenantId);
                        } else {
                            map.put("tenantId", OkConvertUtils.getInt(tenantId, 0));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!"updateTime".equals(fieldName)) continue;
            map.put("updateTime", new Date());
        }
        try {
            JimureportMinidaoInterceptor.setFieldValue(map, obj);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return false;
    }

    public boolean onSelect(Field[] fields, Object obj) {
        return true;
    }

    private void setSaasFieldVal(Field[] fields, Object obj, String saasMode) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(5);
        for (int j2 = 0; j2 < fields.length; ++j2) {
            String fieldName = fields[j2].getName();
            if (this.client == null) {
                try {
                    this.client = JimuSpringContextUtils.getBean(JmReportTokenClient.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.client == null) continue;
            try {
                if ("created".equals(saasMode)) {
                    String username = OkConvertUtils.getString(this.client.getUsername(), "\u83b7\u53d6\u4e0d\u5230\u7528\u6237\u8d26\u53f7");
                    if ("createBy".equals(fieldName)) {
                        map.put("createBy", username);
                    }
                }
                if (!"tenant".equals(saasMode) || !"tenantId".equals(fieldName)) continue;
                String tenantId = OkConvertUtils.getString(this.client.getTenantId(), "\u83b7\u53d6\u4e0d\u5230\u79df\u6237ID");
                map.put("tenantId", tenantId);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            JimureportMinidaoInterceptor.setFieldValue(map, obj);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private static void setFieldValue(Map<Object, Object> map, Object bean) throws Exception {
        Field[] fields;
        Class<?> cls = bean.getClass();
        Method[] methods = cls.getDeclaredMethods();
        for (Field field : fields = cls.getDeclaredFields()) {
            int val;
            String fldtype = field.getType().getSimpleName();
            String fldSetName = field.getName();
            String setMethod = JimureportMinidaoInterceptor.pareSetName(fldSetName);
            if (!JimureportMinidaoInterceptor.checkMethod(methods, setMethod) || !map.containsKey(fldSetName)) continue;
            Object value = map.get(fldSetName);
            field.setAccessible(true);
            Object originalEntryValue = field.get(bean);
            Method method = cls.getMethod(setMethod, field.getType());
            if (null == value || originalEntryValue != null && !"".equals(originalEntryValue.toString())) continue;
            if ("String".equals(fldtype)) {
                method.invoke(bean, String.valueOf(value));
                continue;
            }
            if ("Double".equals(fldtype)) {
                method.invoke(bean, (Double)value);
                continue;
            }
            if ("int".equals(fldtype)) {
                if (!OkConvertUtils.isNotEmpty(value)) continue;
                if (value instanceof String) {
                    val = Integer.parseInt((String)value);
                    method.invoke(bean, val);
                    continue;
                }
                method.invoke(bean, value);
                continue;
            }
            if ("Integer".equalsIgnoreCase(fldtype)) {
                if (!OkConvertUtils.isNotEmpty(value)) continue;
                if (value instanceof String) {
                    val = Integer.parseInt((String)value);
                    method.invoke(bean, val);
                    continue;
                }
                method.invoke(bean, value);
                continue;
            }
            method.invoke(bean, value);
        }
    }

    private static String pareSetName(String fldname) {
        if (null == fldname || "".equals(fldname)) {
            return null;
        }
        String pro = "set" + fldname.substring(0, 1).toUpperCase() + fldname.substring(1);
        return pro;
    }

    private static boolean checkMethod(Method[] methods, String met) {
        if (null != methods) {
            for (Method method : methods) {
                if (!met.equals(method.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

