/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.modules.jmreport.common.util.JimuSpringContextUtils;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.vo.JmDictModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;

public interface JmReportTokenServiceI {
    public static final Logger log = LoggerFactory.getLogger(JmReportTokenServiceI.class);
    public static final String SYS_USER_CODE = "sysUserCode";
    public static final String SYS_ORG_CODE = "sysOrgCode";
    public static final String SYS_DATE = "sysDate";
    public static final String SYS_DATE_TIME = "sysDateTime";

    default public String getToken(HttpServletRequest request) {
        if (request != null) {
            String token = request.getParameter("token");
            if (token == null) {
                token = request.getHeader("X-Access-Token");
            }
            return token;
        }
        return null;
    }

    default public String getToken() {
        HttpServletRequest request = null;
        try {
            request = JimuSpringContextUtils.getHttpServletRequest();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getToken(request);
    }

    public String getUsername(String var1);

    default public String[] getRoles(String token) {
        log.warn(" warn:: \u8bf7\u5b9e\u73b0 JmReportTokenServiceI.getRoles \u65b9\u6cd5\uff0c\u5426\u5219\u5b58\u5728\u6f0f\u6d1e\u653b\u51fb\u98ce\u9669!");
        return new String[]{"admin", "lowdeveloper", "dbadeveloper"};
    }

    public Boolean verifyToken(String var1);

    default public Map<String, Object> getUserInfo(String token) {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put(SYS_USER_CODE, this.getUsername(token));
        map.put(SYS_ORG_CODE, "");
        return map;
    }

    default public HttpHeaders customApiHeader() {
        return null;
    }

    default public String getTenantId() {
        String headerTenantId = null;
        try {
            HttpServletRequest request = JimuSpringContextUtils.getHttpServletRequest();
            if (request != null && OkConvertUtils.isEmpty(headerTenantId = request.getHeader("JmReport-Tenant-Id"))) {
                headerTenantId = request.getParameter("tenantId");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return headerTenantId;
    }

    default public String[] getPermissions(String token) {
        log.warn(" warn:: \u8bf7\u5b9e\u73b0 JmReportTokenServiceI.getPermissions \u65b9\u6cd5\uff0c\u5426\u5219\u5b58\u5728\u6f0f\u6d1e\u653b\u51fb\u98ce\u9669!");
        return new String[]{"drag:datasource:testConnection", "onl:drag:clear:recovery", "drag:analysis:sql", "drag:design:getTotalData", "onl:drag:page:delete"};
    }

    default public List<JmDictModel> getDictItems(String dictCode) {
        log.info("\u9ed8\u8ba4\u5bf9\u5916\u6269\u5c55\u63a5\u53e3\u65b9\u6cd5getDictItems");
        return null;
    }
}

