/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.ai.b;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jeecg.modules.jmreport.ai.service.IJimuAiAssistantService;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.jeecg.modules.jmreport.desreport.service.IJimuReportService;
import org.jeecg.modules.jmreport.desreport.service.IJmReportDbService;
import org.jeecg.modules.jmreport.desreport.service.IJmReportDbSourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="jimuAiAssistantController")
@RequestMapping(value={"/jmreport/ai/assistant"})
public class a {
    private static final Logger a = LoggerFactory.getLogger(a.class);
    @Autowired
    IJimuAiAssistantService jimuAiAssistantService;
    @Autowired
    private IJmReportDbService jmReportDbService;
    @Autowired
    private IJmReportDbSourceService jmReportDbSourceService;
    @Autowired
    private IJimuReportService jmReportDesignService;
    @Autowired
    private org.jeecg.modules.jmreport.ai.a.a jimuAiConfigBean;

    @PostMapping(value={"/chooseTables"})
    public Result<?> a(@RequestBody Map<String, Object> params) {
        String dbSource = (String)params.get("dbSource");
        String requirements = (String)params.get("requirements");
        List<Map<String, Object>> tableList = OkConvertUtils.isEmpty(dbSource) ? this.jmReportDbSourceService.getAllTable() : this.jmReportDbService.queryTableName(dbSource, "");
        if (OkConvertUtils.isEmpty(tableList)) {
            return Result.error("\u6ca1\u6709\u53ef\u7528\u7684\u8868");
        }
        String tableListStr = tableList.stream().map(table -> {
            String tableName = (String)(table.containsKey("Name") ? table.get("Name") : table.getOrDefault("name", ""));
            String tableComment = (String)(table.containsKey("Comment") ? table.get("Comment") : table.getOrDefault("comments", ""));
            return "- " + tableName + "|" + tableComment;
        }).collect(Collectors.joining("\n"));
        Integer maxTokens = this.jimuAiConfigBean.getMaxTokens();
        if (maxTokens != null && tableListStr.length() > maxTokens - 1000) {
            List onceResTables;
            String batchStr;
            JSONObject sqlRes;
            int batchSize = maxTokens - 1000;
            String[] lines = tableListStr.split("\\n");
            StringBuilder batchBuilder = new StringBuilder();
            ArrayList allTables = new ArrayList();
            for (int i2 = 0; i2 < lines.length; ++i2) {
                String line = lines[i2];
                if (batchBuilder.length() + line.length() + 1 > batchSize && batchBuilder.length() > 0) {
                    List onceResTables2;
                    String batchStr2 = batchBuilder.toString();
                    JSONObject sqlRes2 = this.jimuAiAssistantService.callAiService(requirements, batchStr2, dbSource, "chooseTables");
                    if (sqlRes2 != null && sqlRes2.containsKey((Object)"tables") && OkConvertUtils.isNotEmpty(onceResTables2 = sqlRes2.getJSONArray("tables").toJavaList(String.class))) {
                        allTables.addAll(onceResTables2);
                    }
                    batchBuilder.setLength(0);
                }
                if (batchBuilder.length() > 0) {
                    batchBuilder.append("\n");
                }
                batchBuilder.append(line);
            }
            if (batchBuilder.length() > 0 && (sqlRes = this.jimuAiAssistantService.callAiService(requirements, batchStr = batchBuilder.toString(), dbSource, "chooseTables")) != null && sqlRes.containsKey((Object)"tables") && OkConvertUtils.isNotEmpty(onceResTables = sqlRes.getJSONArray("tables").toJavaList(String.class))) {
                allTables.addAll(onceResTables);
            }
            if (OkConvertUtils.isNotEmpty(allTables)) {
                return Result.OK(JSONObject.toJSONString(allTables));
            }
            return Result.error("AI\u5f00\u5c0f\u5dee\u4e86,\u8bf7\u7a0d\u540e\u518d\u8bd5!");
        }
        JSONObject sqlRes = this.jimuAiAssistantService.callAiService(requirements, tableListStr, dbSource, "chooseTables");
        if (null != sqlRes && sqlRes.containsKey((Object)"tables")) {
            return Result.OK(sqlRes.getString("tables"));
        }
        return Result.error("AI\u5f00\u5c0f\u5dee\u4e86,\u8bf7\u7a0d\u540e\u518d\u8bd5!");
    }

    @PostMapping(value={"/generateSql"})
    public Result<?> b(@RequestBody Map<String, Object> params) {
        String dbSource = (String)params.get("dbSource");
        List tables = (List)params.get("tables");
        String requirements = (String)params.get("requirements");
        if (tables == null || tables.isEmpty() || requirements == null || requirements.isEmpty()) {
            return Result.error("\u53c2\u6570\u4e0d\u5b8c\u6574\uff0c\u8bf7\u63d0\u4f9b\u6570\u636e\u6e90\u3001\u8868\u540d\u548c\u9700\u6c42\u63cf\u8ff0");
        }
        try {
            StringBuilder ddlBuilder = new StringBuilder();
            HashMap<String, String> tableComments = new HashMap<String, String>();
            for (String tableName : tables) {
                List<Map<String, Object>> tableInfo = OkConvertUtils.isNotEmpty(dbSource) ? this.jmReportDbService.queryTableName(dbSource, "") : this.jmReportDbSourceService.getAllTable();
                for (Map<String, Object> tableData : tableInfo) {
                    if (tableData == null) continue;
                    String name = String.valueOf(tableData.get("name"));
                    if (!tableName.toLowerCase().equals(name.toLowerCase()) || !tableData.containsKey("Comment")) continue;
                    tableComments.put(tableName, String.valueOf(tableData.get("Comment")));
                }
            }
            for (String tableName : tables) {
                List<Map<String, Object>> tableColumns = OkConvertUtils.isNotEmpty(dbSource) ? this.jmReportDbService.loadDsTableFields(dbSource, tableName) : this.jmReportDbSourceService.getTableFields(tableName);
                String tableComment = tableComments.getOrDefault(tableName, "");
                String tableDdl = this.a(tableName, tableColumns, tableComment);
                ddlBuilder.append(tableDdl).append("\n\n");
            }
            String ddl = ddlBuilder.toString();
            JSONObject sqlRes = this.jimuAiAssistantService.callAiService(requirements, ddl, dbSource, "genSql");
            if (null != sqlRes && sqlRes.containsKey((Object)"sql")) {
                String sql = sqlRes.getString("sql");
                if (sql.contains(";")) {
                    sql = sql.replace(";", "");
                }
                return Result.OK(sql);
            }
            return Result.error("AI\u5f00\u5c0f\u5dee\u4e86,\u8bf7\u7a0d\u540e\u518d\u8bd5!");
        }
        catch (Exception e2) {
            a.error("\u751f\u6210SQL\u5931\u8d25:", (Throwable)e2);
            return Result.error("\u751f\u6210SQL\u5931\u8d25: " + e2.getMessage());
        }
    }

    @PostMapping(value={"/generateDesign"})
    public Result<?> c(@RequestBody Map<String, Object> params) {
        String datasetStructure = (String)params.get("datasetStructure");
        String requirements = (String)params.get("requirements");
        if (datasetStructure == null || datasetStructure.isEmpty() || requirements == null || requirements.isEmpty()) {
            return Result.error("\u53c2\u6570\u4e0d\u5b8c\u6574\uff0c\u8bf7\u63d0\u4f9b\u6570\u636e\u96c6\u7ed3\u6784\u548c\u9700\u6c42\u63cf\u8ff0");
        }
        try {
            JSONObject designRes = this.jimuAiAssistantService.callAiService(requirements, datasetStructure, "", "genJsonRows");
            if (null != designRes && designRes.containsKey((Object)"designJson")) {
                return Result.OK(designRes.getString("designJson"));
            }
            return Result.error("AI\u5f00\u5c0f\u5dee\u4e86,\u8bf7\u7a0d\u540e\u518d\u8bd5!");
        }
        catch (Exception e2) {
            a.error("\u751f\u6210\u62a5\u8868\u8bbe\u8ba1\u5931\u8d25:", (Throwable)e2);
            return Result.error("\u751f\u6210\u62a5\u8868\u8bbe\u8ba1\u5931\u8d25: " + e2.getMessage());
        }
    }

    @PostMapping(value={"/generateDesign/static"})
    public Result<?> d(@RequestBody Map<String, Object> params) {
        String requirements = (String)params.get("requirements");
        if (requirements == null || requirements.isEmpty()) {
            return Result.error("\u53c2\u6570\u4e0d\u5b8c\u6574\uff0c\u8bf7\u63d0\u4f9b\u9700\u6c42\u63cf\u8ff0");
        }
        try {
            JSONObject designRes = this.jimuAiAssistantService.callAiService(requirements, "[]", "", "designReport");
            if (null != designRes && designRes.containsKey((Object)"designJson")) {
                return Result.OK(designRes.getString("designJson"));
            }
            return Result.error("AI\u5f00\u5c0f\u5dee\u4e86,\u8bf7\u7a0d\u540e\u518d\u8bd5!");
        }
        catch (Exception e2) {
            a.error("\u751f\u6210\u62a5\u8868\u8bbe\u8ba1\u5931\u8d25:", (Throwable)e2);
            return Result.error("\u751f\u6210\u62a5\u8868\u8bbe\u8ba1\u5931\u8d25: " + e2.getMessage());
        }
    }

    @PostMapping(value={"/generateChart"})
    public Result<?> e(@RequestBody Map<String, Object> params) {
        String datasetStructure = (String)params.get("datasetStructure");
        String requirements = (String)params.get("requirements");
        if (datasetStructure == null || datasetStructure.isEmpty() || requirements == null || requirements.isEmpty()) {
            return Result.error("\u53c2\u6570\u4e0d\u5b8c\u6574\uff0c\u8bf7\u63d0\u4f9b\u6570\u636e\u96c6\u7ed3\u6784\u548c\u9700\u6c42\u63cf\u8ff0");
        }
        try {
            JSONObject extData;
            JSONObject designRes = this.jimuAiAssistantService.callAiService(requirements, datasetStructure, "", "genChart");
            if (null != designRes && designRes.containsKey((Object)"chart") && OkConvertUtils.isNotEmpty(extData = designRes.getJSONObject("chart")) && extData.containsKey((Object)"chartType")) {
                JSONObject chartObj = this.jmReportDesignService.addChart(extData.getString("chartType"));
                JSONObject respData = new JSONObject();
                respData.put("extData", (Object)extData);
                respData.put("chartObj", (Object)chartObj);
                return Result.OK(respData);
            }
            return Result.error("AI\u5f00\u5c0f\u5dee\u4e86,\u8bf7\u7a0d\u540e\u518d\u8bd5!");
        }
        catch (Exception e2) {
            a.error("\u751f\u6210\u62a5\u8868\u8bbe\u8ba1\u5931\u8d25:", (Throwable)e2);
            return Result.error("\u751f\u6210\u62a5\u8868\u8bbe\u8ba1\u5931\u8d25: " + e2.getMessage());
        }
    }

    @PostMapping(value={"/generatePrompt"})
    public Result<?> f(@RequestBody Map<String, Object> params) {
        String requirements = (String)params.get("requirements");
        String datasetStructure = (String)params.get("datasetStructure");
        if (OkConvertUtils.isEmpty(requirements) && OkConvertUtils.isEmpty(datasetStructure)) {
            return Result.error("\u53c2\u6570\u4e0d\u5b8c\u6574\uff0c\u8bf7\u63d0\u4f9b\u9700\u6c42\u63cf\u8ff0");
        }
        try {
            JSONObject designRes = this.jimuAiAssistantService.callAiService(requirements, datasetStructure, "", "genPrompt");
            if (null != designRes && designRes.containsKey((Object)"prompt")) {
                return Result.OK(designRes.getString("prompt"));
            }
            return Result.error("AI\u5f00\u5c0f\u5dee\u4e86,\u8bf7\u7a0d\u540e\u518d\u8bd5!");
        }
        catch (Exception e2) {
            a.error("\u751f\u6210\u62a5\u8868\u8bbe\u8ba1\u5931\u8d25:", (Throwable)e2);
            return Result.error("\u751f\u6210\u62a5\u8868\u8bbe\u8ba1\u5931\u8d25: " + e2.getMessage());
        }
    }

    @PostMapping(value={"/intentCheck"})
    public Result<?> g(@RequestBody Map<String, Object> params) {
        String datasetStructure = (String)params.get("datasetStructure");
        String requirements = (String)params.get("requirements");
        if (datasetStructure == null || datasetStructure.isEmpty() || requirements == null || requirements.isEmpty()) {
            return Result.error("\u53c2\u6570\u4e0d\u5b8c\u6574\uff0c\u8bf7\u63d0\u4f9b\u6570\u636e\u96c6\u7ed3\u6784\u548c\u9700\u6c42\u63cf\u8ff0");
        }
        try {
            JSONObject designRes = this.jimuAiAssistantService.callAiService(requirements, datasetStructure, "", "intentCheck");
            if (null != designRes && designRes.containsKey((Object)"intent")) {
                return Result.OK(designRes.getString("intent"));
            }
            return Result.error("AI\u5f00\u5c0f\u5dee\u4e86,\u8bf7\u7a0d\u540e\u518d\u8bd5!");
        }
        catch (Exception e2) {
            a.error("\u751f\u6210\u62a5\u8868\u8bbe\u8ba1\u5931\u8d25:", (Throwable)e2);
            return Result.error("\u751f\u6210\u62a5\u8868\u8bbe\u8ba1\u5931\u8d25: " + e2.getMessage());
        }
    }

    private String a(String tableName, List<Map<String, Object>> columns, String tableComment) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(tableName);
        if (tableComment != null && !tableComment.isEmpty() && !"null".equals(tableComment)) {
            sb.append(" COMMENT '").append(tableComment).append("'");
        }
        sb.append(" (\n");
        for (int i2 = 0; i2 < columns.size(); ++i2) {
            Map<String, Object> column = columns.get(i2);
            String name = String.valueOf(column.getOrDefault("COLUMN_NAME", column.get("name")));
            String dataType = String.valueOf(column.getOrDefault("DATA_TYPE", column.getOrDefault("type", "VARCHAR")));
            String length = column.containsKey("CHARACTER_MAXIMUM_LENGTH") ? String.valueOf(column.get("CHARACTER_MAXIMUM_LENGTH")) : "";
            String comment = String.valueOf(column.getOrDefault("COLUMN_COMMENT", column.getOrDefault("Comment", "")));
            String nullable = String.valueOf(column.getOrDefault("NULLABLE", "YES"));
            String type = dataType;
            if (length != null && !length.isEmpty() && !"null".equals(length) && ("varchar".equalsIgnoreCase(dataType) || "char".equalsIgnoreCase(dataType))) {
                type = dataType + "(" + length + ")";
            }
            sb.append("  ").append(name).append(" ").append(type);
            if ("NO".equalsIgnoreCase(nullable)) {
                sb.append(" NOT NULL");
            }
            if (comment != null && !comment.isEmpty() && !"null".equalsIgnoreCase(comment)) {
                sb.append(" COMMENT '").append(comment).append("'");
            }
            if (i2 < columns.size() - 1) {
                sb.append(",");
            }
            sb.append("\n");
        }
        sb.append(");");
        return sb.toString();
    }
}

