# python连接打印机打印目录
> date 20240131

当需要打印大量PDF文件时，人工操作需要逐个打开文件并点击打印，这一过程非常繁琐。为了简化操作流程并方便用户，我们新增了通过脚本自动打印目录下所有PDF文件的功能。

要实现通过脚本自动打印目录的功能，需要安装python环境，并确保本机和打印机网络互通。同时，需要将打印机添加到本机系统的打印机列表中。

## 环境要求

* python 3.6+
* pip3 9.0+

## python下载

访问[python官方网站](https://www.python.org/downloads/)下载系统对应python安装包
运行安装程序跟着指引安装。

## pip安装

> * Python 2.7.9 + 或 Python 3.4+ 以上版本都自带 pip 工具。不需要手动安装了。
> * Python 2.x 对应的是pip；python3.x 对应的是pip3

可以通过`pip3 --version`来判断是否安装pip

如果你还未安装，则可以使用以下方法来安装：

1. 下载[安装脚本](https://bootstrap.pypa.io/get-pip.py)
2. 使用命令行工具运行脚本：`python get-pip.py`


## 依赖包安装
**windows操作系统**

```
pip install -y pywin32
```

**linux、Macos**

```
pip install -y pycyps
```

## 使用方法

1. 根据本机系统选择对应的打印脚本文件：
    * `Windows`：`win_printer.py`
    * `Linux`/`Mac OS`：`linux_printer.py`
2. 将脚本文件存放在系统任意目录下
3. 打开命令行工具，运行脚本。
    ```shell
    $ python <打印脚本文件> <需要打印的目录>
    ```
