/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.api;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.modules.jmreport.common.util.JimuSpringContextUtils;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;

public interface JmReportTokenServiceI {
    public static final Logger log = LoggerFactory.getLogger(JmReportTokenServiceI.class);
    public static final String SYS_USER_CODE = "sysUserCode";
    public static final String SYS_ORG_CODE = "sysOrgCode";
    public static final String SYS_DATE = "sysDate";
    public static final String SYS_DATE_TIME = "sysDateTime";

    default public String getToken(HttpServletRequest request) {
        if (request != null) {
            String string = request.getParameter("token");
            if (string == null) {
                string = request.getHeader("X-Access-Token");
            }
            return string;
        }
        return null;
    }

    default public String getToken() {
        HttpServletRequest httpServletRequest = null;
        try {
            httpServletRequest = JimuSpringContextUtils.getHttpServletRequest();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getToken(httpServletRequest);
    }

    public String getUsername(String var1);

    default public String[] getRoles(String token) {
        log.warn(" warn:: \u8bf7\u5b9e\u73b0 JmReportTokenServiceI.getRoles \u65b9\u6cd5\uff0c\u5426\u5219\u5b58\u5728\u6f0f\u6d1e\u653b\u51fb\u98ce\u9669!");
        return new String[]{"admin", "lowdeveloper", "dbadeveloper"};
    }

    public Boolean verifyToken(String var1);

    default public Map<String, Object> getUserInfo(String token) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
        hashMap.put(SYS_USER_CODE, this.getUsername(token));
        hashMap.put(SYS_ORG_CODE, "");
        return hashMap;
    }

    default public HttpHeaders customApiHeader() {
        return null;
    }

    default public String getTenantId() {
        String string = null;
        try {
            HttpServletRequest httpServletRequest = JimuSpringContextUtils.getHttpServletRequest();
            if (httpServletRequest != null && OkConvertUtils.isEmpty(string = httpServletRequest.getHeader("JmReport-Tenant-Id"))) {
                string = httpServletRequest.getParameter("tenantId");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    default public String[] getPermissions(String token) {
        log.warn(" warn:: \u8bf7\u5b9e\u73b0 JmReportTokenServiceI.getPermissions \u65b9\u6cd5\uff0c\u5426\u5219\u5b58\u5728\u6f0f\u6d1e\u653b\u51fb\u98ce\u9669!");
        return new String[]{"drag:datasource:testConnection", "onl:drag:clear:recovery", "drag:analysis:sql", "drag:design:getTotalData", "onl:drag:page:delete"};
    }
}

