/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.util;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkConvertUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OkConvertUtils.class);

    public static boolean isEmptyString(CharSequence str) {
        return str == null || str.length() == 0 || "null".equals(str) || "".equals(str);
    }

    public static boolean isEmptyMap(Map<?, ?> map) {
        return null == map || map.isEmpty();
    }

    public static boolean isEmptyIterable(Iterable<?> iterable) {
        return null == iterable || OkConvertUtils.isEmpty(iterable.iterator());
    }

    public static boolean isEmptyIterator(Iterator<?> iterator) {
        return null == iterator || false == iterator.hasNext();
    }

    public static boolean isArray(Object obj) {
        if (null == obj) {
            return false;
        }
        return obj.getClass().isArray();
    }

    public static boolean isEmptyArray(Object array) {
        if (null == array) {
            return true;
        }
        if (OkConvertUtils.isArray(array)) {
            return 0 == Array.getLength(array);
        }
        throw new JimuReportException("Object to provide is not a Array !");
    }

    public static boolean isEmpty(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return OkConvertUtils.isEmptyString((CharSequence)obj);
        }
        if (obj instanceof Map) {
            return OkConvertUtils.isEmptyMap((Map)obj);
        }
        if (obj instanceof Iterable) {
            return OkConvertUtils.isEmptyIterable((Iterable)obj);
        }
        if (obj instanceof Iterator) {
            return OkConvertUtils.isEmptyIterator((Iterator)obj);
        }
        if (OkConvertUtils.isArray(obj)) {
            return OkConvertUtils.isEmptyArray(obj);
        }
        return false;
    }

    public static boolean isNotEmpty(Object object) {
        return !OkConvertUtils.isEmpty(object);
    }

    public static String decode(String strIn, String sourceCode, String targetCode) {
        String string = OkConvertUtils.code2code(strIn, sourceCode, targetCode);
        return string;
    }

    public static boolean isNumeric(String str) {
        return str.matches("-?[0-9]+.?[0-9]*");
    }

    private static String code2code(String strIn, String sourceCode, String targetCode) {
        String string = null;
        if (strIn == null || "".equals(strIn.trim())) {
            return strIn;
        }
        try {
            byte[] byArray = strIn.getBytes(sourceCode);
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                System.out.print(byArray[i2] + "  ");
            }
            string = new String(byArray, targetCode);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return string;
    }

    public static int getInt(String s2, int defval) {
        if (OkConvertUtils.isEmpty(s2)) {
            return defval;
        }
        try {
            return Integer.parseInt(s2);
        }
        catch (NumberFormatException numberFormatException) {
            log.error(numberFormatException.getMessage(), (Throwable)numberFormatException);
            return defval;
        }
    }

    public static int getInt(String s2) {
        if (s2 == null || s2 == "") {
            return 0;
        }
        try {
            return Integer.parseInt(s2);
        }
        catch (NumberFormatException numberFormatException) {
            log.error(numberFormatException.getMessage(), (Throwable)numberFormatException);
            return 0;
        }
    }

    public static int getInt(String s2, Integer df) {
        if (s2 == null || s2 == "") {
            return df;
        }
        try {
            return Integer.parseInt(s2);
        }
        catch (NumberFormatException numberFormatException) {
            log.error(numberFormatException.getMessage(), (Throwable)numberFormatException);
            return 0;
        }
    }

    public static int getInt(Object object, int defval) {
        if (OkConvertUtils.isEmpty(object)) {
            return defval;
        }
        try {
            if (object instanceof Float) {
                return ((Float)object).intValue();
            }
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            log.error(numberFormatException.getMessage(), (Throwable)numberFormatException);
            return defval;
        }
    }

    public static Integer getInt(Object object) {
        if (OkConvertUtils.isEmpty(object)) {
            return null;
        }
        try {
            if (object instanceof Float) {
                return ((Float)object).intValue();
            }
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            log.error(numberFormatException.getMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public static int getInt(BigDecimal s2, int defval) {
        if (s2 == null) {
            return defval;
        }
        return s2.intValue();
    }

    public static String getString(String s2) {
        return OkConvertUtils.getString(s2, "");
    }

    public static String getString(Object object) {
        if (OkConvertUtils.isEmpty(object)) {
            return "";
        }
        return object.toString().trim();
    }

    public static String getString(int i2) {
        return String.valueOf(i2);
    }

    public static String getString(float i2) {
        return String.valueOf(i2);
    }

    public static String getString(String s2, String defval) {
        if (OkConvertUtils.isEmpty(s2)) {
            return defval;
        }
        return s2.trim();
    }

    public static String getString(Object s2, String defval) {
        if (OkConvertUtils.isEmpty(s2)) {
            return defval;
        }
        return s2.toString().trim();
    }

    public static String getJmString(Object s2) {
        if (OkConvertUtils.isEmpty(s2)) {
            return "";
        }
        return s2.toString();
    }

    public static String getIp() {
        String string = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        return string;
    }

    public static String camelToUnderline(String para) {
        int n2 = 3;
        if (para.length() < n2) {
            return para.toLowerCase();
        }
        StringBuilder stringBuilder = new StringBuilder(para);
        int n3 = 0;
        for (int i2 = 2; i2 < para.length(); ++i2) {
            if (!Character.isUpperCase(para.charAt(i2))) continue;
            stringBuilder.insert(i2 + n3, "_");
            ++n3;
        }
        return stringBuilder.toString().toLowerCase();
    }

    public static Field[] getAllFields(Object object) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            arrayList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
        }
        Field[] fieldArray = new Field[arrayList.size()];
        arrayList.toArray(fieldArray);
        return fieldArray;
    }

    public static String join(Object[] array, String separator, int startIndex, int endIndex) {
        int n2;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        if ((n2 = endIndex - startIndex) <= 0) {
            return "";
        }
        StringBuilder stringBuilder = OkConvertUtils.newStringBuilder(n2);
        if (array[startIndex] != null) {
            stringBuilder.append(array[startIndex]);
        }
        for (int i2 = startIndex + 1; i2 < endIndex; ++i2) {
            stringBuilder.append(separator);
            if (array[i2] == null) continue;
            stringBuilder.append(array[i2]);
        }
        return stringBuilder.toString();
    }

    private static StringBuilder newStringBuilder(int noOfItems) {
        return new StringBuilder(noOfItems * 16);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int startPos) {
        int n2;
        if (str == null || searchStr == null) {
            return -1;
        }
        if (startPos < 0) {
            startPos = 0;
        }
        if (startPos > (n2 = str.length() - searchStr.length() + 1)) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return startPos;
        }
        for (int i2 = startPos; i2 < n2; ++i2) {
            if (!OkConvertUtils.regionMatches(str, true, i2, searchStr, 0, searchStr.length())) continue;
            return i2;
        }
        return -1;
    }

    public static boolean regionMatches(CharSequence cs, boolean ignoreCase, int thisStart, CharSequence substring, int start, int length) {
        if (cs instanceof String && substring instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, thisStart, (String)substring, start, length);
        }
        int n2 = thisStart;
        int n3 = start;
        int n4 = length;
        int n5 = cs.length() - thisStart;
        int n6 = substring.length() - start;
        if (thisStart < 0 || start < 0 || length < 0) {
            return false;
        }
        if (n5 < length || n6 < length) {
            return false;
        }
        while (n4-- > 0) {
            char c2;
            char c3;
            if ((c3 = cs.charAt(n2++)) == (c2 = substring.charAt(n3++))) continue;
            if (!ignoreCase) {
                return false;
            }
            if (Character.toUpperCase(c3) == Character.toUpperCase(c2) || Character.toLowerCase(c3) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    public static byte[] decodeBase64(String base64Str) {
        byte[] byArray = Base64.decodeBase64((String)base64Str);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> deepCopy(List<T> list) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        ObjectInputStream objectInputStream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(list);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            List list2 = (List)objectInputStream.readObject();
            return list2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.flush();
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
            try {
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return Collections.emptyList();
    }

    public static JSONObject jsonDeepClone(JSONObject jsonObject) {
        if (null != jsonObject && jsonObject.size() > 0) {
            return JSONObject.parseObject((String)jsonObject.toJSONString());
        }
        return new JSONObject();
    }

    public static <T> boolean isIn(T obj, T ... objs) {
        if (OkConvertUtils.isEmpty(objs)) {
            return false;
        }
        for (T t2 : objs) {
            if (!OkConvertUtils.isEqualsRegardingNull(obj, t2)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean isNotIn(T obj, T ... objs) {
        return !OkConvertUtils.isIn(obj, objs);
    }

    public static boolean isEqualsRegardingNull(Object expected, Object actual) {
        if (expected == null) {
            return actual == null;
        }
        return OkConvertUtils.isEquals(expected, actual);
    }

    public static boolean isEquals(Object expected, Object actual) {
        return expected.equals(actual);
    }

    public static boolean isGt(Date src, Date des) {
        if (null == src || null == des) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return DateUtils.a(src, des) == 1;
    }

    public static boolean isGt(Number src, Number des) {
        if (null == src || null == des) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return src.doubleValue() > des.doubleValue();
    }

    public static boolean isGe(Date src, Date des) {
        if (null == src || null == des) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int n2 = DateUtils.a(src, des);
        return n2 >= 0;
    }

    public static boolean isGe(Number src, Number des) {
        if (null == src || null == des) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return !(src.doubleValue() < des.doubleValue());
    }

    public static <T> T createFrom(Map<String, Object> source, Class<T> targetClazz) {
        if (OkConvertUtils.isEmpty(source)) {
            return null;
        }
        String string = JSONObject.toJSONString(source);
        return (T)JSONObject.parseObject((String)string, targetClazz);
    }

    public static <T> List<T> createFromListMap(List<Map<String, Object>> sources, Class<T> targetClazz) {
        ArrayList arrayList = new ArrayList();
        if (OkConvertUtils.isNotEmpty(sources)) {
            sources.forEach(source -> arrayList.add(OkConvertUtils.createFrom(source, targetClazz)));
        }
        return arrayList;
    }
}

