/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

public class JimuI18nUtils {
    private static final Log logger = LogFactory.getLog(JimuI18nUtils.class);
    private static MessageSource messageSource = null;

    public JimuI18nUtils() {
        messageSource = this.messageSource();
    }

    public ReloadableResourceBundleMessageSource messageSource() {
        ReloadableResourceBundleMessageSource reloadableResourceBundleMessageSource = new ReloadableResourceBundleMessageSource();
        reloadableResourceBundleMessageSource.setBasenames(new String[]{"file:" + this.getLocalExternalConfigPath(), "classpath:i18n/messages"});
        reloadableResourceBundleMessageSource.setDefaultEncoding("UTF-8");
        reloadableResourceBundleMessageSource.setCacheSeconds(3600);
        reloadableResourceBundleMessageSource.setDefaultLocale(Locale.SIMPLIFIED_CHINESE);
        return reloadableResourceBundleMessageSource;
    }

    private String getLocalExternalConfigPath() {
        String string = this.getClass().getResource("").toString();
        Path path = string.startsWith("jar:") ? Paths.get(System.getProperty("user.dir"), "config/i18n/messages") : Paths.get("config/i18n/messages", new String[0]).toAbsolutePath();
        return path.toString().replace("\\", "/");
    }

    public static String get(String msgKey) {
        String string;
        Locale locale = LocaleContextHolder.getLocale();
        try {
            string = null == messageSource ? msgKey : messageSource.getMessage(msgKey, null, locale);
        }
        catch (NoSuchMessageException noSuchMessageException) {
            logger.warn((Object)noSuchMessageException.getMessage());
            string = msgKey;
        }
        return string;
    }

    public static String getAndReplace(String msgKey, Object ... args) {
        String string;
        Locale locale = LocaleContextHolder.getLocale();
        try {
            string = null == messageSource ? msgKey : messageSource.getMessage(msgKey, args, locale);
        }
        catch (NoSuchMessageException noSuchMessageException) {
            logger.warn((Object)noSuchMessageException.getMessage());
            string = msgKey;
        }
        return string;
    }
}

