/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.SortedMap;
import java.util.TreeMap;
import lombok.Generated;
import org.jeecg.modules.jmreport.common.annotation.JimuSignature;
import org.jeecg.modules.jmreport.common.util.JimuSpringContextUtils;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.util.wrapper.BodyReaderHttpServletRequestWrapper;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.jeecg.modules.jmreport.config.JmReportBaseConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.DigestUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class JimuReportSignatureInterceptor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JimuReportSignatureInterceptor.class);
    public static final String X_SIGN = "X-Sign";
    public static final String X_TIMESTAMP = "X-TIMESTAMP";
    public static final String DEFAULT_SECRET = "aa05f1c54d63749eda95f9fa6d49v442a";
    private static final long MAX_EXPIRE = 300L;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!this.needSignatureVerification(handler)) {
            return true;
        }
        JmReportBaseConfig jmReportBaseConfig = JimuSpringContextUtils.getBean(JmReportBaseConfig.class);
        if (this.isSafeMode(jmReportBaseConfig).booleanValue()) {
            String string = request.getHeader(X_TIMESTAMP);
            String string2 = request.getHeader(X_SIGN);
            Long l2 = Long.parseLong(string);
            if (System.currentTimeMillis() - l2 > 300000L) {
                log.error("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:X-TIMESTAMP\u5df2\u8fc7\u671f\uff0c\u6ce8\u610f\u7cfb\u7edf\u65f6\u95f4\u548c\u670d\u52a1\u5668\u65f6\u95f4\u662f\u5426\u6709\u8bef\u5dee\uff01");
                this.error(response, "\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:X-TIMESTAMP\u5df2\u8fc7\u671f");
                return false;
            }
            BodyReaderHttpServletRequestWrapper bodyReaderHttpServletRequestWrapper = new BodyReaderHttpServletRequestWrapper(request);
            SortedMap<String, String> sortedMap = this.getQueryParams(bodyReaderHttpServletRequestWrapper);
            String string3 = JSONObject.toJSONString(sortedMap);
            String string4 = DigestUtils.md5DigestAsHex((byte[])(string3 + DEFAULT_SECRET).getBytes()).toUpperCase();
            if (!string4.equals(string2)) {
                log.error("\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff01Header Sign : {},\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)string2, (Object)bodyReaderHttpServletRequestWrapper.getRequestURL().toString());
                this.error(response, "\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff0c\u53c2\u6570\u6709\u8bef\uff01");
                return false;
            }
        }
        return true;
    }

    private boolean needSignatureVerification(Object handler) {
        if (!(handler instanceof HandlerMethod)) {
            return false;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        Class clazz = handlerMethod.getBeanType();
        JimuSignature jimuSignature = method.getAnnotation(JimuSignature.class);
        if (jimuSignature != null) {
            return jimuSignature.value();
        }
        JimuSignature jimuSignature2 = clazz.getAnnotation(JimuSignature.class);
        if (jimuSignature2 != null) {
            return jimuSignature2.value();
        }
        return false;
    }

    private void error(HttpServletResponse response, String msg) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        PrintWriter printWriter = response.getWriter();
        Result<Object> result = Result.error(msg);
        result.setCode(1001);
        printWriter.print(JSON.toJSON(result));
    }

    private SortedMap<String, String> getQueryParams(BodyReaderHttpServletRequestWrapper request) {
        JSONObject jSONObject;
        String string;
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        String string2 = request.getQueryString();
        if (OkConvertUtils.isNotEmpty(string2)) {
            string = "";
            try {
                string = URLDecoder.decode(string2, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            jSONObject = string.split("&");
            for (Object object : jSONObject) {
                int n2 = ((String)object).indexOf("=");
                treeMap.put(((String)object).substring(0, n2), ((String)object).substring(n2 + 1));
            }
        }
        if (RequestMethod.POST.name().equals(request.getMethod()) && OkConvertUtils.isNotEmpty(string = request.getBody())) {
            jSONObject = JSON.parseObject((String)string);
            for (String string3 : jSONObject.keySet()) {
                String string4 = jSONObject.getString(string3);
                treeMap.put(string3, string4);
            }
        }
        return treeMap;
    }

    private Boolean isSafeMode(JmReportBaseConfig jmConfig) {
        Environment environment;
        Boolean bl = jmConfig.getFirewall() != null ? jmConfig.getFirewall().getDataSourceSafe() : false;
        if (bl == null && (bl = (Boolean)(environment = JimuSpringContextUtils.getBean(Environment.class)).getProperty("jeecg.safeMode", Boolean.class, (Object)false)) == null) {
            bl = (Boolean)environment.getProperty("jeecg.firewall.dataSourceSafe", Boolean.class, (Object)false);
        }
        return bl;
    }

    private String getSignatureSecret(JmReportBaseConfig jmConfig) {
        String string = jmConfig.getSignatureSecret();
        if (string == null) {
            Environment environment = JimuSpringContextUtils.getBean(Environment.class);
            string = (String)environment.getProperty("jeecg.signatureSecret", String.class, (Object)DEFAULT_SECRET);
        }
        return string;
    }
}

