/**
 * 重写一些vue的事件
 * @param Vue
 * @param messageId
 */
function overrideVuePrototype(Vue, messageId) {

  // 判断必要的参数
  if (!Vue || !messageId || !window['JmForm'] || !window['JmForm'].default || !window['JmForm'].default['overrideVuePrototype']) {
    return
  }

  const overrideVuePrototype = window['JmForm'].default['overrideVuePrototype']

  if (typeof overrideVuePrototype === 'function') {
    overrideVuePrototype(Vue, {
      $message: overrideMessage(),
    })
  }

  // 重写 $message
  function overrideMessage() {
    return {
      success(message) {
        postEvent('show-message', { type: 'success', message: message }, messageId)
      },
      error(message) {
        postEvent('show-message', { type: 'error', message: message }, messageId)
      },
      warn(message) {
        // console.log('messageId', messageId)

        postEvent('show-message', { type: 'warn', message: message }, messageId)
      },
      warning(message) {
        // console.log('messageId', messageId)

        postEvent('show-message', { type: 'warn', message: message }, messageId)
      },
      info(message) {
        postEvent('show-message', { type: 'info', message: message }, messageId)
      },
    }
  }
}
