/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.lang.invoke.SerializedLambda;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.modules.online.desform.entity.DesignForm;
import org.jeecg.modules.online.desform.entity.DesignFormUrlAuth;
import org.jeecg.modules.online.desform.mapper.DesignFormUrlAuthMapper;
import org.jeecg.modules.online.desform.service.IDesignFormUrlAuthService;
import org.jeecg.modules.online.desform.service.impl.g;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="designFormUrlAuthServiceImpl")
public class j
extends ServiceImpl<DesignFormUrlAuthMapper, DesignFormUrlAuth>
implements IDesignFormUrlAuthService {
    @Autowired
    DesignFormUrlAuthMapper mapper;
    @Autowired
    g designFormService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean initialUrlAuth(String desformCode) {
        DesignForm designForm = this.designFormService.getByCode(desformCode);
        if (designForm != null) {
            String id = designForm.getId();
            String code = designForm.getDesformCode();
            this.mapper.insert(new DesignFormUrlAuth(id, code, "add"));
            this.mapper.insert(new DesignFormUrlAuth(id, code, "edit"));
            this.mapper.insert(new DesignFormUrlAuth(id, code, "detail"));
            return true;
        }
        return false;
    }

    @Override
    public boolean urlIsPassed(String desformCode, String urlType) {
        Integer status = this.getUrlStatus(desformCode, urlType);
        return CommonConstant.DESIGN_FORM_URL_STATUS_PASSED.equals(status);
    }

    @Override
    public Integer getUrlStatus(String desformCode, String urlType) {
        LambdaQueryWrapper<DesignFormUrlAuth> queryWrapper;
        if (this.a(urlType) && (queryWrapper = this.b(desformCode)) != null) {
            queryWrapper.eq(DesignFormUrlAuth::getUrlType, (Object)urlType);
            DesignFormUrlAuth auth = (DesignFormUrlAuth)this.mapper.selectOne((Wrapper)queryWrapper);
            if (auth == null) {
                this.initialUrlAuth(desformCode);
                return CommonConstant.DESIGN_FORM_URL_STATUS_PASSED;
            }
            return auth.getUrlStatus();
        }
        return null;
    }

    @Override
    public boolean setUrlStatus(String desformCode, String urlType, Integer status) {
        LambdaQueryWrapper<DesignFormUrlAuth> wrapper = this.b(desformCode);
        if (wrapper != null) {
            return this.setUrlStatus(wrapper, urlType, status);
        }
        return false;
    }

    @Override
    public boolean setUrlStatus(LambdaQueryWrapper<DesignFormUrlAuth> wrapper, String urlType, Integer status) {
        DesignFormUrlAuth auth = new DesignFormUrlAuth();
        auth.setUrlStatus(status);
        wrapper.eq(DesignFormUrlAuth::getUrlType, (Object)urlType);
        return this.mapper.update(auth, (Wrapper)wrapper) > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean setAllUrlStatus(String desformCode, Integer ... status) {
        if (this.designFormService.getByCode(desformCode) != null) {
            this.setUrlStatus(this.c(desformCode), "add", status[0]);
            this.setUrlStatus(this.c(desformCode), "edit", status[1]);
            this.setUrlStatus(this.c(desformCode), "detail", status[2]);
            return true;
        }
        return false;
    }

    private boolean a(String urlType) {
        switch (urlType) {
            case "add": 
            case "edit": 
            case "detail": 
            case "view": {
                return true;
            }
        }
        return false;
    }

    private LambdaQueryWrapper<DesignFormUrlAuth> b(String desformCode) {
        if (this.designFormService.getByCode(desformCode) != null) {
            return this.c(desformCode);
        }
        return null;
    }

    private LambdaQueryWrapper<DesignFormUrlAuth> c(String desformCode) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DesignFormUrlAuth::getDesformCode, (Object)desformCode);
        return wrapper;
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "getDesformCode": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormUrlAuth") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return DesignFormUrlAuth::getDesformCode;
            }
            case "getUrlType": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormUrlAuth") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return DesignFormUrlAuth::getUrlType;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/desform/entity/DesignFormUrlAuth") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return DesignFormUrlAuth::getUrlType;
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

