/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.util.DateUtils;
import org.jeecg.modules.online.desform.constant.WidgetTypes;
import org.jeecg.modules.online.desform.entity.DesignForm;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.service.IDesignFormDataService;
import org.jeecg.modules.online.desform.service.IDesignFormService;
import org.jeecg.modules.online.desform.service.IDesignFormToolsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="designFormToolsServiceImpl")
public class i
implements IDesignFormToolsService {
    @Autowired
    ISysBaseAPI sysBaseApi;
    @Autowired
    private IDesignFormDataService dataService;
    @Autowired
    private IDesignFormService designFormService;

    @Override
    public Result indexChangeModel(String desformCode, String oldKey, String newKey) {
        return this.a(desformCode, data -> {
            if (data.containsKey((Object)oldKey) && !oldKey.equals(newKey)) {
                data.put(newKey, data.get((Object)oldKey));
                data.remove((Object)oldKey);
                return true;
            }
            return false;
        });
    }

    @Override
    public Result indexFormatData(String desformCode, String widgetType, String action, String model) {
        return this.a(desformCode, data -> {
            if (!data.containsKey((Object)model)) {
                return false;
            }
            String value = data.getString(model);
            if (value == null) {
                return false;
            }
            WidgetTypes type = WidgetTypes.getByValue(widgetType);
            if (type == null) {
                return false;
            }
            switch (type) {
                case INPUT: 
                case NUMBER: {
                    return this.a((JSONObject)data, (Object)value, action, model);
                }
                case DATE: {
                    return this.b((JSONObject)data, value, action, model);
                }
            }
            return false;
        });
    }

    private boolean a(JSONObject data, Object value, String action, String model) {
        Object afterValue;
        switch (action) {
            case "num2str": {
                afterValue = value.toString();
                break;
            }
            case "str2num": {
                try {
                    afterValue = Integer.parseInt(value.toString());
                    break;
                }
                catch (NumberFormatException e2) {
                    throw new JeecgBootException("\"" + value + "\"\u4e0d\u662f\u6570\u5b57\uff0c\u62d2\u7edd\u6267\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u4fee\u6539\u5b8c\u6570\u636e\u540e\u91cd\u8bd5\uff01");
                }
            }
            default: {
                return false;
            }
        }
        data.put(model, afterValue);
        return true;
    }

    private boolean b(JSONObject data, Object value, String action, String model) {
        String afterValue;
        Date dateTime;
        SimpleDateFormat dateFormat = (SimpleDateFormat)DateUtils.date_sdf.get();
        SimpleDateFormat datetimeFormat = (SimpleDateFormat)DateUtils.datetimeFormat.get();
        try {
            dateTime = dateFormat.parse(value.toString());
        }
        catch (ParseException ex) {
            try {
                dateTime = datetimeFormat.parse(value.toString());
            }
            catch (ParseException e2) {
                throw new JeecgBootException("\"" + value + "\"\u4e0d\u662f\u65e5\u671f\uff0c\u62d2\u7edd\u6267\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u4fee\u6539\u5b8c\u6570\u636e\u540e\u91cd\u8bd5\uff01");
            }
        }
        switch (action) {
            case "remove_time": {
                afterValue = dateFormat.format(dateTime);
                break;
            }
            case "add_time": {
                afterValue = datetimeFormat.format(dateTime);
                break;
            }
            default: {
                return false;
            }
        }
        data.put(model, (Object)afterValue);
        return true;
    }

    public Result a(String desformCode, Function<JSONObject, Boolean> function) {
        DesignForm designForm = this.designFormService.getByCode(desformCode);
        if (designForm == null) {
            return Result.error((String)"\u4e0d\u5b58\u5728\u7684\u8868\u5355");
        }
        List<DesignFormData> dataList = this.dataService.queryByCode(desformCode);
        ArrayList<DesignFormData> updateDataList = new ArrayList<DesignFormData>(dataList.size());
        int count = 0;
        for (DesignFormData data : dataList) {
            boolean success;
            JSONObject dataJson = JSON.parseObject((String)data.getDesformDataJson());
            try {
                success = function.apply(dataJson);
            }
            catch (JeecgBootException e2) {
                return Result.error((String)e2.getMessage());
            }
            if (!success) continue;
            ++count;
            DesignFormData updateData = new DesignFormData();
            updateData.setId(data.getId());
            updateData.setDesformDataJson(dataJson.toJSONString());
            updateDataList.add(updateData);
        }
        if (updateDataList.size() == 0) {
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f\uff0c\u4f46\u662f\u6ca1\u6709\u4efb\u4f55\u66f4\u6539");
        }
        if (this.dataService.updateBatchById(updateDataList)) {
            this.designFormService.redoAllIndexForce(designForm.getId(), null);
            if (count == dataList.size()) {
                return Result.ok((String)String.format("\u64cd\u4f5c\u6210\u529f\uff0c%s\u6761\u6570\u636e\u5168\u90e8\u66f4\u6539\u5b8c\u6bd5", count));
            }
            return Result.ok((String)String.format("\u64cd\u4f5c\u6210\u529f\uff0c\u66f4\u6539\u4e86%s\u6761\u6570\u636e\uff0c\u672a\u66f4\u6539%s\u6761\u6570\u636e", count, dataList.size() - count));
        }
        return Result.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u539f\u56e0\u672a\u77e5\u2026");
    }
}

