/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jeecg.common.api.dto.DragRelIdsDTO;
import org.jeecg.common.desform.api.IDesformBaseApi;
import org.jeecg.common.desform.vo.DesignFormDataVo;
import org.jeecg.common.drag.api.IDragBaseApi;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.lowapp.model.LowAppCopyMenu;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.desform.d.a;
import org.jeecg.modules.online.desform.entity.DesignForm;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.mongo.model.ButtonInfo;
import org.jeecg.modules.online.desform.mongo.model.DesignFormListChartConfig;
import org.jeecg.modules.online.desform.mongo.service.IDesignFormListChartConfigService;
import org.jeecg.modules.online.desform.mongo.service.IDesignFormListViewButtonService;
import org.jeecg.modules.online.desform.mongo.service.IDesignFormListViewService;
import org.jeecg.modules.online.desform.service.IDesignFormDataService;
import org.jeecg.modules.online.desform.service.IDesignFormService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="desformBaseApiImpl")
public class DesformBaseApiImpl
implements IDesformBaseApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DesformBaseApiImpl.class);
    @Autowired
    IDesignFormService designFormService;
    @Autowired
    IDesignFormDataService dataService;
    @Lazy
    @Autowired
    IDesignFormListViewService designFormListViewService;
    @Lazy
    @Autowired
    IDragBaseApi dragBaseApi;
    @Autowired
    IDesignFormListViewButtonService designFormListViewButtonService;
    @Autowired
    IDesignFormListChartConfigService designFormListChartConfigService;
    @Lazy
    @Autowired
    a translService;

    public DesignFormDataVo getDataById(String desformCode, String id) {
        DesignFormData data = this.dataService.getById(desformCode, id);
        DesignFormDataVo vo = new DesignFormDataVo();
        if (data != null) {
            BeanUtils.copyProperties((Object)data, (Object)vo);
        }
        return vo;
    }

    public JSONObject getFieldDataById(String desformCode, String dataId, Collection<String> fieldNames) {
        return this.dataService.getFieldDataById(desformCode, dataId, fieldNames);
    }

    public DesignFormDataVo getTranslateDataById(String desformCode, String id) {
        DesignFormData data = this.dataService.getById(desformCode, id);
        ArrayList<DesignFormData> listDesignFormData = new ArrayList<DesignFormData>();
        DesignForm designForm = this.designFormService.getByCode(desformCode);
        listDesignFormData.add(data);
        this.translService.a(designForm, listDesignFormData);
        this.dataService.queryLinkFieldData(designForm, listDesignFormData, true);
        DesignFormDataVo vo = new DesignFormDataVo();
        if (data != null) {
            BeanUtils.copyProperties(listDesignFormData.get(0), (Object)vo);
        }
        return vo;
    }

    public List<DesignFormDataVo> getDataByIds(String desformCode, String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List<DesignFormData> dataList = this.dataService.getByIds(desformCode, idList);
        ArrayList<DesignFormDataVo> voList = new ArrayList<DesignFormDataVo>(dataList.size());
        for (DesignFormData data : dataList) {
            DesignFormDataVo vo = new DesignFormDataVo();
            BeanUtils.copyProperties((Object)data, (Object)vo);
            voList.add(vo);
        }
        return voList;
    }

    public boolean updateDataById(String desformCode, String id, JSONObject jsonData) {
        DesignFormData data = new DesignFormData(desformCode, jsonData);
        data.setId(id);
        data.setDesformCode(desformCode);
        return this.dataService.updateById(data);
    }

    public boolean deleteDataById(String desformCode, String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        return this.dataService.removeBatchByIds(desformCode, idList);
    }

    public JSONObject translateListDataByJsonArray(String desformCode, JSONArray dataList) {
        return this.translateListDataByJsonArray2(desformCode, null, dataList);
    }

    public JSONObject translateListDataByJsonArray2(String desformCode, String onlyFields, JSONArray dataList) {
        JSONObject translated;
        DesignForm designForm = this.designFormService.getByCode(desformCode);
        if (designForm == null) {
            throw new JeecgBootException(desformCode + " \u4e0d\u5b58\u5728");
        }
        ArrayList<DesignFormData> data = new ArrayList<DesignFormData>();
        for (int i2 = 0; i2 < dataList.size(); ++i2) {
            JSONObject jsonObject = dataList.getJSONObject(i2);
            DesignFormData designFormData = new DesignFormData(desformCode, jsonObject);
            data.add(designFormData);
        }
        if (oConvertUtils.isNotEmpty((Object)onlyFields)) {
            HashSet<String> fieldSet = new HashSet<String>(Arrays.asList(onlyFields.split(",")));
            translated = this.translService.a(designForm, data, fieldSet);
        } else {
            translated = this.translService.a(designForm, data);
        }
        this.dataService.queryLinkFieldData(designForm, data, true);
        return translated;
    }

    public boolean deleteDesignForm(String designFormCode) {
        return this.designFormService.deleteAll(designFormCode);
    }

    public boolean realDeleteDesignForm(String desformCode) {
        return this.designFormService.realDeleteAll(desformCode);
    }

    public LowAppCopyMenu copyDesignForm(LowAppCopyMenu lowAppCopyMenu) {
        return this.designFormService.copyDesignForm(lowAppCopyMenu);
    }

    public void updateDesignFormJson(LowAppCopyMenu lowAppCopyMenu) {
        Map formCodeMapping = lowAppCopyMenu.getFormCodeMapping();
        if (formCodeMapping != null && formCodeMapping.size() > 0) {
            for (String code : formCodeMapping.values()) {
                this.designFormService.updateDesignFormJson(code, formCodeMapping, lowAppCopyMenu.getAppIdMapping(), lowAppCopyMenu.getDictCodeMapping());
            }
        }
    }

    public void coverDesignForm(LowAppCopyMenu lowAppCopyMenu) {
        this.designFormService.coverDesignForm(lowAppCopyMenu);
    }

    public List<JSONObject> getViewListByCode(String desformCode) {
        return this.designFormListViewService.getAllView(desformCode);
    }

    public void updateLowAppButtonProcessId(LowAppCopyMenu lowAppCopyMenu) {
        List designFormCodeList = lowAppCopyMenu.getDesignFormCodeList();
        if (designFormCodeList.size() > 0) {
            Map processIdMap = lowAppCopyMenu.getProcessIdMapping();
            List<ButtonInfo> list = this.designFormListViewButtonService.queryButtonByCode(designFormCodeList);
            if (list != null && list.size() > 0) {
                for (ButtonInfo info : list) {
                    String newProcessId;
                    String processId = info.getProcessId();
                    if (oConvertUtils.isEmpty((Object)processId) || !oConvertUtils.isNotEmpty((Object)(newProcessId = (String)processIdMap.get(processId)))) continue;
                    this.designFormListViewButtonService.updateProcessId(info.getId(), newProcessId);
                }
            }
        }
    }

    public void copyLowAppChart(LowAppCopyMenu lowAppCopyMenu) {
        List<DesignFormListChartConfig> list;
        Map formCodeMap = lowAppCopyMenu.getFormCodeMapping();
        Map formIdMap = lowAppCopyMenu.getFormIdMapping();
        Map dragIdMap = lowAppCopyMenu.getDragIdMapping();
        Map viewIdMap = lowAppCopyMenu.getViewIdMapping();
        Map processIdMap = lowAppCopyMenu.getProcessIdMapping();
        Map dictCodeMapping = lowAppCopyMenu.getDictCodeMapping();
        ArrayList<String> oldCodeList = new ArrayList<String>(formCodeMap.keySet());
        if (oldCodeList != null && oldCodeList.size() > 0 && (list = this.designFormListChartConfigService.queryChartListByFormCode(oldCodeList)) != null && list.size() > 0) {
            ArrayList<DesignFormListChartConfig> saveList = new ArrayList<DesignFormListChartConfig>();
            for (DesignFormListChartConfig config : list) {
                DesignFormListChartConfig temp = new DesignFormListChartConfig();
                BeanUtils.copyProperties((Object)config, (Object)temp);
                temp.setId(null);
                temp.setCreateTime(new Date());
                String code = config.getDesignFormCode();
                String newCode = (String)formCodeMap.get(code);
                if (newCode != null) {
                    temp.setDesignFormCode(newCode);
                }
                String id = config.getChartId();
                DragRelIdsDTO dragRelIdsDTO = new DragRelIdsDTO(id, formCodeMap, formIdMap, dragIdMap, viewIdMap, processIdMap, dictCodeMapping);
                dragRelIdsDTO.setTenantId(lowAppCopyMenu.getTenantId());
                String newChartId = this.dragBaseApi.copyPageCrossApp(dragRelIdsDTO);
                temp.setChartId(newChartId);
                saveList.add(temp);
            }
            this.designFormListChartConfigService.batchSave(saveList);
        }
    }

    public void deleteDesignFormForAppCopy(String menuUrl, Boolean deleteMongo) {
        DesignForm form = this.designFormService.getByCode(menuUrl);
        if (form == null) {
            form = this.designFormService.getByIdCache(menuUrl);
        }
        if (form == null) {
            return;
        }
        this.designFormService.removeById((Serializable)((Object)form.getId()));
        if (deleteMongo.booleanValue()) {
            this.designFormListViewService.deleteDesignFormMongoConfig(form.getDesformCode());
        }
    }

    public void batchDisabledOtherTenantLinkRecords(LowAppCopyMenu copyMenu) {
        if (oConvertUtils.isEmpty((Object)copyMenu.getTenantId()) || Integer.valueOf(0).equals(copyMenu.getTenantId())) {
            return;
        }
        Map formCodeMapping = copyMenu.getFormCodeMapping();
        if (formCodeMapping != null && formCodeMapping.size() > 0) {
            for (String code : formCodeMapping.values()) {
                this.designFormService.disabledOtherTenantLinkRecords(code, copyMenu.getTenantId());
            }
        }
    }
}

