/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.desform.mongo.service.a;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import org.jeecg.common.api.CommonAPI;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.SysUserCacheInfo;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.TokenUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.desform.constant.b;
import org.jeecg.modules.online.desform.entity.DesignForm;
import org.jeecg.modules.online.desform.entity.DesignFormData;
import org.jeecg.modules.online.desform.mongo.service.IDataMongoCurdService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Conditional(value={org.jeecg.modules.online.desform.datafactory.a.b.class})
@Service(value="dataMongoCurdServiceImpl")
public class a
implements IDataMongoCurdService {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Lazy
    @Autowired
    private CommonAPI commonApi;

    @Override
    public boolean save(String desformCode, DesignFormData designFormData) {
        String jsonStr = designFormData.getDesformDataJson();
        JSONObject jsonData = JSON.parseObject((String)jsonStr, (Feature[])new Feature[]{Feature.OrderedField});
        jsonData.put("desform_id", (Object)designFormData.getDesformId());
        jsonData.put("desform_name", (Object)designFormData.getDesformName());
        jsonData.put("desform_version", (Object)designFormData.getDesformVersion());
        jsonData.put("online_form_code", (Object)designFormData.getOnlineFormCode());
        jsonData.put("online_form_id", (Object)designFormData.getOnlineFormDataId());
        jsonData.put("bpm_status", (Object)designFormData.getBpmStatus());
        jsonData.put("x_oa_timeout_date", (Object)designFormData.getxOaTimeoutDate());
        jsonData.put("x_oa_archive_status", (Object)designFormData.getxOaArchiveStatus());
        jsonData.put("del_flag", (Object)b.aj);
        String id = org.jeecg.modules.online.desform.mongo.b.a.a(designFormData, jsonData);
        designFormData.setId(id);
        SysUserCacheInfo userCacheInfo = this.commonApi.getCacheUser(designFormData.getCreateBy());
        if (userCacheInfo != null) {
            designFormData.setSysOrgCode(userCacheInfo.getSysOrgCode());
            jsonData.put("sys_org_code", (Object)designFormData.getSysOrgCode());
        }
        this.mongoTemplate.insert((Object)jsonData, desformCode);
        return true;
    }

    @Override
    public boolean save(DesignForm designForm, DesignFormData designFormData) {
        String desformCode = designForm.getDesformCode();
        return this.save(desformCode, designFormData);
    }

    @Override
    public int saveBatch(String desformCode, Collection<DesignFormData> dataList) {
        HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
        String token = TokenUtils.getTokenByRequest((HttpServletRequest)request);
        String userName = JwtUtil.getUsername((String)token);
        SysUserCacheInfo userCacheInfo = this.commonApi.getCacheUser(userName);
        String sysOrgCode = null;
        if (userCacheInfo != null) {
            sysOrgCode = userCacheInfo.getSysOrgCode();
        }
        JSONArray jsonArray = new JSONArray(dataList.size());
        for (DesignFormData data : dataList) {
            String jsonStr = data.getDesformDataJson();
            JSONObject jsonData = JSON.parseObject((String)jsonStr, (Feature[])new Feature[]{Feature.OrderedField});
            jsonData.put("desform_id", (Object)data.getDesformId());
            jsonData.put("desform_name", (Object)data.getDesformName());
            jsonData.put("desform_version", (Object)data.getDesformVersion());
            jsonData.put("online_form_code", (Object)data.getOnlineFormCode());
            jsonData.put("online_form_id", (Object)data.getOnlineFormDataId());
            jsonData.put("bpm_status", (Object)data.getBpmStatus());
            jsonData.put("x_oa_timeout_date", (Object)data.getxOaTimeoutDate());
            jsonData.put("x_oa_archive_status", (Object)data.getxOaArchiveStatus());
            jsonData.put("del_flag", (Object)b.aj);
            data.setSysOrgCode(sysOrgCode);
            String id = org.jeecg.modules.online.desform.mongo.b.a.a(data, jsonData);
            data.setId(id);
            jsonArray.add((Object)jsonData);
        }
        return this.mongoTemplate.insert((Collection)jsonArray, desformCode).size();
    }

    @Override
    public int saveBatch(DesignForm designForm, Collection<DesignFormData> designFormData) {
        String desformCode = designForm.getDesformCode();
        return this.saveBatch(desformCode, designFormData);
    }

    @Override
    public boolean update(String desformCode, DesignFormData designFormData) {
        String id = designFormData.getId();
        String jsonStr = designFormData.getDesformDataJson();
        JSONObject jsonData = oConvertUtils.isNotEmpty((Object)jsonStr) ? JSON.parseObject((String)jsonStr, (Feature[])new Feature[]{Feature.OrderedField}) : new JSONObject();
        org.jeecg.modules.online.desform.mongo.b.a.a(designFormData, jsonData);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id));
        Update update = null;
        for (String key : jsonData.keySet()) {
            if ("_id".equals(key)) continue;
            if (update == null) {
                update = Update.update((String)key, (Object)jsonData.get((Object)key));
                continue;
            }
            update.set(key, jsonData.get((Object)key));
        }
        if (update != null) {
            UpdateResult result = this.mongoTemplate.updateFirst(query, update, desformCode);
            return result.getModifiedCount() > 0L;
        }
        return false;
    }

    @Override
    public boolean update(DesignForm designForm, DesignFormData designFormData) {
        String desformCode = designForm.getDesformCode();
        return this.update(desformCode, designFormData);
    }

    @Override
    public int updateBatch(String desformCode, Collection<DesignFormData> designFormData) {
        int count = 0;
        for (DesignFormData data : designFormData) {
            if (!this.update(desformCode, data)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int updateBatch(DesignForm designForm, Collection<DesignFormData> designFormData) {
        String desformCode = designForm.getDesformCode();
        return this.updateBatch(desformCode, designFormData);
    }

    @Override
    public boolean delete(String desformCode) {
        this.mongoTemplate.getCollection(desformCode).drop();
        return true;
    }

    @Override
    public boolean delete(String desformCode, String dataId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)dataId));
        DeleteResult result = this.mongoTemplate.remove(query, desformCode);
        return result.getDeletedCount() > 0L;
    }

    @Override
    public boolean deleteBatch(String desformCode, Collection<String> dataIds) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").in(dataIds));
        DeleteResult result = this.mongoTemplate.remove(query, desformCode);
        return result.getDeletedCount() > 0L;
    }

    @Override
    public boolean removeField(String desformCode, String dataId, String ... fieldNames) {
        if (fieldNames == null || fieldNames.length == 0) {
            return true;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)dataId));
        Update update = new Update();
        for (String field : fieldNames) {
            if ("_id".equals(field)) continue;
            update.unset(field);
        }
        UpdateResult result = this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, desformCode);
        return result.getModifiedCount() > 0L;
    }
}

