/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.aspect;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.system.vo.UserAccountInfo;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.extbpm.process.pojo.DepInfo;
import org.jeecg.modules.extbpm.process.pojo.PositionInfo;
import org.jeecg.modules.extbpm.process.pojo.RoleInfo;
import org.jeecg.modules.extbpm.process.pojo.UserInfo;
import org.jeecg.modules.extbpm.process.service.IExtActProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Aspect
@Component(value="sysUserAspect")
public class SysUserAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysUserAspect.class);
    @Lazy
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Autowired
    private IExtActProcessService extActProcessService;

    @Pointcut(value="execution(public * org.jeecg.modules.*.controller.SysUserController.add(..))")
    public void excudeServiceAdd() {
    }

    @Around(value="excudeServiceAdd()")
    public Object doAroundAdd(ProceedingJoinPoint pjp) throws Throwable {
        Object result = pjp.proceed();
        try {
            Object[] args = pjp.getArgs();
            JSONObject param = (JSONObject)args[0];
            String userName = param.getString("username");
            log.info("------------SysUserAspect------add----" + userName);
            LoginUser user = this.sysBaseAPI.getUserByName(userName);
            if (user != null && CommonConstant.ACT_SYNC_1.equals(user.getActivitiSync())) {
                UserInfo userInfo = new UserInfo();
                userInfo.setUuid(user.getId());
                userInfo.setFirstName(user.getRealname());
                userInfo.setEmail(user.getEmail());
                userInfo.setId(user.getUsername());
                List<RoleInfo> roleList = this.extActProcessService.getSysRolesByUserId(userInfo.getUuid());
                List<DepInfo> depList = this.extActProcessService.getSysDepsByUserId(userInfo.getUuid());
                List<PositionInfo> positionList = this.extActProcessService.getSysPositionsByUserId(userInfo.getUuid());
                this.extActProcessService.saveActIdMembership(userInfo, roleList, depList, positionList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Pointcut(value="execution(public * org.jeecg.modules.*.controller.SysUserController.edit(..))")
    public void excudeServiceEdit() {
    }

    @Around(value="excudeServiceEdit()")
    public Object doAroundEdit(ProceedingJoinPoint pjp) throws Throwable {
        Object result = pjp.proceed();
        try {
            Object[] args = pjp.getArgs();
            JSONObject param = (JSONObject)args[0];
            String userName = param.getString("username");
            log.info("------------SysUserAspect------edit----" + userName);
            LoginUser user = this.sysBaseAPI.getUserByName(userName);
            if (user != null) {
                if (CommonConstant.ACT_SYNC_1.equals(user.getActivitiSync())) {
                    UserInfo userInfo = new UserInfo();
                    userInfo.setUuid(user.getId());
                    userInfo.setFirstName(user.getRealname());
                    userInfo.setEmail(user.getEmail());
                    userInfo.setId(user.getUsername());
                    List<RoleInfo> roleList = this.extActProcessService.getSysRolesByUserId(userInfo.getUuid());
                    List<DepInfo> depList = this.extActProcessService.getSysDepsByUserId(userInfo.getUuid());
                    List<PositionInfo> positionList = this.extActProcessService.getSysPositionsByUserId(userInfo.getUuid());
                    this.extActProcessService.saveActIdMembership(userInfo, roleList, depList, positionList);
                } else {
                    this.extActProcessService.deleteActIdMembership(userName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Pointcut(value="execution(public * org.jeecg.modules.*.controller.SysUserController.putRecycleBin(..))")
    public void excudeServicePutRecycleBin() {
    }

    @Around(value="excudeServicePutRecycleBin()")
    public Object doAroundPutRecycleBin(ProceedingJoinPoint pjp) throws Throwable {
        Object result = pjp.proceed();
        try {
            Object[] args = pjp.getArgs();
            JSONObject param = (JSONObject)args[0];
            String userIds = param.getString("userIds");
            log.info("------------SysUserAspect------PutRecycleBin----" + userIds);
            if (oConvertUtils.isNotEmpty((Object)userIds)) {
                List userList = this.sysBaseAPI.queryAllUserByIds(userIds.split(","));
                for (UserAccountInfo user : userList) {
                    if (!CommonConstant.ACT_SYNC_1.equals(user.getActivitiSync())) continue;
                    UserInfo userInfo = new UserInfo();
                    userInfo.setUuid(user.getId());
                    userInfo.setFirstName(user.getRealname());
                    userInfo.setEmail(user.getEmail());
                    userInfo.setId(user.getUsername());
                    List<RoleInfo> roleList = this.extActProcessService.getSysRolesByUserId(userInfo.getUuid());
                    List<DepInfo> depList = this.extActProcessService.getSysDepsByUserId(userInfo.getUuid());
                    List<PositionInfo> positionList = this.extActProcessService.getSysPositionsByUserId(userInfo.getUuid());
                    this.extActProcessService.saveActIdMembership(userInfo, roleList, depList, positionList);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Pointcut(value="execution(public * org.jeecg.modules.*.controller.SysUserController.delete(..))")
    public void excudeServiceDelete() {
    }

    @Around(value="excudeServiceDelete()")
    public Object doAroundDelete(ProceedingJoinPoint pjp) throws Throwable {
        try {
            Object[] args = pjp.getArgs();
            String id = (String)args[0];
            log.info("------------SysUserAspect------delete----" + id);
            LoginUser user = this.sysBaseAPI.getUserById(id);
            if (user != null) {
                this.extActProcessService.deleteActIdMembership(user.getUsername());
            }
        }
        catch (Exception args) {
            // empty catch block
        }
        Object result = pjp.proceed();
        return result;
    }

    @Pointcut(value="execution(public * org.jeecg.modules.*.controller.SysUserController.deleteBatch(..))")
    public void excudeServiceDeleteBatch() {
    }

    @Around(value="excudeServiceDeleteBatch()")
    public Object doAroundDeleteBatch(ProceedingJoinPoint pjp) throws Throwable {
        try {
            String[] idArr;
            Object[] args = pjp.getArgs();
            String ids = (String)args[0];
            log.info("------------SysUserAspect------deleteBatch----" + ids);
            for (String id : idArr = ids.split(",")) {
                LoginUser user = this.sysBaseAPI.getUserById(id);
                if (user == null) continue;
                this.extActProcessService.deleteActIdMembership(user.getUsername());
            }
        }
        catch (Exception args) {
            // empty catch block
        }
        Object result = pjp.proceed();
        return result;
    }

    @Pointcut(value="execution(public * org.jeecg.modules.*.controller.SysRoleController.delete(..))")
    public void excudeServiceRoleDelete() {
    }

    @Pointcut(value="execution(public * org.jeecg.modules.*.controller.SysRoleController.deleteBatch(..))")
    public void excudeServiceRoleDeleteBatch() {
    }

    @Around(value="excudeServiceRoleDelete()")
    public Object doAroundRoleDelete(ProceedingJoinPoint pjp) throws Throwable {
        try {
            Object[] args = pjp.getArgs();
            String id = (String)args[0];
            log.info("------------SysUserAspect---Role---delete----" + id);
            String roleCode = this.sysBaseAPI.getRoleCodeById(id);
            this.extActProcessService.deleteFlowRoleSet(roleCode);
        }
        catch (Exception args) {
            // empty catch block
        }
        Object result = pjp.proceed();
        return result;
    }

    @Around(value="excudeServiceRoleDeleteBatch()")
    public Object doAroundRoleDeleteBatch(ProceedingJoinPoint pjp) throws Throwable {
        try {
            String[] idArr;
            Object[] args = pjp.getArgs();
            String ids = (String)args[0];
            log.info("------------SysUserAspect---Roles---deleteBatch----" + ids);
            for (String id : idArr = ids.split(",")) {
                String roleCode = this.sysBaseAPI.getRoleCodeById(id);
                this.extActProcessService.deleteFlowRoleSet(roleCode);
            }
        }
        catch (Exception args) {
            // empty catch block
        }
        Object result = pjp.proceed();
        return result;
    }
}

