/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.pay.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.exception.JeecgBootBizTipException;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.pay.constant.PayConstant;
import org.jeecg.modules.pay.entity.SysVipInvoiceApply;
import org.jeecg.modules.pay.entity.SysVipInvoicePayments;
import org.jeecg.modules.pay.entity.SysVipPayments;
import org.jeecg.modules.pay.mapper.SysVipInvoiceApplyMapper;
import org.jeecg.modules.pay.mapper.SysVipInvoicePaymentsMapper;
import org.jeecg.modules.pay.mapper.SysVipPaymentsMapper;
import org.jeecg.modules.pay.service.ISysVipInvoiceApplyService;
import org.jeecg.modules.pay.vo.SysPaymentsUserVo;
import org.jeecg.modules.pay.vo.SysVipInvoiceApplyVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysVipInvoiceApplyServiceImpl
extends ServiceImpl<SysVipInvoiceApplyMapper, SysVipInvoiceApply>
implements ISysVipInvoiceApplyService {
    @Autowired
    private SysVipInvoiceApplyMapper vipInvoiceApplyMapper;
    @Autowired
    private SysVipInvoicePaymentsMapper vipInvoicePaymentsMapper;
    @Autowired
    private SysVipPaymentsMapper vipPaymentsMapper;

    @Override
    public BigDecimal getInvoicePrice(String paymentIds) {
        LocalDate currentDate = LocalDate.now();
        int dayOfMonth = currentDate.getDayOfMonth();
        if (dayOfMonth > 25) {
            throw new JeecgBootBizTipException("\u6bcf\u4e2a\u67081\u53f7~25\u53f7\u624d\u53ef\u4ee5\u7533\u8bf7\u5f00\u53d1\u7968\uff01");
        }
        LambdaQueryWrapper paymentQuery = new LambdaQueryWrapper();
        paymentQuery.in(SysVipInvoicePayments::getPaymentId, Arrays.asList(paymentIds.split(",")));
        Long paymentCount = this.vipInvoicePaymentsMapper.selectCount((Wrapper)paymentQuery);
        if (paymentCount > 0L) {
            throw new JeecgBootBizTipException("\u60a8\u9009\u62e9\u7684\u8ba2\u5355\u4e2d\u5305\u542b\u5df2\u5f00\u8fc7\u53d1\u7968\u7684\uff0c\u8bf7\u9009\u62e9\u672a\u5f00\u8fc7\u53d1\u7968\u7684\u8ba2\u5355\uff01");
        }
        SysPaymentsUserVo invoicePrice = this.vipPaymentsMapper.getInvoicePrice(Arrays.asList(paymentIds.split(",")));
        if (null == invoicePrice || null == invoicePrice.getTotalAmount()) {
            throw new JeecgBootBizTipException("\u603b\u91d1\u989d\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5f00\u5177\u53d1\u7968\uff01");
        }
        if (PayConstant.INVOICE_AMOUNT.compareTo(invoicePrice.getTotalAmount()) > 0) {
            throw new JeecgBootBizTipException("\u603b\u6d88\u8d39\u91d1\u989d\uff1a" + invoicePrice.getTotalAmount() + "\uff0c\u672a\u8fbe\u5230" + PayConstant.INVOICE_AMOUNT.toPlainString() + "\u5143\u989d\u5ea6\uff0c\u65e0\u6cd5\u5f00\u5177\u53d1\u7968\uff01");
        }
        return invoicePrice.getTotalAmount();
    }

    @Override
    public IPage<SysVipPayments> queryPaymentListByInvoiceId(String invoiceId, Page<SysVipPayments> page) {
        return page.setRecords(this.vipInvoiceApplyMapper.queryPaymentListByInvoiceId(invoiceId, page));
    }

    @Override
    public String saveInvoiceApply(SysVipInvoiceApplyVo sysVipInvoiceApplyVo) {
        String paymentIds = sysVipInvoiceApplyVo.getPaymentIds();
        if (StringUtils.isEmpty((CharSequence)paymentIds)) {
            throw new JeecgBootBizTipException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal invoicePrice = this.getInvoicePrice(paymentIds);
        SysVipInvoiceApply sysVipInvoiceApply = new SysVipInvoiceApply();
        BeanUtils.copyProperties((Object)sysVipInvoiceApplyVo, (Object)sysVipInvoiceApply);
        sysVipInvoiceApply.setPrice(invoicePrice);
        sysVipInvoiceApply.setApplyTime(new Date());
        this.vipInvoiceApplyMapper.insert(sysVipInvoiceApply);
        return sysVipInvoiceApply.getId();
    }

    @Override
    public void deleteInvoiceApply(String id) {
        SysVipInvoiceApply sysVipInvoiceApply;
        if (oConvertUtils.isNotEmpty((Object)id) && null != (sysVipInvoiceApply = (SysVipInvoiceApply)this.vipInvoiceApplyMapper.selectById((Serializable)((Object)id)))) {
            if ("finish".equals(sysVipInvoiceApply.getStatus())) {
                throw new JeecgBootBizTipException("\u53d6\u6d88\u5931\u8d25\uff0c\u5df2\u5f00\u53d1\u7968\u7684\u7981\u6b62\u53d6\u6d88\uff01");
            }
            this.vipInvoicePaymentsMapper.deleteByInvoiceId(id);
            this.vipInvoiceApplyMapper.deleteById((Serializable)((Object)id));
        }
    }

    @Override
    public IPage<SysVipPayments> queryPaymentList(Page<SysVipPayments> page, Integer tenantId) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        return page.setRecords(this.vipInvoiceApplyMapper.queryPaymentList(page, sysUser.getUsername(), tenantId));
    }
}

