/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.pay.interceptor;

import com.alibaba.fastjson.JSONObject;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.constant.enums.vip.PayVipResourceEnum;
import org.jeecg.common.exception.JeecgBootBizTipException;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.TokenUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.JeecgBaseConfig;
import org.jeecg.config.sign.util.BodyReaderHttpServletRequestWrapper;
import org.jeecg.config.vo.WeiXinPay;
import org.jeecg.modules.pay.entity.SysVipMembership;
import org.jeecg.modules.pay.enums.PayInterceptUrlsEnum;
import org.jeecg.modules.pay.service.ISysVipMembershipService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.HandlerInterceptor;

public class PayInterceptor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PayInterceptor.class);
    @Resource
    private JeecgBaseConfig jeecgBaseConfig;
    @Autowired
    private ISysBaseAPI sysBaseAPI;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String status;
        PayVipResourceEnum resourceEnum;
        WeiXinPay weiXinPay;
        if (this.jeecgBaseConfig == null) {
            this.jeecgBaseConfig = (JeecgBaseConfig)SpringContextUtils.getBean(JeecgBaseConfig.class);
        }
        if (this.sysBaseAPI == null) {
            this.sysBaseAPI = (ISysBaseAPI)SpringContextUtils.getBean(ISysBaseAPI.class);
        }
        if ((weiXinPay = this.jeecgBaseConfig.getWeiXinPay()) != null && !weiXinPay.getOpenVipLimit().booleanValue()) {
            return true;
        }
        String requestURI = request.getRequestURI().substring(request.getContextPath().length());
        log.info("\u5f53\u524d\u8def\u5f84\uff1a" + requestURI);
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (loginUser == null) {
            loginUser = this.sysBaseAPI.getUserByName(JwtUtil.getUserNameByToken((HttpServletRequest)SpringContextUtils.getHttpServletRequest()));
        }
        log.info("\u5f53\u524d\u8def\u5f84\uff1a" + requestURI);
        Integer tenantId = oConvertUtils.getInt((String)TokenUtils.getTenantIdByRequest((HttpServletRequest)request));
        ISysVipMembershipService membershipService = (ISysVipMembershipService)SpringContextUtils.getBean(ISysVipMembershipService.class);
        SysVipMembership userVipMember = null;
        String memberType = PayVipResourceEnum.DEFAULT.getCode();
        if (oConvertUtils.isNotEmpty((Object)TokenUtils.getTenantIdByRequest((HttpServletRequest)request)) && null != (userVipMember = membershipService.getUserVipMember(loginUser.getId(), tenantId))) {
            memberType = userVipMember.getMemberType();
        }
        if (null == (resourceEnum = PayVipResourceEnum.valueOfType((String)memberType))) {
            log.info("\u4f1a\u5458\u4fe1\u606f\u672a\u627e\u5230\uff0c\u6570\u636e\u5e93code\u548c\u679a\u4e3ecode\u4e0d\u4e00\u81f4");
            return false;
        }
        String username = loginUser.getUsername();
        if (PayInterceptUrlsEnum.NEW_LOW_APP_ADD_URL.getUrl().equals(requestURI) || PayInterceptUrlsEnum.COPY_LOW_APP.getUrl().equals(requestURI) || PayInterceptUrlsEnum.TEMPLATE_COPY.getUrl().equals(requestURI)) {
            Long lowAppCount = membershipService.getLowAppCount(tenantId);
            int maxAppCount = resourceEnum.getMaxAppCount();
            this.comparingValues(lowAppCount, maxAppCount, "\u5e94\u7528\u521b\u5efa");
        } else if (PayInterceptUrlsEnum.NEW_DESFORM_URL.getUrl().equals(requestURI) || PayInterceptUrlsEnum.COPY_DESFORM_URL.getUrl().equals(requestURI)) {
            Long tableCount = membershipService.getTableCount(tenantId);
            int maxTableCount = resourceEnum.getMaxTableCount();
            this.comparingValues(tableCount, maxTableCount, "\u5de5\u4f5c\u8868\u521b\u5efa");
        } else if (PayInterceptUrlsEnum.NEW_DRAG_URL.getUrl().equals(requestURI)) {
            Long screenCount = membershipService.getDragPageCount(tenantId);
            this.comparingValues(screenCount, resourceEnum.getMaxDragPageCount(), "\u4eea\u8868\u76d8\u521b\u5efa");
        } else if (PayInterceptUrlsEnum.NEW_BIGSCREEN_URL.getUrl().equals(requestURI) || PayInterceptUrlsEnum.COPY_BIGSCREEN_URL.getUrl().equals(requestURI)) {
            Long screenCount = membershipService.getBigScreenCount(tenantId);
            this.comparingValues(screenCount, resourceEnum.getMaxBigScreenCount(), "\u5927\u5c4f\u521b\u5efa");
        } else if (PayInterceptUrlsEnum.NEW_SIMPLE_FLOW_URL.getUrl().equals(requestURI)) {
            String id = request.getParameter("id");
            log.info("\u6d41\u7a0b\u8bbe\u8ba1\u7684\u6570\u636eID = {}", (Object)id);
            if (StringUtils.isEmpty((String)id)) {
                Long flowCount = membershipService.getProcessCount(tenantId);
                this.comparingValues(flowCount, resourceEnum.getMaxWorkFlowCount(), "\u6d41\u7a0b\u521b\u5efa");
            }
        } else if (PayInterceptUrlsEnum.COPY_SIMPLE_FLOW_URL.getUrl().equals(requestURI)) {
            Long flowCount = membershipService.getProcessCount(tenantId);
            this.comparingValues(flowCount, resourceEnum.getMaxWorkFlowCount(), "\u6d41\u7a0b\u521b\u5efa");
        } else if (PayInterceptUrlsEnum.NEW_TENANT_URL.getUrl().equals(requestURI)) {
            resourceEnum = PayVipResourceEnum.valueOfType((String)PayVipResourceEnum.DEFAULT.getCode());
            Long tenantCount = membershipService.getTenantCount(username);
            Long izExistTenantVipCount = membershipService.izExistTenantCountVip(username, tenantId);
            if (izExistTenantVipCount > 0L) {
                resourceEnum = PayVipResourceEnum.valueOfType((String)PayVipResourceEnum.NORMAL_VIP.getCode());
            }
            this.comparingValues(tenantCount, resourceEnum.getMaxTenantCount(), "\u7ec4\u7ec7\u521b\u5efa");
        } else if (PayInterceptUrlsEnum.getUploadUrls().contains(requestURI)) {
            if (PayInterceptUrlsEnum.COMMENT_ADD_FILE_URL.getUrl().equals(requestURI)) {
                String existFileId = request.getParameter("fileId");
                if (oConvertUtils.isNotEmpty((Object)existFileId)) {
                    return true;
                }
            } else if (PayInterceptUrlsEnum.COMMENT_APP_ADD_FILE_URL.getUrl().equals(requestURI)) {
                Long fileSize = Long.valueOf(request.getParameter("fileSize"));
                this.upLoadCountControl(tenantId, resourceEnum, (long)fileSize);
                return true;
            }
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            MultipartFile file = multipartRequest.getFile("file");
            if (PayInterceptUrlsEnum.IM_IMAGE_UPLOAD_URL.getUrl().equals(requestURI)) {
                file = multipartRequest.getFile("image");
            }
            Long fileSize = 0L;
            if (null != file) {
                fileSize = file.getSize();
            }
            if (PayInterceptUrlsEnum.COMMENT_APP_ADD_FILE_URL.getUrl().equals(requestURI)) {
                fileSize = Long.valueOf(request.getParameter("fileSize"));
            }
            this.upLoadCountControl(tenantId, resourceEnum, fileSize);
        } else if (PayInterceptUrlsEnum.JM_REPORT_ADD_URL.getUrl().equals(requestURI)) {
            String requestBody = this.getRequestBody(request);
            Long jmReportCount = membershipService.getJmReportCount(tenantId);
            this.verifyJmReportCount(requestBody, jmReportCount, resourceEnum);
        } else if (PayInterceptUrlsEnum.JM_REPORT_ADD_SOURCE_URL.getUrl().equals(requestURI)) {
            String requestBody = this.getRequestBody(request);
            JSONObject object = JSONObject.parseObject((String)requestBody);
            Object id = object.get((Object)"id");
            if (oConvertUtils.isEmpty((Object)id)) {
                Long jmReportSourceCount = membershipService.getJmReportSourceCount(tenantId);
                this.comparingValues(jmReportSourceCount, resourceEnum.getMaxJmReportSourceCount(), "\u62a5\u8868\u6570\u636e\u6e90\u521b\u5efa");
            }
        } else if (PayInterceptUrlsEnum.BIGSCREEN_ADD_SOURCE_URL.getUrl().equals(requestURI)) {
            Long bigScreenSourceCount = membershipService.getBigScreenSourceCount(tenantId);
            this.comparingValues(bigScreenSourceCount, resourceEnum.getMaxBigScreenSourceCount(), "\u5927\u5c4f\u6570\u636e\u6e90\u521b\u5efa");
        } else if (PayInterceptUrlsEnum.USER_ADD_URL.getUrl().equals(requestURI) || PayInterceptUrlsEnum.INVITATION_USER_URL.getUrl().equals(requestURI) || PayInterceptUrlsEnum.UPDATE_USER_TENANT_STATUS_URL.getUrl().equals(requestURI)) {
            Long userTenantCount = membershipService.getTenantUserCount(tenantId);
            int maxTenantUserCount = resourceEnum.getMaxTenantUserCount();
            if (null != userVipMember) {
                int userCountBuy = userVipMember.getUserCountBuy() == null ? 0 : userVipMember.getUserCountBuy();
                maxTenantUserCount += userCountBuy;
            }
            this.comparingValues(userTenantCount, maxTenantUserCount, "\u79df\u6237\u4e0b\u7684\u7528\u6237\u6570\u91cf");
        } else if (PayInterceptUrlsEnum.AGREE_OR_REFUSE_JOIN_TENANT.getUrl().equals(requestURI) && oConvertUtils.isNotEmpty((Object)(status = request.getParameter("status"))) && "1".equals(status)) {
            int tId = oConvertUtils.getInt((String)request.getParameter("tenantId"));
            Long userTenantCount = membershipService.getTenantUserCount(tId);
            int maxTenantUserCount = resourceEnum.getMaxTenantUserCount();
            if (null != userVipMember) {
                int userCountBuy = userVipMember.getUserCountBuy() == null ? 0 : userVipMember.getUserCountBuy();
                maxTenantUserCount += userCountBuy;
            }
            this.comparingValues(userTenantCount, maxTenantUserCount, "\u79df\u6237\u4e0b\u7684\u7528\u6237\u6570\u91cf");
        }
        return true;
    }

    private void upLoadCountControl(Integer tenantId, PayVipResourceEnum resourceEnum, Long fileSize) {
        double endUploadCount;
        ISysVipMembershipService membershipService = (ISysVipMembershipService)SpringContextUtils.getBean(ISysVipMembershipService.class);
        Long uploadCount = membershipService.getUploadCountByYear(tenantId);
        Integer uploadSizeBuy = membershipService.uploadSizeBuy(tenantId);
        double count = resourceEnum.getMaxUploadSize();
        count += (double)oConvertUtils.getInt((Object)uploadSizeBuy, (int)0);
        double d = endUploadCount = uploadCount == null ? 0.0 : oConvertUtils.calculateFileSizeToMb((Long)uploadCount) + oConvertUtils.calculateFileSizeToMb((Long)fileSize);
        if (endUploadCount >= count) {
            throw new JeecgBootBizTipException("\u4e0a\u4f20\u7a7a\u95f4\u5df2\u8fbe\u4e0a\u9650\uff0c\u8bf7\u5347\u7ea7\u4f1a\u5458\u6216\u8d2d\u4e70\u4e91\u5b58\u50a8\u7a7a\u95f4\uff01");
        }
    }

    private void comparingValues(Long count, int maxCount, String title) {
        if (count >= (long)maxCount) {
            throw new JeecgBootBizTipException(title + "\u5df2\u8fbe\u4e0a\u9650\uff0c\u8bf7\u5347\u7ea7\u4f1a\u5458\uff01");
        }
    }

    private void verifyJmReportCount(String requestBody, Long jmReportCount, PayVipResourceEnum resourceEnum) {
        if (oConvertUtils.isEmpty((Object)requestBody)) {
            this.comparingValues(jmReportCount, resourceEnum.getMaxJmReportCount(), "\u62a5\u8868\u521b\u5efa");
        } else {
            JSONObject jsonObject = JSONObject.parseObject((String)requestBody);
            if (CollectionUtils.isEmpty((Map)jsonObject)) {
                this.comparingValues(jmReportCount, resourceEnum.getMaxJmReportCount(), "\u62a5\u8868\u521b\u5efa");
            }
        }
    }

    private String getRequestBody(HttpServletRequest request) {
        BodyReaderHttpServletRequestWrapper requestWrapper = new BodyReaderHttpServletRequestWrapper(request);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)requestWrapper.getInputStream()));
            String str = "";
            StringBuilder wholeStr = new StringBuilder();
            while ((str = reader.readLine()) != null) {
                wholeStr.append(str);
            }
            return wholeStr.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

