/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.low.aspect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLowApp;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.low.entity.LowAppMenu;
import org.jeecg.modules.online.low.service.ILowAppMenuService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Aspect
@Component(value="lowAppAspect")
public class LowAppAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LowAppAspect.class);
    @Autowired
    ILowAppMenuService appMenuService;

    @Pointcut(value="@annotation(org.jeecg.common.aspect.annotation.AutoLowApp)")
    public void excudeLowAppAspect() {
    }

    @Around(value="excudeLowAppAspect() && @annotation(autoLowApp)")
    public Object excudeLowAppAspect(ProceedingJoinPoint pjp, AutoLowApp autoLowApp) throws Throwable {
        switch (autoLowApp.action()) {
            case ADD: {
                return this.autoAddAspect(pjp, autoLowApp);
            }
            case DELETE: {
                return this.autoDeleteAspect(pjp, autoLowApp);
            }
            case COPY: {
                return this.autoCopyAspect(pjp, autoLowApp);
            }
            case DESFORM_SUB2WORK: {
                return this.doExcudeDesformSubToWorksheet(pjp);
            }
        }
        return pjp.proceed();
    }

    private Object autoAddAspect(ProceedingJoinPoint pjp, AutoLowApp autoLowApp) throws Throwable {
        switch (autoLowApp.bizType()) {
            case "desform": {
                return this.doExcudeDesignAdd(pjp);
            }
            case "drag": {
                return this.doExcudeDragAdd(pjp);
            }
        }
        return this.doInjectAppId(pjp);
    }

    private Object doInjectAppId(ProceedingJoinPoint pjp) throws Throwable {
        Object ret = null;
        try {
            HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
            String lowAppId = request.getHeader("X-Low-App-ID");
            if (oConvertUtils.isNotEmpty((Object)lowAppId)) {
                Object[] args = pjp.getArgs();
                Object page = args[0];
                Field field = ReflectionUtils.findField(page.getClass(), (String)"lowAppId");
                if (field != null) {
                    ReflectionUtils.setField((Field)field, (Object)page, (Object)lowAppId);
                }
                if (!this.isSuccess(ret = pjp.proceed())) {
                    return ret;
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (ret == null) {
            return pjp.proceed();
        }
        return ret;
    }

    private Object autoDeleteAspect(ProceedingJoinPoint pjp, AutoLowApp autoLowApp) throws Throwable {
        Object ret = null;
        try {
            ret = this.autoDeleteMenu(pjp, autoLowApp.bizType());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (ret == null) {
            return pjp.proceed();
        }
        return ret;
    }

    private Object autoCopyAspect(ProceedingJoinPoint pjp, AutoLowApp autoLowApp) throws Throwable {
        HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
        String lowAppId = request.getHeader("X-Low-App-ID");
        if (oConvertUtils.isNotEmpty((Object)lowAppId)) {
            try {
                switch (autoLowApp.bizType()) {
                    default: 
                }
                return pjp.proceed();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return pjp.proceed();
    }

    private Object doExcudeDesignAdd(ProceedingJoinPoint pjp) throws Throwable {
        Object ret = pjp.proceed();
        try {
            Object[] args = pjp.getArgs();
            HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
            String lowAppId = request.getHeader("X-Low-App-ID");
            if (oConvertUtils.isNotEmpty((Object)lowAppId)) {
                Object designFormPage = args[0];
                Class<?> clazz = designFormPage.getClass();
                clazz.getMethod("setLowAppId", String.class).invoke(designFormPage, lowAppId);
                String desformName = clazz.getMethod("getDesformName", new Class[0]).invoke(designFormPage, new Object[0]).toString();
                String desformId = clazz.getMethod("getId", new Class[0]).invoke(designFormPage, new Object[0]).toString();
                String parentMenuId = null;
                Object parentMenuIdObj = clazz.getMethod("getAppMenuGroupId", new Class[0]).invoke(designFormPage, new Object[0]);
                if (parentMenuIdObj != null) {
                    parentMenuId = parentMenuIdObj.toString();
                }
                this.saveLowAppMenu2(lowAppId, desformName, desformId, "form", parentMenuId);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return ret;
    }

    private Object doExcudeDragAdd(ProceedingJoinPoint pjp) throws Throwable {
        Object ret = null;
        try {
            Object[] args = pjp.getArgs();
            HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
            String lowAppId = request.getHeader("X-Low-App-ID");
            if (oConvertUtils.isNotEmpty((Object)lowAppId)) {
                Object onlDragPage = args[0];
                Class<?> clazz = onlDragPage.getClass();
                clazz.getMethod("setLowAppId", String.class).invoke(onlDragPage, lowAppId);
                ret = pjp.proceed();
                if (!this.isSuccess(ret)) {
                    return ret;
                }
                String name = clazz.getMethod("getName", new Class[0]).invoke(onlDragPage, new Object[0]).toString();
                String id = clazz.getMethod("getId", new Class[0]).invoke(onlDragPage, new Object[0]).toString();
                String parentMenuId = null;
                Object parentMenuIdObj = clazz.getMethod("getAppMenuGroupId", new Class[0]).invoke(onlDragPage, new Object[0]);
                if (parentMenuIdObj != null) {
                    parentMenuId = parentMenuIdObj.toString();
                }
                this.saveLowAppMenu2(lowAppId, name, id, "drag", parentMenuId);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (ret == null) {
            return pjp.proceed();
        }
        return ret;
    }

    private void saveLowAppMenu(String lowAppId, String menuName, String menuUrl, String type) {
        LowAppMenu entity = new LowAppMenu();
        entity.setAppId(lowAppId);
        entity.setType(type);
        entity.setMenuName(menuName);
        entity.setMenuUrl(menuUrl);
        entity.setDelFlag(CommonConstant.DEL_FLAG_0);
        this.appMenuService.saveMenu(entity);
    }

    private void saveLowAppMenu2(String lowAppId, String menuName, String menuUrl, String type, String parentId) {
        LowAppMenu entity = new LowAppMenu();
        entity.setAppId(lowAppId);
        entity.setType(type);
        entity.setMenuName(menuName);
        entity.setMenuUrl(menuUrl);
        entity.setDelFlag(CommonConstant.DEL_FLAG_0);
        if (oConvertUtils.isNotEmpty((Object)parentId)) {
            entity.setParentId(parentId);
        }
        this.appMenuService.saveMenu(entity);
    }

    private boolean removeByMenuUrl(String[] menuUrls, String type) {
        if ("desform".equals(type)) {
            return this.appMenuService.forceRemoveByDesformId(Arrays.asList(menuUrls));
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(LowAppMenu::getType, (Object)type);
        wrapper.in(LowAppMenu::getMenuUrl, Arrays.asList(menuUrls));
        return this.appMenuService.forceRemove((LambdaQueryWrapper<LowAppMenu>)wrapper);
    }

    private Object autoDeleteMenu(ProceedingJoinPoint pjp, String type) throws Throwable {
        HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
        String lowAppId = request.getHeader("X-Low-App-ID");
        if (oConvertUtils.isNotEmpty((Object)lowAppId)) {
            Signature signature = pjp.getSignature();
            Method method = ((MethodSignature)signature).getMethod();
            Object[] args = pjp.getArgs();
            String id = (String)args[0];
            String[] ids = "deleteBatch".equals(method.getName()) ? id.split(",") : new String[]{id};
            this.removeByMenuUrl(ids, type);
            return pjp.proceed();
        }
        return null;
    }

    private boolean isSuccess(Object ret) {
        if (ret instanceof Result) {
            return ((Result)ret).isSuccess();
        }
        return true;
    }

    private Object doExcudeDesformSubToWorksheet(ProceedingJoinPoint pjp) throws Throwable {
        HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
        Object ret = pjp.proceed();
        Object argDesignForm = pjp.getArgs()[0];
        JSONObject designForm = JSON.parseObject((String)JSON.toJSONString((Object)argDesignForm));
        String lowAppId = designForm.getString("lowAppId");
        if (oConvertUtils.isNotEmpty((Object)lowAppId)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(LowAppMenu::getAppId, (Object)lowAppId);
            JSONObject parentForm = JSON.parseObject((String)JSON.toJSONString((Object)pjp.getArgs()[2]));
            String parentId = parentForm.getString("id");
            String parentCode = parentForm.getString("desformCode");
            queryWrapper.and(w -> ((LambdaQueryWrapper)((LambdaQueryWrapper)w.eq(LowAppMenu::getMenuUrl, (Object)parentId)).or()).eq(LowAppMenu::getMenuUrl, (Object)parentCode));
            queryWrapper.and(w -> ((LambdaQueryWrapper)((LambdaQueryWrapper)w.eq(LowAppMenu::getType, (Object)"form")).or()).eq(LowAppMenu::getType, (Object)"desform"));
            LowAppMenu parentMenu = (LowAppMenu)this.appMenuService.getOne((Wrapper)queryWrapper);
            if (parentMenu == null) {
                throw new JeecgBootException("\u8868\u5355\u8bbe\u8ba1\u5668\u5b50\u8868\u8f6c\u5de5\u4f5c\u8868\u65f6\u4e3b\u8868\u5e94\u7528\u83dc\u5355\u4e22\u5931");
            }
            String desformId = designForm.getString("id");
            String desformName = designForm.getString("desformName");
            this.saveLowAppMenu2(lowAppId, desformName, desformId, "form", parentMenu.getParentId());
        }
        return ret;
    }
}

