/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.low.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jeecg.common.desform.api.IDesformBaseApi;
import org.jeecg.common.lowapp.model.LowAppFormAuthRecordModel;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.CommonUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.low.b.a;
import org.jeecg.modules.online.low.d.e;
import org.jeecg.modules.online.low.entity.LowApp;
import org.jeecg.modules.online.low.entity.LowAppAuthField;
import org.jeecg.modules.online.low.entity.LowAppAuthForm;
import org.jeecg.modules.online.low.entity.LowAppAuthOperation;
import org.jeecg.modules.online.low.entity.LowAppAuthRecord;
import org.jeecg.modules.online.low.entity.LowAppAuthRole;
import org.jeecg.modules.online.low.entity.LowAppAuthRoleUser;
import org.jeecg.modules.online.low.entity.LowAppMenu;
import org.jeecg.modules.online.low.enums.AuthRoleUserTypeEnum;
import org.jeecg.modules.online.low.enums.EasyAuthOperationEnum;
import org.jeecg.modules.online.low.enums.EasyAuthRecordEnum;
import org.jeecg.modules.online.low.mapper.LowAppAuthRoleMapper;
import org.jeecg.modules.online.low.mapper.LowAppAuthRoleUserMapper;
import org.jeecg.modules.online.low.mapper.LowAppMapper;
import org.jeecg.modules.online.low.mapper.LowAppMenuMapper;
import org.jeecg.modules.online.low.service.ILowAppAuthFieldService;
import org.jeecg.modules.online.low.service.ILowAppAuthFormService;
import org.jeecg.modules.online.low.service.ILowAppAuthOperationService;
import org.jeecg.modules.online.low.service.ILowAppAuthRecordService;
import org.jeecg.modules.online.low.service.ILowAppAuthRoleService;
import org.jeecg.modules.online.low.vo.AppAuthRoleInfo;
import org.jeecg.modules.online.low.vo.AppAuthRoleUser;
import org.jeecg.modules.online.low.vo.AuthFormReadInfo;
import org.jeecg.modules.online.low.vo.LowAppFormAuthModel;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="lowAppAuthRoleServiceImpl")
public class g
extends ServiceImpl<LowAppAuthRoleMapper, LowAppAuthRole>
implements ILowAppAuthRoleService {
    @Autowired
    ILowAppAuthRecordService lowAppAuthRecordService;
    @Autowired
    ILowAppAuthOperationService lowAppAuthOperationService;
    @Autowired
    ILowAppAuthFormService lowAppAuthFormService;
    @Autowired
    ILowAppAuthFieldService lowAppAuthFieldService;
    @Autowired
    LowAppMenuMapper lowAppMenuMapper;
    @Autowired
    LowAppAuthRoleUserMapper lowAppAuthRoleUserMapper;
    @Autowired
    LowAppMapper lowAppMapper;
    @Lazy
    @Autowired
    IDesformBaseApi desformBaseApi;

    @Override
    public String createDefaultRoles(String appId) {
        LowAppAuthRole adminRole = new LowAppAuthRole("\u7ba1\u7406\u5458", "admin", appId);
        adminRole.setOrderNum(1);
        this.save(adminRole);
        LowAppAuthRole elementRole = new LowAppAuthRole("\u6210\u5458", "element", appId);
        elementRole.setOrderNum(2);
        String easyAuthMode = "easy";
        elementRole.setAuthMode(easyAuthMode);
        this.save(elementRole);
        String elementRoleId = elementRole.getId();
        LowAppAuthRecord elementAuthRecord = LowAppAuthRecord.createElementAuth(elementRoleId);
        this.lowAppAuthRecordService.save(elementAuthRecord);
        ArrayList<LowAppAuthOperation> operationList = new ArrayList<LowAppAuthOperation>();
        for (EasyAuthOperationEnum eao : EasyAuthOperationEnum.values()) {
            LowAppAuthOperation operation = new LowAppAuthOperation(elementRoleId, eao.getOpKey(), easyAuthMode, 1);
            operationList.add(operation);
        }
        this.lowAppAuthOperationService.saveBatch(operationList);
        LowAppAuthRole readonlyRole = new LowAppAuthRole("\u53ea\u8bfb", "readonly", appId);
        readonlyRole.setOrderNum(3);
        readonlyRole.setAuthMode(easyAuthMode);
        this.save(readonlyRole);
        String readonlyRoleId = readonlyRole.getId();
        LowAppAuthRecord readonlyAuthRecord = LowAppAuthRecord.createReadOnlyAuth(readonlyRoleId);
        this.lowAppAuthRecordService.save(readonlyAuthRecord);
        ArrayList<LowAppAuthOperation> readonlyOperationList = new ArrayList<LowAppAuthOperation>();
        for (EasyAuthOperationEnum eao : EasyAuthOperationEnum.values()) {
            LowAppAuthOperation operation = new LowAppAuthOperation(readonlyRoleId, eao.getOpKey(), easyAuthMode, 1);
            if (eao == EasyAuthOperationEnum.ADD) {
                operation.setOpStatus(0);
            }
            readonlyOperationList.add(operation);
        }
        this.lowAppAuthOperationService.saveBatch(readonlyOperationList);
        return adminRole.getId();
    }

    @Override
    public AppAuthRoleInfo queryRoleInfo(String id) {
        LowAppAuthRole role = (LowAppAuthRole)this.getById((Serializable)((Object)id));
        if (role != null) {
            AppAuthRoleInfo info = new AppAuthRoleInfo(role);
            if ("easy".equals(info.getAuthMode())) {
                authRecords = this.lowAppAuthRecordService.queryList("easy", id, null);
                info.setRecordAuthList(authRecords);
                authOperations = this.lowAppAuthOperationService.queryList("easy", id, null);
                info.setOperationAuthList(authOperations);
            } else {
                authRecords = this.lowAppAuthRecordService.queryList("super", id, null);
                info.setRecordAuthList(authRecords);
                authOperations = this.lowAppAuthOperationService.queryList("super", id, null);
                info.setOperationAuthList(authOperations);
                List<LowAppAuthForm> appAuthForms = this.lowAppAuthFormService.queryList(id, null);
                info.setFormAuthList(appAuthForms);
                List<LowAppAuthField> authFields = this.lowAppAuthFieldService.queryList(id, null);
                info.setFieldAuthList(authFields);
            }
            String appId = role.getAppId();
            LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppMenu::getAppId, (Object)appId)).eq(LowAppMenu::getDelFlag, (Object)0)).in(LowAppMenu::getType, new Object[]{"desform", "drag", "form"});
            List menuList = this.lowAppMenuMapper.selectList((Wrapper)query);
            info.setMenuList(menuList);
            return info;
        }
        return null;
    }

    @Override
    public String createAuthRole(AppAuthRoleInfo info) {
        LowAppAuthRole lowAppAuthRole = new LowAppAuthRole(info);
        lowAppAuthRole.setAppId(info.getAppId());
        lowAppAuthRole.setOrderNum(info.getOrderNum());
        this.save(lowAppAuthRole);
        String roleId = lowAppAuthRole.getId();
        this.a(roleId, info);
        return roleId;
    }

    private void a(String roleId, AppAuthRoleInfo info) {
        List<LowAppAuthField> list;
        List<LowAppAuthForm> list2;
        List<LowAppAuthOperation> operationAuthList;
        String authMode = info.getAuthMode();
        List<LowAppAuthRecord> recordAuthList = info.getRecordAuthList();
        if (recordAuthList != null && recordAuthList.size() > 0) {
            for (LowAppAuthRecord lowAppAuthRecord : recordAuthList) {
                lowAppAuthRecord.setAppRoleId(roleId);
                lowAppAuthRecord.setAuthMode(authMode);
            }
            this.lowAppAuthRecordService.saveBatch(recordAuthList);
        }
        if ((operationAuthList = info.getOperationAuthList()) != null && operationAuthList.size() > 0) {
            for (LowAppAuthOperation lowAppAuthOperation : operationAuthList) {
                lowAppAuthOperation.setAppRoleId(roleId);
                if (!"easy".equals(authMode)) continue;
                lowAppAuthOperation.setOpType(authMode);
            }
            this.lowAppAuthOperationService.saveBatch(operationAuthList);
        }
        if ((list2 = info.getFormAuthList()) != null && list2.size() > 0) {
            for (LowAppAuthForm authForm : list2) {
                authForm.setAppRoleId(roleId);
            }
            this.lowAppAuthFormService.saveBatch(list2);
        }
        if ((list = info.getFieldAuthList()) != null && list.size() > 0) {
            for (LowAppAuthField authField : list) {
                authField.setAppRoleId(roleId);
            }
            this.lowAppAuthFieldService.saveBatch(list);
        }
    }

    private void a(String roleId) {
        this.lowAppAuthRecordService.deleteByRoleId(roleId);
        this.lowAppAuthOperationService.deleteByRoleId(roleId);
        this.lowAppAuthFormService.deleteByRoleId(roleId);
        this.lowAppAuthFieldService.deleteByRoleId(roleId);
    }

    @Override
    public void updateAuthRole(AppAuthRoleInfo info) {
        LowAppAuthRole authRole = new LowAppAuthRole(info);
        this.updateById(authRole);
        String roleId = info.getId();
        this.a(roleId);
        this.a(roleId, info);
    }

    @Override
    public void deleteAuthRole(String id) {
        this.a(id);
        this.removeById((Serializable)((Object)id));
    }

    @Override
    public String copyAuthRole(String id, String name) {
        LowAppAuthRole authRole = (LowAppAuthRole)this.getById((Serializable)((Object)id));
        if (authRole != null) {
            LowAppAuthRole newAuthRole = new LowAppAuthRole();
            Integer orderNum = authRole.getOrderNum();
            if (orderNum == null) {
                orderNum = 0;
            }
            newAuthRole.setOrderNum(orderNum + 1);
            newAuthRole.setName(name);
            newAuthRole.setAppId(authRole.getAppId());
            newAuthRole.setAuthMode(authRole.getAuthMode());
            newAuthRole.setDescription(authRole.getDescription());
            newAuthRole.setTenantId(authRole.getTenantId());
            this.save(newAuthRole);
            String roleId = newAuthRole.getId();
            if ("easy".equals(authRole.getAuthMode())) {
                List<LowAppAuthOperation> authOperations;
                List<LowAppAuthRecord> authRecords = this.lowAppAuthRecordService.queryList("easy", id, null);
                if (authRecords != null && authRecords.size() > 0) {
                    ArrayList<LowAppAuthRecord> newList = new ArrayList<LowAppAuthRecord>();
                    for (LowAppAuthRecord lowAppAuthRecord : authRecords) {
                        LowAppAuthRecord lowAppAuthRecord2 = new LowAppAuthRecord();
                        BeanUtils.copyProperties((Object)lowAppAuthRecord, (Object)lowAppAuthRecord2);
                        lowAppAuthRecord2.setAppRoleId(roleId);
                        lowAppAuthRecord2.setId(null);
                        newList.add(lowAppAuthRecord2);
                    }
                    this.lowAppAuthRecordService.saveBatch(newList);
                }
                if ((authOperations = this.lowAppAuthOperationService.queryList("easy", id, null)) != null && authOperations.size() > 0) {
                    ArrayList<LowAppAuthOperation> newList = new ArrayList<LowAppAuthOperation>();
                    for (LowAppAuthOperation lowAppAuthOperation : authOperations) {
                        LowAppAuthOperation newObj = new LowAppAuthOperation();
                        BeanUtils.copyProperties((Object)lowAppAuthOperation, (Object)newObj);
                        newObj.setAppRoleId(roleId);
                        newObj.setId(null);
                        newList.add(newObj);
                    }
                    this.lowAppAuthOperationService.saveBatch(newList);
                }
            } else {
                List<LowAppAuthField> list;
                List<LowAppAuthForm> appAuthForms;
                List<LowAppAuthOperation> authOperations;
                List<LowAppAuthRecord> authRecords = this.lowAppAuthRecordService.queryList("super", id, null);
                if (authRecords != null && authRecords.size() > 0) {
                    ArrayList<LowAppAuthRecord> newList = new ArrayList<LowAppAuthRecord>();
                    for (LowAppAuthRecord lowAppAuthRecord : authRecords) {
                        LowAppAuthRecord lowAppAuthRecord3 = new LowAppAuthRecord();
                        BeanUtils.copyProperties((Object)lowAppAuthRecord, (Object)lowAppAuthRecord3);
                        lowAppAuthRecord3.setAppRoleId(roleId);
                        lowAppAuthRecord3.setId(null);
                        newList.add(lowAppAuthRecord3);
                    }
                    this.lowAppAuthRecordService.saveBatch(newList);
                }
                if ((authOperations = this.lowAppAuthOperationService.queryList("super", id, null)) != null && authOperations.size() > 0) {
                    ArrayList newList = new ArrayList();
                    for (LowAppAuthOperation lowAppAuthOperation : authOperations) {
                        LowAppAuthOperation newObj = new LowAppAuthOperation();
                        BeanUtils.copyProperties((Object)lowAppAuthOperation, (Object)newObj);
                        newObj.setAppRoleId(roleId);
                        newObj.setId(null);
                        newList.add(newObj);
                    }
                    this.lowAppAuthOperationService.saveBatch(newList);
                }
                if ((appAuthForms = this.lowAppAuthFormService.queryList(id, null)) != null && appAuthForms.size() > 0) {
                    ArrayList<LowAppAuthForm> arrayList = new ArrayList<LowAppAuthForm>();
                    for (LowAppAuthForm temp : appAuthForms) {
                        LowAppAuthForm newObj = new LowAppAuthForm();
                        BeanUtils.copyProperties((Object)temp, (Object)newObj);
                        newObj.setAppRoleId(roleId);
                        newObj.setId(null);
                        arrayList.add(newObj);
                    }
                    this.lowAppAuthFormService.saveBatch(arrayList);
                }
                if ((list = this.lowAppAuthFieldService.queryList(id, null)) != null && list.size() > 0) {
                    ArrayList<LowAppAuthField> arrayList = new ArrayList<LowAppAuthField>();
                    for (LowAppAuthField temp : list) {
                        LowAppAuthField newObj = new LowAppAuthField();
                        BeanUtils.copyProperties((Object)temp, (Object)newObj);
                        newObj.setAppRoleId(roleId);
                        newObj.setId(null);
                        arrayList.add(newObj);
                    }
                    this.lowAppAuthFieldService.saveBatch(arrayList);
                }
            }
            return roleId;
        }
        return null;
    }

    @Override
    public List<AppAuthRoleUser> selectAuthRoleUserList(AppAuthRoleUser appAuthRoleUser) {
        DbType dbType = CommonUtils.getDatabaseTypeEnum();
        List<AppAuthRoleUser> list = this.lowAppAuthRoleUserMapper.selectAuthRoleUserList(appAuthRoleUser, dbType.getDb());
        if (list != null && list.size() > 0) {
            String ownerId = null;
            LowApp lowApp = (LowApp)this.lowAppMapper.selectById((Serializable)((Object)appAuthRoleUser.getAppId()));
            if (lowApp != null) {
                ownerId = lowApp.getOwnerId();
            }
            List relationIdList = list.stream().map(AppAuthRoleUser::getRelationId).distinct().collect(Collectors.toList());
            LinkedHashMap<String, AppAuthRoleUser> result = new LinkedHashMap<String, AppAuthRoleUser>();
            for (String relationId : relationIdList) {
                for (AppAuthRoleUser roleUser : list) {
                    if (!relationId.equals(roleUser.getRelationId())) continue;
                    AppAuthRoleUser temp = (AppAuthRoleUser)result.get(relationId);
                    if (temp == null) {
                        temp = new AppAuthRoleUser();
                        BeanUtils.copyProperties((Object)roleUser, (Object)temp);
                    } else {
                        String oldId = temp.getAuthRoleId();
                        String newId = oldId + "," + roleUser.getAuthRoleId();
                        temp.setAuthRoleId(newId);
                    }
                    if (ownerId != null && ownerId.equals(relationId) && AuthRoleUserTypeEnum.USER.getTable().equals(temp.getType())) {
                        temp.setIsOwner(true);
                    }
                    result.put(relationId, temp);
                }
            }
            List<AppAuthRoleUser> roleUserList = result.values().stream().collect(Collectors.toList());
            return roleUserList;
        }
        return null;
    }

    @Override
    public AuthFormReadInfo getMenuReadInfo(String userId, String appId) {
        List<LowAppAuthRole> roleList = this.getUserRoleList(userId, appId);
        if (roleList == null || roleList.size() == 0) {
            return null;
        }
        AuthFormReadInfo info = new AuthFormReadInfo();
        for (LowAppAuthRole role : roleList) {
            if ("admin".equals(role.getCode())) {
                info.setReadAll(true);
                info.setHasAdmin(true);
                break;
            }
            if (!"easy".equals(role.getAuthMode())) continue;
            info.setReadAll(true);
        }
        if (!info.isReadAll()) {
            HashSet<String> allCodes = new HashSet<String>();
            for (LowAppAuthRole role : roleList) {
                List<String> codeList = this.lowAppAuthFormService.queryReadFormCodeList(role.getId());
                allCodes.addAll(codeList);
            }
            info.setFormCodeList(new ArrayList<String>(allCodes));
        }
        return info;
    }

    @Override
    public LowAppFormAuthModel getFormAuth(String userId, String appId, String formCode) {
        List<LowAppAuthRole> roleList = this.getUserRoleList(userId, appId);
        if (roleList == null || roleList.size() == 0) {
            return null;
        }
        LowAppFormAuthModel model = new LowAppFormAuthModel();
        model.setAppId(appId);
        model.setDesignFormCode(formCode);
        for (LowAppAuthRole role : roleList) {
            if (!"admin".equals(role.getCode())) continue;
            model.setHasAdmin(true);
            break;
        }
        if (model.isHasAdmin()) {
            return model;
        }
        HashMap<String, Boolean> fieldReadStatusMap = new HashMap<String, Boolean>();
        HashMap<String, Boolean> fieldUpdateStatusMap = new HashMap<String, Boolean>();
        boolean allFieldTrue = false;
        for (LowAppAuthRole role : roleList) {
            if ("easy".equals(role.getAuthMode())) {
                List<LowAppAuthRecord> authRecords = this.lowAppAuthRecordService.queryList("easy", role.getId(), null);
                e.d(model, authRecords);
                List<LowAppAuthOperation> authOperations = this.lowAppAuthOperationService.queryList("easy", role.getId(), null);
                e.a(model, authOperations);
                continue;
            }
            if (!"super".equals(role.getAuthMode())) continue;
            List<LowAppAuthForm> appAuthForms = this.lowAppAuthFormService.queryList(role.getId(), formCode);
            List authedViewIds = appAuthForms.stream().map(LowAppAuthForm::getViewId).filter(oConvertUtils::isNotEmpty).collect(Collectors.toList());
            List allViewList = this.desformBaseApi.getViewListByCode(formCode);
            List unAuthViewIds = allViewList.stream().map(o -> o.getString("id")).filter(o -> !authedViewIds.contains(o)).collect(Collectors.toList());
            for (String viewId : unAuthViewIds) {
                appAuthForms.add(new LowAppAuthForm().setAppRoleId(role.getId()).setDesignFormCode(formCode).setViewId(viewId).setAuthType("view").setAuthCreate(0).setAuthRead(0).setAuthUpdate(0).setAuthDelete(0));
            }
            Map<String, Boolean> formOperationStatus = e.c(model, appAuthForms);
            List<LowAppAuthRecord> authRecords = this.lowAppAuthRecordService.queryList("super", role.getId(), formCode);
            e.a(model, authRecords, formOperationStatus);
            List<LowAppAuthOperation> authOperations = this.lowAppAuthOperationService.queryList("super", role.getId(), formCode);
            e.b(model, authOperations);
            List<LowAppAuthField> authFields = this.lowAppAuthFieldService.queryList(role.getId(), formCode);
            boolean temp = e.a(fieldReadStatusMap, fieldUpdateStatusMap, authFields, allFieldTrue);
            if (!temp) continue;
            allFieldTrue = true;
        }
        ArrayList<String> excludeFields = new ArrayList<String>();
        ArrayList<String> excludeUpdateFields = new ArrayList<String>();
        if (!allFieldTrue) {
            for (String fieldKey : fieldReadStatusMap.keySet()) {
                if (((Boolean)fieldReadStatusMap.get(fieldKey)).booleanValue()) continue;
                excludeFields.add(fieldKey);
            }
            for (String fieldKey : fieldUpdateStatusMap.keySet()) {
                if (((Boolean)fieldUpdateStatusMap.get(fieldKey)).booleanValue()) continue;
                excludeUpdateFields.add(fieldKey);
            }
        }
        model.setExcludeFields(excludeFields);
        model.setExcludeUpdateFields(excludeUpdateFields);
        return model;
    }

    @Override
    public LowAppFormAuthRecordModel getLowAppReadAuth(String userId, String appId, String designFormCode, String authType) {
        if ("-1".equals(appId)) {
            return new LowAppFormAuthRecordModel(true);
        }
        if ("delete".equals(authType) || "update".equals(authType)) {
            return this.getLowAppUpdateAuth(userId, appId, designFormCode, authType);
        }
        List<LowAppAuthRole> roleList = this.getUserRoleList(userId, appId);
        if (roleList == null || roleList.size() == 0) {
            return null;
        }
        LowAppFormAuthRecordModel model = new LowAppFormAuthRecordModel();
        for (LowAppAuthRole role : roleList) {
            if (!"admin".equals(role.getCode())) continue;
            model.setHasAdmin(true);
            break;
        }
        if (model.isHasAdmin()) {
            return model;
        }
        for (LowAppAuthRole role : roleList) {
            if ("easy".equals(role.getAuthMode())) {
                List<LowAppAuthRecord> authRecords = this.lowAppAuthRecordService.queryList("easy", role.getId(), null);
                if (authRecords == null || authRecords.size() <= 0) continue;
                for (LowAppAuthRecord lowAppAuthRecord : authRecords) {
                    Integer subordinate = lowAppAuthRecord.getSubordinate();
                    boolean subStatus = subordinate.equals(1);
                    LowAppFormAuthRecordModel newModel = new LowAppFormAuthRecordModel();
                    newModel.setSubStatus(subStatus);
                    if (EasyAuthRecordEnum.RJUM.getType().equals(lowAppAuthRecord.getScopeKey())) {
                        newModel.setScope("join");
                    } else {
                        newModel.setScope("all");
                    }
                    if (model.compareTo(newModel) >= 0) continue;
                    model = newModel;
                }
                continue;
            }
            List<LowAppAuthForm> appAuthForms = this.lowAppAuthFormService.queryList(role.getId(), designFormCode);
            boolean readStatus = false;
            for (LowAppAuthForm af : appAuthForms) {
                if (!"desform".equals(af.getAuthType()) && !"form".equals(af.getAuthType())) continue;
                readStatus = a.s.equals(af.getAuthRead());
            }
            if (!readStatus) continue;
            List<LowAppAuthRecord> list = this.lowAppAuthRecordService.queryList("super", role.getId(), designFormCode);
            LowAppFormAuthRecordModel newModel = null;
            if (list == null || list.size() == 0) {
                newModel = new LowAppFormAuthRecordModel("join", false);
            } else {
                for (LowAppAuthRecord record3 : list) {
                    if (!"read".equals(record3.getScopeType())) continue;
                    String scopeKey = record3.getScopeKey();
                    Integer subordinate = record3.getSubordinate();
                    boolean subStatus = subordinate.equals(1);
                    newModel = new LowAppFormAuthRecordModel(scopeKey, subStatus);
                }
            }
            if (newModel == null || model.compareTo(newModel) >= 0) continue;
            model = newModel;
        }
        return model;
    }

    @Override
    public LowAppFormAuthRecordModel getLowAppUpdateAuth(String userId, String appId, String designFormCode, String authType) {
        List<LowAppAuthRole> roleList = this.getUserRoleList(userId, appId);
        if (roleList == null || roleList.size() == 0) {
            return null;
        }
        LowAppFormAuthRecordModel model = new LowAppFormAuthRecordModel();
        for (LowAppAuthRole role : roleList) {
            if (!"admin".equals(role.getCode())) continue;
            model.setHasAdmin(true);
            break;
        }
        if (model.isHasAdmin()) {
            return model;
        }
        for (LowAppAuthRole role : roleList) {
            if ("easy".equals(role.getAuthMode())) {
                List<LowAppAuthRecord> authRecords = this.lowAppAuthRecordService.queryList("easy", role.getId(), null);
                if (authRecords == null || authRecords.size() <= 0) continue;
                for (LowAppAuthRecord lowAppAuthRecord : authRecords) {
                    Integer subordinate = lowAppAuthRecord.getSubordinate();
                    boolean subStatus = subordinate.equals(1);
                    LowAppFormAuthRecordModel newModel = new LowAppFormAuthRecordModel();
                    newModel.setSubStatus(subStatus);
                    if (EasyAuthRecordEnum.RAUA.getType().equals(lowAppAuthRecord.getScopeKey())) {
                        newModel.setScope("all");
                    } else if (EasyAuthRecordEnum.READONLY.getType().equals(lowAppAuthRecord.getScopeKey())) {
                        newModel.setScope("readonly");
                    } else {
                        newModel.setScope("own");
                    }
                    if (model.compareTo(newModel) >= 0) continue;
                    model = newModel;
                }
                continue;
            }
            List<LowAppAuthForm> appAuthForms = this.lowAppAuthFormService.queryList(role.getId(), designFormCode);
            boolean authStatus = false;
            for (LowAppAuthForm af : appAuthForms) {
                if (!"form".equals(af.getAuthType()) && !"desform".equals(af.getAuthType())) continue;
                if ("update".equals(authType)) {
                    authStatus = a.s.equals(af.getAuthUpdate());
                    continue;
                }
                if (!"delete".equals(authType)) continue;
                authStatus = a.s.equals(af.getAuthDelete());
            }
            if (!authStatus) continue;
            List<LowAppAuthRecord> list = this.lowAppAuthRecordService.queryList("super", role.getId(), designFormCode);
            LowAppFormAuthRecordModel newModel = null;
            if (list == null || list.size() == 0) {
                newModel = new LowAppFormAuthRecordModel("own", false);
            } else {
                for (LowAppAuthRecord record3 : list) {
                    String scopeType = record3.getScopeType();
                    if (!authType.equals(scopeType)) continue;
                    String scopeKey = record3.getScopeKey();
                    Integer subordinate = record3.getSubordinate();
                    boolean subStatus = subordinate.equals(1);
                    newModel = new LowAppFormAuthRecordModel(scopeKey, subStatus);
                }
            }
            if (newModel == null || model.compareTo(newModel) >= 0) continue;
            model = newModel;
        }
        return model;
    }

    @Override
    public List<String> getLowAppFormFieldAuth(String userId, String appId, String designFormCode, String authType) {
        List<LowAppAuthRole> roleList = this.getUserRoleList(userId, appId);
        if (roleList == null || roleList.size() == 0) {
            return null;
        }
        ArrayList<String> excludeFields = new ArrayList<String>();
        boolean allFieldTrue = false;
        for (LowAppAuthRole role : roleList) {
            if (!"admin".equals(role.getCode())) continue;
            allFieldTrue = true;
            break;
        }
        if (allFieldTrue) {
            return excludeFields;
        }
        HashMap<String, Boolean> fieldStatusMap = new HashMap<String, Boolean>();
        for (LowAppAuthRole role : roleList) {
            if ("easy".equals(role.getAuthMode())) {
                allFieldTrue = true;
                break;
            }
            List<LowAppAuthField> authFields = this.lowAppAuthFieldService.queryList(role.getId(), designFormCode);
            if (authFields == null || authFields.size() == 0) {
                allFieldTrue = true;
                break;
            }
            for (LowAppAuthField field : authFields) {
                String fieldKey = field.getFieldKey();
                if ("create".equals(authType)) {
                    if (a.s.equals(field.getAuthCreate())) {
                        fieldStatusMap.put(fieldKey, true);
                        continue;
                    }
                    fieldStatusMap.put(fieldKey, false);
                    continue;
                }
                if ("update".equals(authType)) {
                    if (a.s.equals(field.getAuthUpdate())) {
                        fieldStatusMap.put(fieldKey, true);
                        continue;
                    }
                    fieldStatusMap.put(fieldKey, false);
                    continue;
                }
                if (!"read".equals(authType)) continue;
                if (a.s.equals(field.getAuthRead())) {
                    fieldStatusMap.put(fieldKey, true);
                    continue;
                }
                fieldStatusMap.put(fieldKey, false);
            }
        }
        if (!allFieldTrue) {
            for (String fieldKey : fieldStatusMap.keySet()) {
                if (((Boolean)fieldStatusMap.get(fieldKey)).booleanValue()) continue;
                excludeFields.add(fieldKey);
            }
        }
        return excludeFields;
    }

    @Override
    public List<JSONObject> getLowAppFormFieldAllAuth(String userId, String appId, String designFormCode) {
        List<LowAppAuthRole> roleList = this.getUserRoleList(userId, appId);
        if (roleList == null || roleList.size() == 0) {
            return null;
        }
        boolean allFieldTrue = false;
        for (LowAppAuthRole lowAppAuthRole : roleList) {
            if (!"admin".equals(lowAppAuthRole.getCode())) continue;
            allFieldTrue = true;
            break;
        }
        if (allFieldTrue) {
            return null;
        }
        HashMap<String, JSONObject> fieldStatusMap = new HashMap<String, JSONObject>();
        for (LowAppAuthRole role : roleList) {
            if ("easy".equals(role.getAuthMode())) {
                allFieldTrue = true;
                break;
            }
            List<LowAppAuthField> authFields = this.lowAppAuthFieldService.queryList(role.getId(), designFormCode);
            if (authFields == null || authFields.size() == 0) {
                allFieldTrue = true;
                break;
            }
            for (LowAppAuthField field : authFields) {
                String fieldKey = field.getFieldKey();
                JSONObject fieldStatus = fieldStatusMap.computeIfAbsent(fieldKey, k2 -> new JSONObject());
                fieldStatus.put("create", (Object)a.s.equals(field.getAuthCreate()));
                fieldStatus.put("read", (Object)a.s.equals(field.getAuthRead()));
                fieldStatus.put("update", (Object)a.s.equals(field.getAuthUpdate()));
            }
        }
        if (!allFieldTrue) {
            ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
            for (Map.Entry item : fieldStatusMap.entrySet()) {
                JSONObject field = (JSONObject)item.getValue();
                field.put("fieldKey", item.getKey());
                arrayList.add(field);
            }
            return arrayList;
        }
        return null;
    }

    @Override
    public boolean hasAdminAuth(String userId, String appId) {
        List<LowAppAuthRole> roleList = this.getUserRoleList(userId, appId);
        if (roleList == null || roleList.size() == 0) {
            return false;
        }
        boolean adminAuth = false;
        for (LowAppAuthRole role : roleList) {
            if (!"admin".equals(role.getCode())) continue;
            adminAuth = true;
            break;
        }
        return adminAuth;
    }

    @Override
    public boolean hasPackAuth(Integer tenantId, String userId) {
        Integer count = ((LowAppAuthRoleMapper)this.baseMapper).hasPackAuth(tenantId, userId);
        return count != null && count != 0;
    }

    @Override
    public void addUser2AdminRole(LoginUser sysUser, String appId) {
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthRole::getAppId, (Object)appId)).eq(LowAppAuthRole::getCode, (Object)"admin");
        List list = ((LowAppAuthRoleMapper)this.baseMapper).selectList((Wrapper)query);
        if (list != null && list.size() > 0) {
            String authRoleId = ((LowAppAuthRole)list.get(0)).getId();
            LowAppAuthRoleUser authRoleUser = new LowAppAuthRoleUser(authRoleId, "sys_user", sysUser.getId(), appId);
            authRoleUser.setCreateTime(new Date());
            authRoleUser.setCreateBy(sysUser.getUsername());
            this.lowAppAuthRoleUserMapper.insert(authRoleUser);
        }
    }

    @Override
    public List<LowAppAuthRole> getUserRoleList(String userId, String appId) {
        List<String> roleIdList = this.lowAppAuthRoleUserMapper.selectAuthUserRoleList(userId, appId);
        if (roleIdList == null || roleIdList.size() == 0) {
            return null;
        }
        List<LowAppAuthRole> roleList = ((LowAppAuthRoleMapper)this.baseMapper).getLowAppAuthRoleList(roleIdList);
        return roleList;
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "getType": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return LowAppMenu::getType;
            }
            case "getDelFlag": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") || !lambda.getImplMethodSignature().equals("()Ljava/lang/Integer;")) break;
                return LowAppMenu::getDelFlag;
            }
            case "getCode": {
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRole") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return LowAppAuthRole::getCode;
            }
            case "getAppId": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppMenu") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppMenu::getAppId;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRole") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return LowAppAuthRole::getAppId;
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

