/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.low.service.impl;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.CommonUtils;
import org.jeecg.common.util.dynamic.db.DbTypeUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.online.low.d.f;
import org.jeecg.modules.online.low.entity.LowAppAuthRoleUser;
import org.jeecg.modules.online.low.enums.AuthRoleUserTypeEnum;
import org.jeecg.modules.online.low.mapper.LowAppAuthRoleUserMapper;
import org.jeecg.modules.online.low.service.ILowAppAuthRoleUserService;
import org.jeecg.modules.online.low.vo.AuthUserApp;
import org.jeecg.modules.online.low.vo.RoleUserRemoveModel;
import org.jeecg.modules.online.low.vo.RoleUserUpdateModel;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="lowAppAuthRoleUserServiceImpl")
public class h
extends ServiceImpl<LowAppAuthRoleUserMapper, LowAppAuthRoleUser>
implements ILowAppAuthRoleUserService {
    @Override
    public void saveAuthRoleUser(RoleUserRemoveModel model) {
        String appId = model.getAppId();
        String authRoleId = model.getAuthRoleId();
        String type = model.getType();
        List<String> relationIdList = model.getRelationIdList();
        if (relationIdList != null && relationIdList.size() > 0) {
            String createBy = this.getCreateBy();
            ArrayList<LowAppAuthRoleUser> saveList = new ArrayList<LowAppAuthRoleUser>();
            for (String relationId : relationIdList) {
                LowAppAuthRoleUser authRoleUser = new LowAppAuthRoleUser(authRoleId, type, relationId, appId);
                authRoleUser.setId(f.a());
                authRoleUser.setCreateTime(new Date());
                authRoleUser.setCreateBy(createBy);
                saveList.add(authRoleUser);
            }
            DbType dbType = CommonUtils.getDatabaseTypeEnum();
            if (DbTypeUtils.dbTypeIsMySql((DbType)dbType)) {
                ((LowAppAuthRoleUserMapper)this.baseMapper).saveBatchIgnoreDuplicate(saveList);
            } else {
                List<LowAppAuthRoleUser> filterList = this.filterDuplicateData(saveList);
                ((LowAppAuthRoleUserMapper)this.baseMapper).saveBatchNoIgnore(filterList);
            }
        }
    }

    @Override
    public List<LowAppAuthRoleUser> filterDuplicateData(List<LowAppAuthRoleUser> lowAppAuthList) {
        List<LowAppAuthRoleUser> filterList = lowAppAuthList.stream().filter(obj -> {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(LowAppAuthRoleUser::getAppId, (Object)obj.getAppId());
            queryWrapper.eq(LowAppAuthRoleUser::getAuthRoleId, (Object)obj.getAuthRoleId());
            queryWrapper.eq(LowAppAuthRoleUser::getType, (Object)obj.getType());
            queryWrapper.eq(LowAppAuthRoleUser::getRelationId, (Object)obj.getRelationId());
            List ls = ((LowAppAuthRoleUserMapper)this.getBaseMapper()).selectList((Wrapper)queryWrapper);
            return CollectionUtils.isEmpty((Collection)ls);
        }).collect(Collectors.toList());
        return filterList;
    }

    @Override
    public void removeAuthRoleUser(RoleUserRemoveModel model) {
        String appId = model.getAppId();
        String authRoleId = model.getAuthRoleId();
        List<String> relationIdList = model.getRelationIdList();
        LambdaQueryWrapper query = null;
        if (relationIdList != null && relationIdList.size() > 0) {
            for (int i2 = 0; i2 < relationIdList.size(); ++i2) {
                String relationId = relationIdList.get(i2);
                query = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthRoleUser::getAppId, (Object)appId)).eq(LowAppAuthRoleUser::getRelationId, (Object)relationId);
                if (oConvertUtils.isNotEmpty((Object)authRoleId)) {
                    query.eq(LowAppAuthRoleUser::getAuthRoleId, (Object)authRoleId);
                }
                this.remove((Wrapper)query);
            }
        }
    }

    @Override
    public void updateAuthRoleUser(RoleUserUpdateModel model) {
        String appId = model.getAppId();
        String authRoleId = model.getAuthRoleId();
        List<RoleUserUpdateModel.RelationUser> relationUsers = model.getRelationUserList();
        List<String> authRoleIdList = model.getAuthRoleIdList();
        if (relationUsers != null && relationUsers.size() > 0) {
            String createBy = this.getCreateBy();
            ArrayList<LowAppAuthRoleUser> saveList = new ArrayList<LowAppAuthRoleUser>();
            RoleUserRemoveModel removeModel = new RoleUserRemoveModel(appId, authRoleId);
            ArrayList<String> relationIdList = new ArrayList<String>();
            for (int i2 = 0; i2 < relationUsers.size(); ++i2) {
                RoleUserUpdateModel.RelationUser relationUser = relationUsers.get(i2);
                String type = relationUser.getType();
                String relationId = relationUser.getId();
                relationIdList.add(relationId);
                if (authRoleIdList == null || authRoleIdList.size() <= 0) continue;
                for (int j2 = 0; j2 < authRoleIdList.size(); ++j2) {
                    String roleId = authRoleIdList.get(j2);
                    LowAppAuthRoleUser authRoleUser = new LowAppAuthRoleUser(roleId, type, relationId, appId);
                    authRoleUser.setId(f.a());
                    authRoleUser.setCreateTime(new Date());
                    authRoleUser.setCreateBy(createBy);
                    saveList.add(authRoleUser);
                }
            }
            removeModel.setRelationIdList(relationIdList);
            this.removeAuthRoleUser(removeModel);
            DbType dbType = CommonUtils.getDatabaseTypeEnum();
            if (DbTypeUtils.dbTypeIsMySql((DbType)dbType)) {
                ((LowAppAuthRoleUserMapper)this.baseMapper).saveBatchIgnoreDuplicate(saveList);
            } else {
                List<LowAppAuthRoleUser> filterList = this.filterDuplicateData(saveList);
                ((LowAppAuthRoleUserMapper)this.baseMapper).saveBatchNoIgnore(filterList);
            }
        }
    }

    @Override
    public List<AuthUserApp> selectDepartUserAppList(String userId, String appId) {
        return ((LowAppAuthRoleUserMapper)this.baseMapper).selectDepartUserAppList(userId, appId);
    }

    @Override
    public void outOfApp(String userId, String appId) {
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(LowAppAuthRoleUser::getAppId, (Object)appId)).eq(LowAppAuthRoleUser::getType, (Object)AuthRoleUserTypeEnum.USER.getTable())).eq(LowAppAuthRoleUser::getRelationId, (Object)userId);
        this.remove((Wrapper)query);
    }

    @Override
    public List<LowAppAuthRoleUser> queryList(String appId) {
        return ((LowAppAuthRoleUserMapper)this.baseMapper).queryList(appId);
    }

    private String getCreateBy() {
        String createBy = null;
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (sysUser != null) {
            createBy = sysUser.getUsername();
        }
        return createBy;
    }

    private static /* synthetic */ Object a(SerializedLambda lambda) {
        switch (lambda.getImplMethodName()) {
            case "getRelationId": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRoleUser") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthRoleUser::getRelationId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRoleUser") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthRoleUser::getRelationId;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRoleUser") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return LowAppAuthRoleUser::getRelationId;
            }
            case "getType": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRoleUser") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthRoleUser::getType;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRoleUser") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return LowAppAuthRoleUser::getType;
            }
            case "getAuthRoleId": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRoleUser") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthRoleUser::getAuthRoleId;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRoleUser") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return LowAppAuthRoleUser::getAuthRoleId;
            }
            case "getAppId": {
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRoleUser") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthRoleUser::getAppId;
                }
                if (lambda.getImplMethodKind() == 5 && lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") && lambda.getFunctionalInterfaceMethodName().equals("apply") && lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") && lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRoleUser") && lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) {
                    return LowAppAuthRoleUser::getAppId;
                }
                if (lambda.getImplMethodKind() != 5 || !lambda.getFunctionalInterfaceClass().equals("com/baomidou/mybatisplus/core/toolkit/support/SFunction") || !lambda.getFunctionalInterfaceMethodName().equals("apply") || !lambda.getFunctionalInterfaceMethodSignature().equals("(Ljava/lang/Object;)Ljava/lang/Object;") || !lambda.getImplClass().equals("org/jeecg/modules/online/low/entity/LowAppAuthRoleUser") || !lambda.getImplMethodSignature().equals("()Ljava/lang/String;")) break;
                return LowAppAuthRoleUser::getAppId;
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

