/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.online.low.job;

import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.jeecg.modules.online.low.entity.LowApp;
import org.jeecg.modules.online.low.service.ILowAppService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LowAppDataClearJob
implements Job {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LowAppDataClearJob.class);
    private static long MAX_DIFF = 604800000L;
    @Autowired
    private ILowAppService lowAppService;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        log.info("------------------------\u5e94\u7528\u56de\u6536\u7ad9\u6570\u636e\u6e05\u7a7a \u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb---------------------- ");
        List<LowApp> appList = this.lowAppService.queryDeleteAppList();
        long now = System.currentTimeMillis();
        if (appList != null && appList.size() > 0) {
            for (LowApp app : appList) {
                long timestamp;
                long diff;
                Date deleteDate = app.getDeleteTime();
                if (deleteDate == null || (diff = now - (timestamp = deleteDate.getTime())) <= MAX_DIFF) continue;
                try {
                    this.lowAppService.deleteLowApp(app);
                    log.info("\u5e94\u7528 {} \u6570\u636e\u6e05\u9664\u6210\u529f", (Object)app.getAppName());
                }
                catch (Exception e2) {
                    log.error("\u5220\u9664\u5e94\u7528\u51fa\u9519\uff0c" + e2.getMessage());
                }
            }
        }
        log.info("------------------------\u5e94\u7528\u56de\u6536\u7ad9\u6570\u636e\u6e05\u7a7a \u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f---------------------- ");
    }
}

