/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class OpenApiConfig {
    private static final String CONFIG_FILE_NAME = "openapi.properties";
    private static Properties props;
    private static final Logger logger;

    private static void loadConfig() throws FileNotFoundException, IOException {
        String configFileName = System.getProperty("EAS_HOME") + "/server/properties/" + CONFIG_FILE_NAME;
        props = new Properties();
        File configFile = new File(configFileName);
        if (configFile.exists()) {
            props.load(new FileInputStream(configFile));
        }
    }

    public static Properties getAllProperty() {
        return props;
    }

    public static String getProperty(String propertyName) {
        if (props != null) {
            return props.getProperty(propertyName);
        }
        return null;
    }

    public static String getProperty(String propertyName, String _default) {
        String value = OpenApiConfig.getProperty(propertyName);
        if (value == null || value.trim().length() < 1) {
            value = _default;
        }
        return value;
    }

    static {
        logger = Logger.getLogger(OpenApiConfig.class);
        try {
            OpenApiConfig.loadConfig();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }
}

