/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.third.invoker;

import com.kingdee.bos.openapi.common.bo.LoginDataInfo;
import com.kingdee.bos.openapi.common.bo.OpenApiDataInfo;
import com.kingdee.bos.openapi.common.bo.ResultInfo;
import com.kingdee.bos.openapi.third.AbstractInvoker;
import com.kingdee.bos.openapi.third.OpenApiInfo;
import com.kingdee.bos.openapi.third.exception.BizException;
import com.kingdee.bos.openapi.third.exception.InvokeNetworkException;
import com.kingdee.bos.openapi.third.exception.LoginException;
import com.kingdee.bos.openapi.third.invoker.AbstractHttpLoginContext;
import com.kingdee.bos.openapi.third.invoker.AbstractLoginContext;
import com.kingdee.bos.openapi.third.utils.OpenApiTools;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class HTTPInvoker
extends AbstractInvoker {
    private static final Logger logger = Logger.getLogger(HTTPInvoker.class);
    protected String URL_PREF = "http://";

    public String login(AbstractLoginContext ctx) throws LoginException {
        try {
            AbstractHttpLoginContext loginCtx = (AbstractHttpLoginContext)ctx;
            loginCtx.init();
            String loginUrl = this.getLoginUrl(loginCtx);
            String dataStr = null;
            try {
                dataStr = OpenApiTools.doGet(loginUrl, loginCtx.getRequestHeaders(), loginCtx.getConnectTimeout(), loginCtx.getReadTimeout());
            }
            catch (Exception e) {
                throw new InvokeNetworkException(e);
            }
            if (logger.isDebugEnabled()) {
                logger.info((Object)("login data:" + dataStr));
            }
            ResultInfo resultInfo = null;
            try {
                resultInfo = this.dataType.parse2Object(dataStr, ResultInfo.class);
            }
            catch (Exception e) {
                throw new LoginException("fail to parse result and result : " + dataStr, e);
            }
            String token = null;
            if (0 != resultInfo.getErrCode()) {
                if (!OpenApiTools.isEmpty(resultInfo.getDescription())) {
                    logger.error((Object)resultInfo.getDescription());
                    throw new Exception(resultInfo.getDescription());
                }
                logger.error((Object)resultInfo.getErrStackTrace());
                throw new Exception(resultInfo.getErrMsg());
            }
            String data = resultInfo.getData();
            LoginDataInfo loginInfo = this.dataType.parse2Object(data, LoginDataInfo.class);
            token = loginInfo.getToken();
            loginCtx.setToken(token);
            return token;
        }
        catch (Exception e) {
            throw new LoginException(e);
        }
    }

    private String getLoginUrl(AbstractHttpLoginContext loginCtx) throws Exception {
        StringBuffer bf = new StringBuffer(this.URL_PREF).append(loginCtx.getIp()).append(":").append(loginCtx.getPort()).append(loginCtx.getUrl()).append("?");
        Map<String, String> map = loginCtx.getloginMap();
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            bf.append(entry.getKey()).append("=").append(entry.getValue());
            if (!iterator.hasNext()) continue;
            bf.append("&");
        }
        return bf.toString();
    }

    @Override
    public String invoke(AbstractLoginContext ctx, OpenApiInfo apiInfo) throws BizException, LoginException, InvokeNetworkException {
        ResultInfo resultInfo;
        AbstractHttpLoginContext loginCtx = (AbstractHttpLoginContext)ctx;
        String token = loginCtx.getToken();
        if (OpenApiTools.isEmpty(token)) {
            token = this.login(loginCtx);
        }
        try {
            token = URLEncoder.encode(token, "utf-8");
        }
        catch (Exception e) {
            throw new LoginException(e);
        }
        StringBuffer bf = new StringBuffer(this.URL_PREF).append(loginCtx.getIp()).append(":").append(loginCtx.getPort()).append(loginCtx.getInvokeUrl()).append("?").append("token=").append(token);
        String reqBody = null;
        String data = null;
        try {
            reqBody = this.dataType.parse2String(apiInfo);
            data = OpenApiTools.doPost(bf.toString(), loginCtx.getRequestHeaders4Invoke(), reqBody, loginCtx.getConnectTimeout(), loginCtx.getReadTimeout());
        }
        catch (Exception e) {
            throw new InvokeNetworkException(e);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("data:" + data));
        }
        if ((resultInfo = this.dataType.parse2Object(data, ResultInfo.class)).getErrCode() == 0) {
            OpenApiDataInfo apiData = this.dataType.parse2Object(resultInfo.getData(), OpenApiDataInfo.class);
            return apiData.getResult() == null ? null : apiData.getResult().toString();
        }
        if (resultInfo.getErrCode() == 1000) {
            loginCtx.setToken(null);
            return this.invoke(loginCtx, apiInfo);
        }
        if (!OpenApiTools.isEmpty(resultInfo.getDescription())) {
            logger.error((Object)resultInfo.getDescription());
            throw new LoginException(resultInfo.getDescription());
        }
        logger.error((Object)resultInfo.getErrStackTrace());
        throw new BizException(resultInfo.getErrMsg());
    }

    @Override
    public void close(AbstractLoginContext ctx) throws InvokeNetworkException {
    }
}

