/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.openapi.app.core.servlet;

import com.kingdee.bos.openapi.app.core.AbstractProcessor;
import com.kingdee.bos.openapi.app.core.DataType;
import com.kingdee.bos.openapi.app.core.PacketsEncoder;
import com.kingdee.bos.openapi.app.mq.QueueInitiator;
import com.kingdee.bos.openapi.common.bo.ResultInfo;
import com.kingdee.bos.openapi.util.ClassUtil;
import com.kingdee.bos.openapi.util.Encoding;
import com.kingdee.bos.openapi.util.OpenApiUtils;
import com.kingdee.bos.openapi.util.ThrowableHelper;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class OpenApiDispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = 2867487620877163870L;
    private static final Logger logger = Logger.getLogger(OpenApiDispatcherServlet.class);
    private Map<String, String> processors = new HashMap<String, String>();

    public void init() throws ServletException {
        super.init();
        this.initProcessors();
    }

    private void initMqConfig() {
        QueueInitiator.init();
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Content-type", "text/html;charset=UTF-8");
        resp.addHeader("Access-Control-Allow-Methods", "POST");
        String uri = req.getPathInfo();
        if (uri != null) {
            uri = uri.endsWith("/") ? uri : uri + "/";
        }
        DataType dataType = null;
        String dataTypeStr = req.getParameter("dataType");
        dataType = StringUtils.isEmpty((String)dataTypeStr) ? DataType.JSON : DataType.valueOf(dataTypeStr.toUpperCase());
        String clazzName = this.getProcessorClazzName(uri);
        if (clazzName == null) {
            this.handleError(resp, ResultInfo.STATUS_INVALID_PARAMETERS, dataType);
            return;
        }
        AbstractProcessor processor = (AbstractProcessor)ClassUtil.getNewInstance(clazzName);
        String encryptKey = "";
        encryptKey = encryptKey == null ? "" : encryptKey;
        String charset = req.getParameter("charset");
        charset = StringUtils.isEmpty((String)charset) ? "UTF-8" : charset;
        String encodeCookieVal = OpenApiUtils.getCookie(req, "encoding");
        Encoding encoding = Encoding.convert(encodeCookieVal);
        String tansferEncoding = req.getHeader("Transfer-Encoding");
        processor.setDataType(dataType);
        processor.setClientIp(OpenApiDispatcherServlet.getIpAddress(req));
        processor.setRequest(req);
        processor.setResponse(resp);
        processor.setCharset(charset);
        processor.setEncoding(encoding);
        processor.setEncryptKey(encryptKey);
        processor.setReqUrl(uri);
        Map paramMap = req.getParameterMap();
        HashMap<String, Object> processedParamMap = new HashMap<String, Object>();
        Set paramKeySet = paramMap.keySet();
        for (String paramName : paramKeySet) {
            String[] paramVals = (String[])paramMap.get(paramName);
            if (paramVals != null && paramVals.length == 1) {
                processedParamMap.put(paramName, paramVals[0]);
                continue;
            }
            processedParamMap.put(paramName, paramVals);
        }
        Object reqBody = null;
        if ("chunked".equals(tansferEncoding)) {
            reqBody = req.getInputStream();
        } else {
            byte[] requestBody = PacketsEncoder.parseInputStream(encodeCookieVal, (InputStream)req.getInputStream(), encryptKey);
            if (String.class.equals((Object)ClassUtil.getClassByName(processor.getReqBodyClassName()))) {
                String reqContent = new String(requestBody, charset);
                reqBody = reqContent;
            } else {
                reqBody = new ByteArrayInputStream(requestBody);
            }
        }
        ResultInfo resultInfo = null;
        try {
            resultInfo = processor.execute(processedParamMap, reqBody);
            if (resultInfo != null) {
                if (resultInfo.getStatusCode() != 0) {
                    resp.setStatus(resultInfo.getStatusCode());
                }
                byte[] responseBody = PacketsEncoder.encodeOuputStream(dataType.parse2String(null, resultInfo).getBytes(charset), encryptKey, encodeCookieVal);
                resp.getOutputStream().write(responseBody);
                resp.flushBuffer();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            resp.setStatus(500);
            if (e.getCause() != null && e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            String errMsg = e.getMessage();
            if (errMsg == null) {
                errMsg = dataType.parse2String(null, new ResultInfo(8000, ThrowableHelper.toString(e)));
            }
            resp.getOutputStream().write(errMsg.getBytes(charset));
            resp.getOutputStream().flush();
        }
    }

    private String getProcessorClazzName(String uri) {
        if (uri == null) {
            return null;
        }
        String clazzName = this.processors.get(uri);
        if (clazzName == null) {
            for (Map.Entry<String, String> entry : this.processors.entrySet()) {
                if (!uri.startsWith(entry.getKey())) continue;
                clazzName = entry.getValue();
                break;
            }
        }
        return clazzName;
    }

    private synchronized void initProcessors() throws ServletException {
        if (this.processors != null) {
            this.processors.clear();
        }
        ServiceLoader<AbstractProcessor> loader = ServiceLoader.load(AbstractProcessor.class);
        for (AbstractProcessor processor : loader) {
            String uri = processor.getTargetURI();
            String uri2 = null;
            uri2 = uri.endsWith("/") ? uri.substring(0, uri.length() - 1) : uri + "/";
            String ClazzName = processor.getClass().getName();
            this.processors.put(uri, ClazzName);
            this.processors.put(uri2, ClazzName);
        }
    }

    private void handleError(HttpServletResponse resp, ResultInfo resultInfo, DataType dataType) throws IOException {
        resp.setStatus(resultInfo.getStatusCode());
        resp.getWriter().write(dataType.parse2String(null, resultInfo));
        resp.flushBuffer();
    }

    public static String getIpAddress(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String napClientIP = request.getHeader("nap_proxy_client_ip");
        if (StringUtils.isEmpty((String)napClientIP)) {
            return request.getRemoteAddr();
        }
        return napClientIP;
    }
}

