/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.boot.starter.lock.core.strategy.impl;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.boot.starter.lock.core.strategy.RedissonConfigStrategy;
import org.jeecg.boot.starter.lock.prop.RedissonProperties;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentinelRedissonConfigStrategyImpl
implements RedissonConfigStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SentinelRedissonConfigStrategyImpl.class);

    @Override
    public Config createRedissonConfig(RedissonProperties redissonProperties) {
        Config config = new Config();
        try {
            String address = redissonProperties.getAddress();
            String password = redissonProperties.getPassword();
            int database = redissonProperties.getDatabase();
            String[] addrTokens = address.split(",");
            String sentinelAliasName = addrTokens[0];
            config.useSentinelServers().setMasterName(sentinelAliasName);
            config.useSentinelServers().setDatabase(database);
            if (StringUtils.isNotBlank((CharSequence)password)) {
                config.useSentinelServers().setPassword(password);
            }
            for (int i = 1; i < addrTokens.length; ++i) {
                config.useSentinelServers().addSentinelAddress(new String[]{"redis://" + addrTokens[i]});
            }
            log.info("\u521d\u59cb\u5316\u54e8\u5175\u65b9\u5f0fConfig,redisAddress:" + address);
        }
        catch (Exception e) {
            log.error("\u54e8\u5175Redisson\u521d\u59cb\u5316\u9519\u8bef", (Throwable)e);
            e.printStackTrace();
        }
        return config;
    }
}

