/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.boot.starter.lock.core.strategy.impl;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.boot.starter.lock.core.strategy.RedissonConfigStrategy;
import org.jeecg.boot.starter.lock.prop.RedissonProperties;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterRedissonConfigStrategyImpl
implements RedissonConfigStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterRedissonConfigStrategyImpl.class);

    @Override
    public Config createRedissonConfig(RedissonProperties redissonProperties) {
        Config config = new Config();
        try {
            String address = redissonProperties.getAddress();
            String password = redissonProperties.getPassword();
            String[] addrTokens = address.split(",");
            for (int i = 0; i < addrTokens.length; ++i) {
                config.useClusterServers().addNodeAddress(new String[]{"redis://" + addrTokens[i]});
                if (!StringUtils.isNotBlank((CharSequence)password)) continue;
                config.useClusterServers().setPassword(password);
            }
            log.info("\u521d\u59cb\u5316\u96c6\u7fa4\u65b9\u5f0fConfig,\u8fde\u63a5\u5730\u5740:" + address);
        }
        catch (Exception e) {
            log.error("\u96c6\u7fa4Redisson\u521d\u59cb\u5316\u9519\u8bef", (Throwable)e);
            e.printStackTrace();
        }
        return config;
    }
}

