/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.ai.stream;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.PartialThinking;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.rag.content.Content;
import dev.langchain4j.service.TokenStream;
import dev.langchain4j.service.tool.BeforeToolExecution;
import dev.langchain4j.service.tool.ToolExecution;
import dev.langchain4j.service.tool.ToolExecutionResult;
import dev.langchain4j.service.tool.ToolExecutor;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalTokenStream
implements TokenStream {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InternalTokenStream.class);
    private final StreamingChatModel model;
    private final List<ToolSpecification> toolSpecifications;
    private final Map<String, ToolExecutor> toolExecutors;
    private final ChatMemory chatMemory;
    private final List<Content> retrievedContents;
    private Consumer<String> onPartialResponse;
    private Consumer<PartialThinking> onPartialThinking;
    private Consumer<Throwable> onError;
    private Runnable onComplete;
    private Consumer<List<Content>> onRetrieved;
    private Consumer<ToolExecution> onToolExecuted;
    private Consumer<BeforeToolExecution> beforeToolExecutionHandler;
    private Consumer<ChatResponse> onCompleteResponse;
    private Consumer<ChatResponse> onIntermediateResponse;

    public InternalTokenStream(StreamingChatModel model, List<ToolSpecification> toolSpecifications, Map<String, ToolExecutor> toolExecutors, ChatMemory chatMemory, List<Content> retrievedContents) {
        this.model = model;
        this.toolSpecifications = toolSpecifications;
        this.toolExecutors = toolExecutors;
        this.chatMemory = chatMemory;
        this.retrievedContents = retrievedContents;
    }

    public TokenStream onPartialResponse(Consumer<String> onPartialResponse) {
        this.onPartialResponse = onPartialResponse;
        return this;
    }

    public TokenStream onPartialThinking(Consumer<PartialThinking> onPartialThinking) {
        this.onPartialThinking = onPartialThinking;
        return this;
    }

    public TokenStream onError(Consumer<Throwable> onError) {
        this.onError = onError;
        return this;
    }

    public TokenStream ignoreErrors() {
        return this;
    }

    public TokenStream onRetrieved(Consumer<List<Content>> onRetrieved) {
        this.onRetrieved = onRetrieved;
        return this;
    }

    public TokenStream beforeToolExecution(Consumer<BeforeToolExecution> beforeToolExecutionHandler) {
        this.beforeToolExecutionHandler = beforeToolExecutionHandler;
        return this;
    }

    public TokenStream onToolExecuted(Consumer<ToolExecution> onToolExecuted) {
        this.onToolExecuted = onToolExecuted;
        return this;
    }

    public TokenStream onCompleteResponse(Consumer<ChatResponse> onCompleteResponse) {
        this.onCompleteResponse = onCompleteResponse;
        return this;
    }

    public TokenStream onIntermediateResponse(Consumer<ChatResponse> onIntermediateResponse) {
        this.onIntermediateResponse = onIntermediateResponse;
        return this;
    }

    public void start() {
        if (this.onRetrieved != null && this.retrievedContents != null) {
            this.onRetrieved.accept(this.retrievedContents);
        }
        this.doChat();
    }

    private void doChat() {
        ChatRequest.Builder requestBuilder = ChatRequest.builder().messages(this.chatMemory.messages());
        if (this.toolSpecifications != null && !this.toolSpecifications.isEmpty()) {
            requestBuilder.toolSpecifications(this.toolSpecifications);
        }
        this.model.chat(requestBuilder.build(), new StreamingChatResponseHandler(){

            public void onPartialResponse(String token) {
                try {
                    if (InternalTokenStream.this.onPartialResponse != null) {
                        InternalTokenStream.this.onPartialResponse.accept(token);
                    }
                }
                catch (Exception e) {
                    log.warn("Error processing partial response: {}", (Object)e.getMessage());
                }
            }

            public void onPartialThinking(PartialThinking partialThinking) {
                try {
                    if (InternalTokenStream.this.onPartialThinking != null) {
                        InternalTokenStream.this.onPartialThinking.accept(partialThinking);
                    }
                }
                catch (Exception e) {
                    log.error("Error processing partial thinking: {}", (Object)e.getMessage());
                }
            }

            public void onCompleteResponse(ChatResponse completeResponse) {
                AiMessage aiMessage = completeResponse.aiMessage();
                InternalTokenStream.this.chatMemory.add((ChatMessage)aiMessage);
                if (aiMessage.hasToolExecutionRequests()) {
                    if (InternalTokenStream.this.onIntermediateResponse != null) {
                        try {
                            InternalTokenStream.this.onIntermediateResponse.accept(completeResponse);
                        }
                        catch (Exception e) {
                            log.error("Error in onIntermediateResponse callback: {}", (Object)e.getMessage());
                        }
                    }
                    for (ToolExecutionRequest toolExecReq : aiMessage.toolExecutionRequests()) {
                        Object result;
                        ToolExecutor executor = InternalTokenStream.this.toolExecutors.get(toolExecReq.name());
                        if (executor == null) {
                            if (InternalTokenStream.this.onError != null) {
                                InternalTokenStream.this.onError.accept(new IllegalStateException("\u672a\u627e\u5230\u5de5\u5177\u6267\u884c\u5668: " + toolExecReq.name()));
                            }
                            return;
                        }
                        if (InternalTokenStream.this.beforeToolExecutionHandler != null) {
                            try {
                                BeforeToolExecution beforeToolExecution = BeforeToolExecution.builder().request(toolExecReq).build();
                                InternalTokenStream.this.beforeToolExecutionHandler.accept(beforeToolExecution);
                            }
                            catch (Exception e) {
                                log.error("Error in beforeToolExecutionHandler callback: {}", (Object)e.getMessage());
                            }
                        }
                        log.info("[LLMHandler] Executing tool: {} ", (Object)toolExecReq.name());
                        try {
                            result = executor.execute(toolExecReq, InternalTokenStream.this.chatMemory.id());
                        }
                        catch (Exception e) {
                            log.error("Tool execution failed: {}", (Object)e.getMessage(), (Object)e);
                            result = "Tool execution failed: " + e.getMessage();
                        }
                        if (InternalTokenStream.this.onToolExecuted != null) {
                            try {
                                InternalTokenStream.this.onToolExecuted.accept(ToolExecution.builder().request(toolExecReq).result(ToolExecutionResult.builder().resultText((String)result).build()).build());
                            }
                            catch (Exception e) {
                                log.error("Error in onToolExecuted callback: {}", (Object)e.getMessage());
                            }
                        }
                        ToolExecutionResultMessage resultMsg = ToolExecutionResultMessage.from((ToolExecutionRequest)toolExecReq, (String)result);
                        InternalTokenStream.this.chatMemory.add((ChatMessage)resultMsg);
                    }
                    InternalTokenStream.this.doChat();
                } else {
                    if (InternalTokenStream.this.onCompleteResponse != null) {
                        InternalTokenStream.this.onCompleteResponse.accept(completeResponse);
                    }
                    if (InternalTokenStream.this.onComplete != null) {
                        InternalTokenStream.this.onComplete.run();
                    }
                }
            }

            public void onError(Throwable error) {
                if (InternalTokenStream.this.onError != null) {
                    InternalTokenStream.this.onError.accept(error);
                }
            }
        });
    }

    @Generated
    public void setOnPartialThinking(Consumer<PartialThinking> onPartialThinking) {
        this.onPartialThinking = onPartialThinking;
    }

    @Generated
    public Consumer<PartialThinking> getOnPartialThinking() {
        return this.onPartialThinking;
    }
}

