/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.ai.factory;

import dev.langchain4j.community.model.dashscope.QwenChatModel;
import dev.langchain4j.community.model.dashscope.QwenEmbeddingModel;
import dev.langchain4j.community.model.dashscope.QwenStreamingChatModel;
import dev.langchain4j.community.model.qianfan.QianfanChatModel;
import dev.langchain4j.community.model.qianfan.QianfanChatModelNameEnum;
import dev.langchain4j.community.model.qianfan.QianfanEmbeddingModel;
import dev.langchain4j.community.model.qianfan.QianfanEmbeddingModelNameEnum;
import dev.langchain4j.community.model.qianfan.QianfanStreamingChatModel;
import dev.langchain4j.community.model.zhipu.ZhipuAiChatModel;
import dev.langchain4j.community.model.zhipu.ZhipuAiEmbeddingModel;
import dev.langchain4j.community.model.zhipu.ZhipuAiStreamingChatModel;
import dev.langchain4j.community.model.zhipu.chat.ChatCompletionModel;
import dev.langchain4j.community.model.zhipu.embedding.EmbeddingModel;
import dev.langchain4j.model.anthropic.AnthropicChatModel;
import dev.langchain4j.model.anthropic.AnthropicChatModelName;
import dev.langchain4j.model.anthropic.AnthropicStreamingChatModel;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.ollama.OllamaChatModel;
import dev.langchain4j.model.ollama.OllamaEmbeddingModel;
import dev.langchain4j.model.ollama.OllamaStreamingChatModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.openai.OpenAiChatModelName;
import dev.langchain4j.model.openai.OpenAiEmbeddingModel;
import dev.langchain4j.model.openai.OpenAiEmbeddingModelName;
import dev.langchain4j.model.openai.OpenAiStreamingChatModel;
import java.lang.reflect.Array;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.jeecg.ai.factory.AiModelOptions;
import org.jetbrains.annotations.Nullable;

public class AiModelFactory {
    public static final String AIMODEL_TYPE_OPENAI = "OPENAI";
    public static final String AIMODEL_TYPE_ZHIPU = "ZHIPU";
    public static final String AIMODEL_TYPE_QIANFAN = "QIANFAN";
    public static final String AIMODEL_TYPE_QWEN = "QWEN";
    public static final String AIMODEL_TYPE_DEEPSEEK = "DEEPSEEK";
    public static final String AIMODEL_TYPE_OLLAMA = "OLLAMA";
    public static final String AIMODEL_TYPE_ANTHROPIC = "ANTHROPIC";
    private static final ConcurrentHashMap<String, Object> chatModelCache = new ConcurrentHashMap();

    private static Object getCache(String key) {
        return chatModelCache.get(key);
    }

    private static void setCache(String key, Object model) {
        chatModelCache.put(key, model);
    }

    public static ChatModel createChatModel(AiModelOptions options) {
        AiModelFactory.assertNotEmpty("\u8bf7\u8bbe\u7f6e\u6a21\u578b\u53c2\u6570", options);
        AiModelFactory.assertNotEmpty("\u8bf7\u9009\u62e9AI\u6a21\u578b\u4f9b\u5e94\u5546", options.getProvider());
        String cacheKey = options.toString();
        Object cachedModel = AiModelFactory.getCache(cacheKey);
        if (cachedModel != null) {
            return (ChatModel)cachedModel;
        }
        String apiKey = options.getApiKey();
        String secretKey = options.getSecretKey();
        String baseUrl = options.getBaseUrl();
        String modelName = options.getModelName();
        double temperature = AiModelFactory.getDouble(options.getTemperature(), 0.7);
        double topP = AiModelFactory.getDouble(options.getTopP(), 1.0);
        double presencePenalty = AiModelFactory.getDouble(options.getPresencePenalty(), 0.0);
        double frequencyPenalty = AiModelFactory.getDouble(options.getFrequencyPenalty(), 0.0);
        double repetitionPenalty = 1.0 + (presencePenalty + frequencyPenalty) / 2.0;
        int timeout = AiModelFactory.getInteger(options.getTimeout(), 120);
        Integer maxTokens = options.getMaxTokens();
        OllamaChatModel chatModel = null;
        switch (options.getProvider().toUpperCase()) {
            case "OPENAI": {
                AiModelFactory.assertNotEmpty("apiKey\u4e0d\u80fd\u4e3a\u7a7a", apiKey);
                baseUrl = AiModelFactory.ensureOpenAiUrlEnd(baseUrl);
                modelName = AiModelFactory.getString(modelName, OpenAiChatModelName.GPT_3_5_TURBO.toString());
                OpenAiChatModel.OpenAiChatModelBuilder openAIBuilder = OpenAiChatModel.builder().apiKey(apiKey).baseUrl(baseUrl).modelName(modelName).temperature(Double.valueOf(temperature)).topP(Double.valueOf(topP)).presencePenalty(Double.valueOf(presencePenalty)).frequencyPenalty(Double.valueOf(frequencyPenalty)).timeout(Duration.ofSeconds(timeout)).maxRetries(Integer.valueOf(0));
                if (null != maxTokens) {
                    openAIBuilder.maxTokens(maxTokens);
                }
                chatModel = openAIBuilder.build();
                break;
            }
            case "ZHIPU": {
                AiModelFactory.assertNotEmpty("apiKey\u4e0d\u80fd\u4e3a\u7a7a", apiKey);
                modelName = AiModelFactory.getString(modelName, ChatCompletionModel.GLM_4_FLASH.toString());
                ZhipuAiChatModel.ZhipuAiChatModelBuilder zhipuBuilder = ZhipuAiChatModel.builder().apiKey(apiKey).baseUrl(baseUrl).model(modelName).temperature(Double.valueOf(temperature)).topP(Double.valueOf(topP)).maxRetries(Integer.valueOf(0)).readTimeout(Duration.ofSeconds(timeout)).connectTimeout(Duration.ofSeconds(timeout));
                if (null != maxTokens) {
                    zhipuBuilder.maxToken(maxTokens);
                }
                chatModel = zhipuBuilder.build();
                break;
            }
            case "QIANFAN": {
                AiModelFactory.assertNotEmpty("apiKey\u4e0d\u80fd\u4e3a\u7a7a", apiKey);
                AiModelFactory.assertNotEmpty("secretKey\u4e0d\u80fd\u4e3a\u7a7a", secretKey);
                modelName = AiModelFactory.getString(modelName, QianfanChatModelNameEnum.YI_34B_CHAT.getModelName());
                QianfanChatModel.QianfanChatModelBuilder qianfanBuilder = QianfanChatModel.builder().apiKey(apiKey).baseUrl(baseUrl).secretKey(secretKey).modelName(modelName).temperature(Double.valueOf(temperature)).topP(Double.valueOf(topP)).penaltyScore(Double.valueOf(repetitionPenalty)).maxRetries(Integer.valueOf(0));
                if (null != maxTokens) {
                    qianfanBuilder.maxOutputTokens(maxTokens);
                }
                chatModel = qianfanBuilder.build();
                break;
            }
            case "QWEN": {
                AiModelFactory.assertNotEmpty("apiKey\u4e0d\u80fd\u4e3a\u7a7a", apiKey);
                modelName = AiModelFactory.getString(modelName, "qwen-plus");
                boolean isMultiModal = modelName.contains("vl-") || modelName.contains("audio-") || modelName.contains("omni-");
                boolean enableSearch = AiModelFactory.getBool(options.getEnableSearch(), false);
                QwenChatModel.QwenChatModelBuilder qwenBuilder = QwenChatModel.builder().apiKey(apiKey).baseUrl(baseUrl).modelName(modelName).temperature(Float.valueOf((float)temperature)).topP(Double.valueOf(topP)).enableSearch(Boolean.valueOf(enableSearch));
                if (!(modelName.contains("-vl-") || modelName.contains("-audio-") || modelName.contains("-omni-"))) {
                    qwenBuilder.repetitionPenalty(Float.valueOf((float)repetitionPenalty));
                }
                if (null != maxTokens) {
                    qwenBuilder.maxTokens(maxTokens);
                }
                chatModel = qwenBuilder.build();
                break;
            }
            case "OLLAMA": {
                AiModelFactory.assertNotEmpty("baseUrl\u4e0d\u80fd\u4e3a\u7a7a", baseUrl);
                AiModelFactory.assertNotEmpty("\u8bf7\u9009\u62e9\u6a21\u578b", modelName);
                chatModel = ((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().baseUrl(baseUrl)).modelName(modelName)).temperature(Double.valueOf(temperature))).topP(Double.valueOf(topP))).repeatPenalty(Double.valueOf(repetitionPenalty))).timeout(Duration.ofSeconds(timeout))).maxRetries(Integer.valueOf(3)).build();
                break;
            }
            case "DEEPSEEK": {
                AiModelFactory.assertNotEmpty("apiKey\u4e0d\u80fd\u4e3a\u7a7a", apiKey);
                baseUrl = AiModelFactory.getString(baseUrl, "https://api.deepseek.com/v1");
                baseUrl = AiModelFactory.ensureOpenAiUrlEnd(baseUrl);
                modelName = AiModelFactory.getString(modelName, "deepseek-chat");
                OpenAiChatModel.OpenAiChatModelBuilder dsBuilder = OpenAiChatModel.builder().apiKey(apiKey).baseUrl(baseUrl).modelName(modelName).temperature(Double.valueOf(temperature)).topP(Double.valueOf(topP)).presencePenalty(Double.valueOf(presencePenalty)).frequencyPenalty(Double.valueOf(frequencyPenalty)).timeout(Duration.ofSeconds(timeout));
                if (null != maxTokens) {
                    dsBuilder.maxTokens(maxTokens);
                }
                if (null != options.getReturnThinking()) {
                    dsBuilder.returnThinking(options.getReturnThinking());
                }
                chatModel = dsBuilder.build();
                break;
            }
            case "ANTHROPIC": {
                AiModelFactory.assertNotEmpty("apiKey\u4e0d\u80fd\u4e3a\u7a7a", apiKey);
                baseUrl = AiModelFactory.getString(baseUrl, "https://api.anthropic.com/v1");
                modelName = AiModelFactory.getString(modelName, AnthropicChatModelName.CLAUDE_3_5_SONNET_20241022.toString());
                AnthropicChatModel.AnthropicChatModelBuilder anthropicBuilder = AnthropicChatModel.builder().apiKey(apiKey).baseUrl(baseUrl).modelName(modelName).temperature(Double.valueOf(temperature)).topP(Double.valueOf(topP)).timeout(Duration.ofSeconds(timeout)).maxRetries(Integer.valueOf(0));
                if (null != maxTokens) {
                    anthropicBuilder.maxTokens(maxTokens);
                }
                chatModel = anthropicBuilder.build();
            }
        }
        AiModelFactory.setCache(cacheKey, chatModel);
        return chatModel;
    }

    public static StreamingChatModel createStreamingChatModel(AiModelOptions options) {
        AiModelFactory.assertNotEmpty("\u8bf7\u8bbe\u7f6e\u6a21\u578b\u53c2\u6570", options);
        AiModelFactory.assertNotEmpty("\u8bf7\u9009\u62e9AI\u6a21\u578b\u4f9b\u5e94\u5546", options.getProvider());
        String cacheKey = "STEAM_" + options.toString();
        Object cachedModel = AiModelFactory.getCache(cacheKey);
        if (cachedModel != null) {
            return (StreamingChatModel)cachedModel;
        }
        String apiKey = options.getApiKey();
        String secretKey = options.getSecretKey();
        String baseUrl = options.getBaseUrl();
        String modelName = options.getModelName();
        double temperature = AiModelFactory.getDouble(options.getTemperature(), 0.7);
        double topP = AiModelFactory.getDouble(options.getTopP(), 1.0);
        double presencePenalty = AiModelFactory.getDouble(options.getPresencePenalty(), 0.0);
        double frequencyPenalty = AiModelFactory.getDouble(options.getFrequencyPenalty(), 0.0);
        double repetitionPenalty = 1.0 + (presencePenalty + frequencyPenalty) / 2.0;
        int timeout = AiModelFactory.getInteger(options.getTimeout(), 120);
        Integer maxTokens = options.getMaxTokens();
        QianfanStreamingChatModel chatModel = null;
        switch (options.getProvider().toUpperCase()) {
            case "OPENAI": {
                AiModelFactory.assertNotEmpty("apiKey\u4e0d\u80fd\u4e3a\u7a7a", apiKey);
                baseUrl = AiModelFactory.ensureOpenAiUrlEnd(baseUrl);
                modelName = AiModelFactory.getString(modelName, OpenAiChatModelName.GPT_3_5_TURBO.toString());
                OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder openAIBuilder = OpenAiStreamingChatModel.builder().apiKey(apiKey).baseUrl(baseUrl).modelName(modelName).temperature(Double.valueOf(temperature)).topP(Double.valueOf(topP)).presencePenalty(Double.valueOf(presencePenalty)).frequencyPenalty(Double.valueOf(frequencyPenalty)).timeout(Duration.ofSeconds(timeout));
                if (null != maxTokens) {
                    openAIBuilder.maxTokens(maxTokens);
                }
                chatModel = openAIBuilder.build();
                break;
            }
            case "ZHIPU": {
                AiModelFactory.assertNotEmpty("apiKey\u4e0d\u80fd\u4e3a\u7a7a", apiKey);
                modelName = AiModelFactory.getString(modelName, ChatCompletionModel.GLM_4_FLASH.toString());
                ZhipuAiStreamingChatModel.ZhipuAiStreamingChatModelBuilder zhipuBuilder = ZhipuAiStreamingChatModel.builder().apiKey(apiKey).baseUrl(baseUrl).model(modelName).temperature(Double.valueOf(temperature)).topP(Double.valueOf(topP)).readTimeout(Duration.ofSeconds(timeout)).connectTimeout(Duration.ofSeconds(timeout));
                if (null != maxTokens) {
                    zhipuBuilder.maxToken(maxTokens);
                }
                chatModel = zhipuBuilder.build();
                break;
            }
            case "QIANFAN": {
                AiModelFactory.assertNotEmpty("apiKey\u4e0d\u80fd\u4e3a\u7a7a", apiKey);
                AiModelFactory.assertNotEmpty("secretKey\u4e0d\u80fd\u4e3a\u7a7a", secretKey);
                modelName = AiModelFactory.getString(modelName, QianfanChatModelNameEnum.YI_34B_CHAT.getModelName());
                chatModel = QianfanStreamingChatModel.builder().apiKey(apiKey).baseUrl(baseUrl).secretKey(secretKey).modelName(modelName).temperature(Double.valueOf(temperature)).topP(Double.valueOf(topP)).penaltyScore(Double.valueOf(repetitionPenalty)).build();
                break;
            }
            case "QWEN": {
                AiModelFactory.assertNotEmpty("apiKey\u4e0d\u80fd\u4e3a\u7a7a", apiKey);
                modelName = AiModelFactory.getString(modelName, "qwen-plus");
                Boolean enableSearch = AiModelFactory.getBool(options.getEnableSearch(), false);
                QwenStreamingChatModel.QwenStreamingChatModelBuilder qwenBuilder = QwenStreamingChatModel.builder().apiKey(apiKey).baseUrl(baseUrl).modelName(modelName).temperature(Float.valueOf((float)temperature)).topP(Double.valueOf(topP)).enableSearch(enableSearch);
                if (!(modelName.contains("-vl-") || modelName.contains("-audio-") || modelName.contains("-omni-"))) {
                    qwenBuilder.repetitionPenalty(Float.valueOf((float)repetitionPenalty));
                }
                if (null != maxTokens) {
                    qwenBuilder.maxTokens(maxTokens);
                }
                chatModel = qwenBuilder.build();
                break;
            }
            case "OLLAMA": {
                AiModelFactory.assertNotEmpty("baseUrl\u4e0d\u80fd\u4e3a\u7a7a", baseUrl);
                AiModelFactory.assertNotEmpty("\u8bf7\u9009\u62e9\u6a21\u578b", modelName);
                chatModel = ((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)OllamaStreamingChatModel.builder().baseUrl(baseUrl)).modelName(modelName)).temperature(Double.valueOf(temperature))).topP(Double.valueOf(topP))).repeatPenalty(Double.valueOf(repetitionPenalty))).timeout(Duration.ofSeconds(timeout))).build();
                break;
            }
            case "DEEPSEEK": {
                AiModelFactory.assertNotEmpty("apiKey\u4e0d\u80fd\u4e3a\u7a7a", apiKey);
                baseUrl = AiModelFactory.getString(baseUrl, "https://api.deepseek.com/v1");
                baseUrl = AiModelFactory.ensureOpenAiUrlEnd(baseUrl);
                modelName = AiModelFactory.getString(modelName, "deepseek-chat");
                OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder dsBuilder = OpenAiStreamingChatModel.builder().apiKey(apiKey).baseUrl(baseUrl).modelName(modelName).temperature(Double.valueOf(temperature)).topP(Double.valueOf(topP)).presencePenalty(Double.valueOf(presencePenalty)).frequencyPenalty(Double.valueOf(frequencyPenalty)).timeout(Duration.ofSeconds(timeout));
                if (null != maxTokens) {
                    dsBuilder.maxTokens(maxTokens);
                }
                if (null != options.getReturnThinking()) {
                    dsBuilder.returnThinking(options.getReturnThinking());
                }
                chatModel = dsBuilder.build();
                break;
            }
            case "ANTHROPIC": {
                AiModelFactory.assertNotEmpty("apiKey\u4e0d\u80fd\u4e3a\u7a7a", apiKey);
                baseUrl = AiModelFactory.getString(baseUrl, "https://api.anthropic.com/v1");
                modelName = AiModelFactory.getString(modelName, AnthropicChatModelName.CLAUDE_3_5_SONNET_20241022.toString());
                AnthropicStreamingChatModel.AnthropicStreamingChatModelBuilder anthropicStreamBuilder = AnthropicStreamingChatModel.builder().apiKey(apiKey).baseUrl(baseUrl).modelName(modelName).temperature(Double.valueOf(temperature)).topP(Double.valueOf(topP)).timeout(Duration.ofSeconds(timeout));
                if (null != maxTokens) {
                    anthropicStreamBuilder.maxTokens(maxTokens);
                }
                chatModel = anthropicStreamBuilder.build();
            }
        }
        AiModelFactory.setCache(cacheKey, chatModel);
        return chatModel;
    }

    public static dev.langchain4j.model.embedding.EmbeddingModel createEmbeddingModel(AiModelOptions options) {
        AiModelFactory.assertNotEmpty("\u8bf7\u8bbe\u7f6e\u6a21\u578b\u53c2\u6570", options);
        AiModelFactory.assertNotEmpty("\u8bf7\u9009\u62e9AI\u6a21\u578b\u4f9b\u5e94\u5546", options.getProvider());
        String cacheKey = options.toString();
        Object cachedModel = AiModelFactory.getCache(cacheKey);
        if (cachedModel != null) {
            return (dev.langchain4j.model.embedding.EmbeddingModel)cachedModel;
        }
        String apiKey = options.getApiKey();
        String secretKey = options.getSecretKey();
        String baseUrl = options.getBaseUrl();
        String modelName = options.getModelName();
        int timeout = AiModelFactory.getInteger(options.getTimeout(), 120);
        QwenEmbeddingModel embeddingModel = switch (options.getProvider().toUpperCase()) {
            case AIMODEL_TYPE_OPENAI -> {
                AiModelFactory.assertNotEmpty("apiKey\u4e0d\u80fd\u4e3a\u7a7a", apiKey);
                baseUrl = AiModelFactory.ensureOpenAiUrlEnd(baseUrl);
                modelName = AiModelFactory.getString(modelName, OpenAiEmbeddingModelName.TEXT_EMBEDDING_ADA_002.toString());
                yield OpenAiEmbeddingModel.builder().apiKey(apiKey).baseUrl(baseUrl).modelName(modelName).timeout(Duration.ofSeconds(timeout)).maxRetries(Integer.valueOf(0)).build();
            }
            case AIMODEL_TYPE_ZHIPU -> {
                AiModelFactory.assertNotEmpty("apiKey\u4e0d\u80fd\u4e3a\u7a7a", apiKey);
                modelName = AiModelFactory.getString(modelName, EmbeddingModel.EMBEDDING_2.toString());
                yield ZhipuAiEmbeddingModel.builder().apiKey(apiKey).baseUrl(baseUrl).model(modelName).readTimeout(Duration.ofSeconds(timeout)).connectTimeout(Duration.ofSeconds(timeout)).dimensions(Integer.valueOf(1536)).maxRetries(Integer.valueOf(0)).build();
            }
            case AIMODEL_TYPE_QIANFAN -> {
                AiModelFactory.assertNotEmpty("apiKey\u4e0d\u80fd\u4e3a\u7a7a", apiKey);
                AiModelFactory.assertNotEmpty("secretKey\u4e0d\u80fd\u4e3a\u7a7a", secretKey);
                modelName = AiModelFactory.getString(modelName, QianfanEmbeddingModelNameEnum.EMBEDDING_V1.getModelName());
                yield QianfanEmbeddingModel.builder().apiKey(apiKey).baseUrl(baseUrl).secretKey(secretKey).modelName(modelName).maxRetries(Integer.valueOf(0)).build();
            }
            case AIMODEL_TYPE_QWEN -> {
                AiModelFactory.assertNotEmpty("apiKey\u4e0d\u80fd\u4e3a\u7a7a", apiKey);
                modelName = AiModelFactory.getString(modelName, "text-embedding-v2");
                yield QwenEmbeddingModel.builder().apiKey(apiKey).baseUrl(baseUrl).modelName(modelName).build();
            }
            case AIMODEL_TYPE_OLLAMA -> {
                AiModelFactory.assertNotEmpty("baseUrl\u4e0d\u80fd\u4e3a\u7a7a", baseUrl);
                AiModelFactory.assertNotEmpty("\u8bf7\u9009\u62e9\u6a21\u578b", modelName);
                yield OllamaEmbeddingModel.builder().baseUrl(baseUrl).modelName(modelName).maxRetries(Integer.valueOf(3)).timeout(Duration.ofSeconds(timeout)).maxRetries(Integer.valueOf(0)).build();
            }
            default -> throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6a21\u578b");
        };
        AiModelFactory.setCache(cacheKey, embeddingModel);
        return embeddingModel;
    }

    public static void assertNotEmpty(String msg, Object obj) {
        if (AiModelFactory.isObjectEmpty(obj)) {
            throw new RuntimeException(msg);
        }
    }

    public static boolean isObjectEmpty(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return AiModelFactory.isEmpty(obj);
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj instanceof Iterable) {
            return AiModelFactory.isObjectEmpty(((Iterable)obj).iterator());
        }
        if (obj instanceof Iterator) {
            return !((Iterator)obj).hasNext();
        }
        if (AiModelFactory.isArray(obj)) {
            return 0 == Array.getLength(obj);
        }
        return false;
    }

    @Nullable
    private static String ensureOpenAiUrlEnd(String baseUrl) {
        if (StringUtils.isNotEmpty((String)baseUrl)) {
            if (((String)baseUrl).endsWith("/")) {
                baseUrl = ((String)baseUrl).substring(0, ((String)baseUrl).length() - 1);
            }
            if (!((String)baseUrl).endsWith("v1")) {
                baseUrl = (String)baseUrl + (((String)baseUrl).endsWith("/") ? "" : "/") + "v1";
            }
        }
        return baseUrl;
    }

    public static boolean isArray(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass().isArray();
    }

    public static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if ("".equals(object)) {
            return true;
        }
        return "null".equals(object);
    }

    public static String getString(CharSequence str, String defaultStr) {
        return AiModelFactory.isEmpty(str) ? defaultStr : str.toString();
    }

    public static Integer getInteger(Integer object, Integer defval) {
        if (object == null) {
            return defval;
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException e) {
            return defval;
        }
    }

    public static Double getDouble(Double object, Double defval) {
        if (object == null) {
            return defval;
        }
        try {
            return Double.parseDouble(object.toString());
        }
        catch (NumberFormatException e) {
            return defval;
        }
    }

    public static Boolean getBool(Boolean object, Boolean defval) {
        if (object == null) {
            return defval;
        }
        try {
            return Boolean.parseBoolean(object.toString());
        }
        catch (NumberFormatException e) {
            return defval;
        }
    }
}

