/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel.export.base;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jeecgframework.core.util.ApplicationContextUtil;
import org.jeecgframework.dict.service.AutoPoiDictServiceI;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecgframework.poi.excel.annotation.ExcelCollection;
import org.jeecgframework.poi.excel.annotation.ExcelEntity;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.params.ExcelExportEntity;
import org.jeecgframework.poi.handler.inter.IExcelDataHandler;
import org.jeecgframework.poi.handler.inter.IExcelDictHandler;
import org.jeecgframework.poi.util.JsonParser;
import org.jeecgframework.poi.util.PoiPublicUtil;

public class ExportBase {
    protected IExcelDataHandler dataHanlder;
    protected IExcelDictHandler dictHandler;
    protected List<String> needHanlderList;

    private ExcelExportEntity createExcelExportEntity(Field field, String targetId, Class<?> pojoClass, List<Method> getMethods) throws Exception {
        Excel excel = field.getAnnotation(Excel.class);
        ExcelExportEntity excelEntity = new ExcelExportEntity();
        excelEntity.setType(excel.type());
        this.getExcelField(targetId, field, excelEntity, excel, pojoClass);
        if (getMethods != null) {
            ArrayList<Method> newMethods = new ArrayList<Method>();
            newMethods.addAll(getMethods);
            newMethods.add(excelEntity.getMethod());
            excelEntity.setMethods(newMethods);
        }
        return excelEntity;
    }

    private Object formatValue(Object value, ExcelExportEntity entity) throws Exception {
        SimpleDateFormat format;
        Date temp = null;
        if ("".equals(value)) {
            value = null;
        }
        if (value instanceof String && entity.getDatabaseFormat() != null) {
            format = new SimpleDateFormat(entity.getDatabaseFormat());
            temp = format.parse(value.toString());
        } else if (value instanceof Date) {
            temp = (Date)value;
        } else {
            if (value instanceof LocalDateTime) {
                LocalDateTime ldt = (LocalDateTime)value;
                DateTimeFormatter format2 = DateTimeFormatter.ofPattern(entity.getFormat());
                return format2.format(ldt);
            }
            if (value instanceof LocalDate) {
                LocalDate ld = (LocalDate)value;
                DateTimeFormatter format3 = DateTimeFormatter.ofPattern(entity.getFormat());
                return format3.format(ld);
            }
        }
        if (temp != null) {
            format = new SimpleDateFormat(entity.getFormat());
            value = format.format(temp);
        }
        return value;
    }

    public void getAllExcelField(String[] exclusions, String targetId, Field[] fields, List<ExcelExportEntity> excelParams, Class<?> pojoClass, List<Method> getMethods) throws Exception {
        List<String> exclusionsList = exclusions != null ? Arrays.asList(exclusions) : null;
        for (int i = 0; i < fields.length; ++i) {
            ExcelExportEntity excelEntity;
            Field field = fields[i];
            if (PoiPublicUtil.isNotUserExcelUserThis(exclusionsList, field, targetId)) continue;
            if (field.getAnnotation(Excel.class) != null) {
                excelParams.add(this.createExcelExportEntity(field, targetId, pojoClass, getMethods));
                continue;
            }
            if (PoiPublicUtil.isCollection(field.getType())) {
                ExcelCollection excel = field.getAnnotation(ExcelCollection.class);
                ParameterizedType pt = (ParameterizedType)field.getGenericType();
                Class clz = (Class)pt.getActualTypeArguments()[0];
                ArrayList<ExcelExportEntity> list = new ArrayList<ExcelExportEntity>();
                this.getAllExcelField(exclusions, StringUtils.isNotEmpty((CharSequence)excel.id()) ? excel.id() : targetId, PoiPublicUtil.getClassFields(clz), list, clz, null);
                excelEntity = new ExcelExportEntity();
                excelEntity.setName(this.getExcelName(excel.name(), targetId));
                excelEntity.setOrderNum(this.getCellOrder(excel.orderNum(), targetId));
                excelEntity.setMethod(PoiPublicUtil.getMethod(field.getName(), pojoClass));
                excelEntity.setList(list);
                excelParams.add(excelEntity);
                continue;
            }
            ArrayList<Method> newMethods = new ArrayList<Method>();
            if (getMethods != null) {
                newMethods.addAll(getMethods);
            }
            newMethods.add(PoiPublicUtil.getMethod(field.getName(), pojoClass));
            ExcelEntity excel = field.getAnnotation(ExcelEntity.class);
            if (excel.show()) {
                ArrayList<ExcelExportEntity> list = new ArrayList<ExcelExportEntity>();
                this.getAllExcelField(exclusions, StringUtils.isNotEmpty((CharSequence)excel.id()) ? excel.id() : targetId, PoiPublicUtil.getClassFields(field.getType()), list, field.getType(), null);
                excelEntity = new ExcelExportEntity();
                excelEntity.setName(this.getExcelName(excel.name(), targetId));
                excelEntity.setMethod(PoiPublicUtil.getMethod(field.getName(), pojoClass));
                excelEntity.setList(list);
                excelParams.add(excelEntity);
                continue;
            }
            this.getAllExcelField(exclusions, StringUtils.isNotEmpty((CharSequence)excel.id()) ? excel.id() : targetId, PoiPublicUtil.getClassFields(field.getType()), excelParams, field.getType(), newMethods);
        }
    }

    public int getCellOrder(String orderNum, String targetId) {
        String[] arr;
        if (this.isInteger(orderNum) || targetId == null) {
            return Integer.valueOf(orderNum);
        }
        for (String str : arr = orderNum.split(",")) {
            String[] temp = str.split("_");
            if (!targetId.equals(temp[1])) continue;
            return Integer.valueOf(temp[0]);
        }
        return 0;
    }

    public Object getCellValue(ExcelExportEntity entity, Object obj) throws Exception {
        if (null == obj) {
            return "";
        }
        Object value = entity.isDynamic() ? this.getDynamicCellValue(entity, obj) : (obj instanceof Map ? ((Map)obj).get(entity.getKey()) : (entity.getMethods() != null ? this.getFieldBySomeMethod(entity.getMethods(), obj) : entity.getMethod().invoke(obj, new Object[0])));
        if (StringUtils.isEmpty((CharSequence)(value = Optional.ofNullable(value).orElse("")).toString())) {
            return "";
        }
        if (StringUtils.isNotEmpty((CharSequence)entity.getNumFormat()) && value != null) {
            value = new DecimalFormat(entity.getNumFormat()).format(value);
        }
        if (StringUtils.isNotEmpty((CharSequence)entity.getDict()) && this.dictHandler != null) {
            value = this.dictHandler.toName(entity.getDict(), obj, entity.getName(), value);
        }
        if (StringUtils.isNotEmpty((CharSequence)entity.getFormat())) {
            value = this.formatValue(value, entity);
        }
        if (entity.getReplace() != null && entity.getReplace().length > 0) {
            String oldVal;
            if (value == null) {
                value = "";
            }
            if ((oldVal = value.toString()).equals(value = entity.isMultiReplace() ? this.multiReplaceValue(entity.getReplace(), String.valueOf(value)) : this.replaceValue(entity.getReplace(), String.valueOf(value)))) {
                // empty if block
            }
        }
        if (this.needHanlderList != null && this.needHanlderList.contains(entity.getName())) {
            value = this.dataHanlder.exportHandler(obj, entity.getName(), value);
        }
        if (StringUtils.isNotEmpty((CharSequence)entity.getSuffix()) && value != null) {
            value = value + entity.getSuffix();
        }
        return value == null ? "" : value.toString();
    }

    public Collection<?> getListCellValue(ExcelExportEntity entity, Object obj) throws Exception {
        if (!(obj instanceof Map)) {
            Object value = entity.getMethod().invoke(obj, new Object[0]);
            if (value instanceof Collection) {
                return (Collection)value;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            return list;
        }
        Object value = ((Map)obj).get(entity.getKey());
        return (Collection)value;
    }

    private void getExcelField(String targetId, Field field, ExcelExportEntity excelEntity, Excel excel, Class<?> pojoClass) throws Exception {
        excelEntity.setName(this.getExcelName(excel.name(), targetId));
        excelEntity.setWidth(excel.width());
        excelEntity.setHeight(excel.height());
        excelEntity.setNeedMerge(excel.needMerge());
        excelEntity.setMergeVertical(excel.mergeVertical());
        excelEntity.setMergeRely(excel.mergeRely());
        excelEntity.setReplace(excel.replace());
        excelEntity.setHyperlink(excel.isHyperlink());
        if (StringUtils.isNotEmpty((CharSequence)excel.dicCode())) {
            AutoPoiDictServiceI jeecgDictService = null;
            try {
                jeecgDictService = (AutoPoiDictServiceI)ApplicationContextUtil.getContext().getBean(AutoPoiDictServiceI.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (jeecgDictService != null) {
                String[] dictReplace = jeecgDictService.queryDict(excel.dictTable(), excel.dicCode(), excel.dicText());
                if (excelEntity.getReplace() != null && dictReplace != null && dictReplace.length != 0) {
                    excelEntity.setReplace(dictReplace);
                }
            }
        }
        excelEntity.setOrderNum(this.getCellOrder(excel.orderNum(), targetId));
        excelEntity.setWrap(excel.isWrap());
        excelEntity.setExportImageType(excel.imageType());
        excelEntity.setSuffix(excel.suffix());
        excelEntity.setDatabaseFormat(excel.databaseFormat());
        excelEntity.setFormat(StringUtils.isNotEmpty((CharSequence)excel.exportFormat()) ? excel.exportFormat() : excel.format());
        excelEntity.setStatistics(excel.isStatistics());
        String fieldname = field.getName();
        excelEntity.setKey(fieldname);
        excelEntity.setNumFormat(excel.numFormat());
        excelEntity.setDynamic(excel.dynamic());
        excelEntity.setDynamicField(excel.dynamicField());
        excelEntity.setDynamicValue(excel.dynamicVal());
        excelEntity.setDynamicKeepSelf(excel.dynamicKeepSelf());
        excelEntity.setColumnHidden(excel.isColumnHidden());
        excelEntity.setMethod(PoiPublicUtil.getMethod(fieldname, pojoClass, excel.exportConvert()));
        excelEntity.setMultiReplace(excel.multiReplace());
        if (StringUtils.isNotEmpty((CharSequence)excel.groupName())) {
            excelEntity.setGroupName(excel.groupName());
            excelEntity.setColspan(true);
        }
    }

    public String getExcelName(String exportName, String targetId) {
        String[] arr;
        if (exportName.indexOf(",") < 0 || targetId == null) {
            return exportName;
        }
        for (String str : arr = exportName.split(",")) {
            if (str.indexOf(targetId) == -1) continue;
            return str.split("_")[0];
        }
        return null;
    }

    public Object getFieldBySomeMethod(List<Method> list, Object t) throws Exception {
        for (Method m : list) {
            if (t == null) {
                t = "";
                break;
            }
            t = m.invoke(t, new Object[0]);
        }
        return t;
    }

    public short getRowHeight(List<ExcelExportEntity> excelParams) {
        double maxHeight = 0.0;
        for (int i = 0; i < excelParams.size(); ++i) {
            double d = maxHeight = maxHeight > excelParams.get(i).getHeight() ? maxHeight : excelParams.get(i).getHeight();
            if (excelParams.get(i).getList() == null) continue;
            for (int j = 0; j < excelParams.get(i).getList().size(); ++j) {
                maxHeight = maxHeight > excelParams.get(i).getList().get(j).getHeight() ? maxHeight : excelParams.get(i).getList().get(j).getHeight();
            }
        }
        return (short)(maxHeight * 50.0);
    }

    public boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private Object replaceValue(String[] replace, String value) {
        for (String str : replace) {
            String[] temp = this.getValueArr(str);
            if (!value.equals(temp[1]) && !value.replace("_", "---").equals(temp[1])) continue;
            value = temp[0];
            break;
        }
        return value;
    }

    private Object multiReplaceValue(String[] replace, String value) {
        if (value.indexOf(",") > 0) {
            String[] radioVals = value.split(",");
            String result = "";
            block0: for (int i = 0; i < radioVals.length; ++i) {
                String radio = radioVals[i];
                for (String str : replace) {
                    String[] temp = str.split("_");
                    temp = this.getValueArr(str);
                    if (!radio.equals(temp[1]) && !radio.replace("_", "---").equals(temp[1])) continue;
                    result = result.concat(temp[0]) + ",";
                    continue block0;
                }
            }
            result = result.equals("") ? value : result.substring(0, result.length() - 1);
            return result;
        }
        return this.replaceValue(replace, value);
    }

    public void sortAllParams(List<ExcelExportEntity> excelParams) {
        Collections.sort(excelParams);
        for (ExcelExportEntity entity : excelParams) {
            if (entity.getList() == null) continue;
            Collections.sort(entity.getList());
        }
    }

    public void reConfigExcelExportParams(List<ExcelExportEntity> excelParams, ExportParams exportParams) {
        HashSet NameSet = new HashSet();
        HashMap<String, ArrayList<String>> groupAndColumnList = new HashMap<String, ArrayList<String>>();
        HashMap<String, Integer> groupOrder = new HashMap<String, Integer>();
        int index = -99;
        for (ExcelExportEntity entity : excelParams) {
            String groupName;
            if (entity.getOrderNum() == 0) {
                entity.setOrderNum(index++);
            }
            if (entity.getExportImageType() == 3) {
                entity.setImageBasePath(exportParams.getImageBasePath());
            }
            if (entity.getList() != null) {
                Collections.sort(entity.getList());
                this.reConfigExcelExportParams(entity.getList(), exportParams);
            }
            if (!StringUtils.isNotEmpty((CharSequence)(groupName = entity.getGroupName()))) continue;
            ArrayList<String> ls = (ArrayList<String>)groupAndColumnList.get(groupName);
            if (ls == null) {
                ls = new ArrayList<String>();
                groupAndColumnList.put(groupName, ls);
            }
            ls.add(entity.getKey().toString());
            Integer order = (Integer)groupOrder.get(groupName);
            if (order == null || entity.getOrderNum() < order) {
                order = entity.getOrderNum();
            }
            groupOrder.put(groupName, order);
        }
        for (String key : groupAndColumnList.keySet()) {
            ExcelExportEntity temp = new ExcelExportEntity(key);
            temp.setColspan(true);
            temp.setSubColumnList((List)groupAndColumnList.get(key));
            temp.setOrderNum((Integer)groupOrder.get(key));
            excelParams.add(temp);
        }
        Collections.sort(excelParams);
    }

    private Object getDynamicCellValue(ExcelExportEntity entity, Object obj) throws Exception {
        Collection<?> dataList = this.getDynamicListValue(entity, obj);
        if (dataList == null) {
            return "";
        }
        String header = entity.getDynamicColumnName();
        String titleField = (String)StringUtils.defaultIfBlank((CharSequence)entity.getDynamicField(), (CharSequence)"name");
        String valueField = (String)StringUtils.defaultIfBlank((CharSequence)entity.getDynamicValue(), (CharSequence)"value");
        for (Object item : dataList) {
            Object nameVal = PoiPublicUtil.getParamsValue(titleField, item);
            if (nameVal == null || header == null || !header.equals(nameVal.toString())) continue;
            Object result = PoiPublicUtil.getParamsValue(valueField, item);
            return result == null ? "" : result;
        }
        return "";
    }

    protected Collection<?> getDynamicListValue(ExcelExportEntity entity, Object obj) throws Exception {
        Collection<?> parsed;
        Object value;
        if (obj instanceof Map) {
            value = ((Map)obj).get(entity.getKey());
        } else {
            Object object = value = entity.getMethods() != null ? this.getFieldBySomeMethod(entity.getMethods(), obj) : entity.getMethod().invoke(obj, new Object[0]);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String && (parsed = this.parseJsonArrayToList((String)value)) != null) {
            return parsed;
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value.getClass().isArray()) {
            return Arrays.asList((Object[])value);
        }
        return Collections.singletonList(value);
    }

    private Collection<?> parseJsonArrayToList(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        String trim = json.trim();
        if (!trim.startsWith("[") || !trim.endsWith("]")) {
            return null;
        }
        try {
            List<Object> objects = JsonParser.parseJsonArrayToList(json);
            return objects;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void rebuildDynamicColumns(Collection<?> dataSet, List<ExcelExportEntity> excelParams) throws Exception {
        if (excelParams == null || excelParams.isEmpty() || dataSet == null || dataSet.isEmpty()) {
            return;
        }
        ArrayList<ExcelExportEntity> result = new ArrayList<ExcelExportEntity>();
        for (ExcelExportEntity entity : excelParams) {
            if (!entity.isDynamic()) {
                result.add(entity);
                continue;
            }
            List<ExcelExportEntity> dynamicList = this.buildDynamicEntities(entity, dataSet);
            if (dynamicList.isEmpty() && !entity.isDynamicKeepSelf()) {
                result.add(entity);
                continue;
            }
            if (entity.isDynamicKeepSelf()) {
                result.add(this.copyKeepSelfEntity(entity));
            }
            result.addAll(dynamicList);
        }
        excelParams.clear();
        excelParams.addAll(result);
    }

    private ExcelExportEntity copyKeepSelfEntity(ExcelExportEntity source) {
        ExcelExportEntity target = this.copyDynamicBase(source);
        target.setDynamic(false);
        target.setDynamicField(null);
        target.setDynamicValue(null);
        target.setDynamicColumnName(null);
        target.setDynamicKeepSelf(false);
        target.setName(source.getName());
        return target;
    }

    private List<ExcelExportEntity> buildDynamicEntities(ExcelExportEntity entity, Collection<?> dataSet) throws Exception {
        LinkedHashSet<String> headers = new LinkedHashSet<String>();
        for (Object data : dataSet) {
            Collection<?> list = this.getDynamicListValue(entity, data);
            if (list == null) continue;
            for (Object item : list) {
                Object header = PoiPublicUtil.getParamsValue((String)StringUtils.defaultIfBlank((CharSequence)entity.getDynamicField(), (CharSequence)"name"), item);
                if (header == null || !StringUtils.isNotBlank((CharSequence)header.toString())) continue;
                headers.add(header.toString());
            }
        }
        ArrayList<ExcelExportEntity> dynamicEntities = new ArrayList<ExcelExportEntity>();
        for (String header : headers) {
            ExcelExportEntity copy = this.copyDynamicBase(entity);
            copy.setName(header);
            copy.setDynamicColumnName(header);
            copy.setOrderNum(entity.getOrderNum());
            dynamicEntities.add(copy);
        }
        return dynamicEntities;
    }

    private ExcelExportEntity copyDynamicBase(ExcelExportEntity source) {
        ExcelExportEntity target = new ExcelExportEntity();
        target.setType(source.getType());
        target.setName(source.getName());
        target.setKey(source.getKey());
        target.setWidth(source.getWidth());
        target.setHeight(source.getHeight());
        target.setExportImageType(source.getExportImageType());
        target.setImageBasePath(source.getImageBasePath());
        target.setOrderNum(source.getOrderNum());
        target.setWrap(source.isWrap());
        target.setNeedMerge(source.isNeedMerge());
        target.setMergeVertical(source.isMergeVertical());
        target.setMergeRely(source.getMergeRely());
        target.setSuffix(source.getSuffix());
        target.setStatistics(source.isStatistics());
        target.setColspan(source.isColspan());
        target.setSubColumnList(source.getSubColumnList());
        target.setGroupName(source.getGroupName());
        target.setColumnHidden(source.isColumnHidden());
        target.setReplace(source.getReplace());
        target.setMethod(source.getMethod());
        target.setMethods(source.getMethods());
        target.setMultiReplace(source.isMultiReplace());
        target.setNumFormat(source.getNumFormat());
        target.setDatabaseFormat(source.getDatabaseFormat());
        target.setFormat(source.getFormat());
        target.setFixedIndex(source.getFixedIndex());
        target.setDict(source.getDict());
        target.setHyperlink(source.isHyperlink());
        target.setMergeVertical(source.isMergeVertical());
        target.setDynamic(true);
        target.setDynamicField(source.getDynamicField());
        target.setDynamicValue(source.getDynamicValue());
        target.setDynamicKeepSelf(source.isDynamicKeepSelf());
        return target;
    }

    public String[] getValueArr(String val) {
        int i = val.lastIndexOf("_");
        String[] c = new String[]{val.substring(0, i), val.substring(i + 1)};
        return c;
    }
}

