/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel;

import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.jeecgframework.core.util.ApplicationContextUtil;
import org.jeecgframework.dict.service.AutoPoiDictServiceI;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecgframework.poi.excel.annotation.ExcelCollection;
import org.jeecgframework.poi.excel.annotation.ExcelTarget;
import org.jeecgframework.poi.excel.annotation.ExcelVerify;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.entity.params.ExcelCollectionParams;
import org.jeecgframework.poi.excel.entity.params.ExcelImportEntity;
import org.jeecgframework.poi.excel.entity.params.ExcelVerifyEntity;
import org.jeecgframework.poi.exception.excel.ExcelImportException;
import org.jeecgframework.poi.exception.excel.enums.ExcelImportEnum;
import org.jeecgframework.poi.util.ExcelUtil;
import org.jeecgframework.poi.util.PoiPublicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelImportCheckUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelImportCheckUtil.class);
    public static final Double defScreenRate = 0.8;

    public static Boolean check(InputStream inputstream, Class<?> pojoClass, ImportParams params) {
        return ExcelImportCheckUtil.check(inputstream, pojoClass, params, defScreenRate);
    }

    public static Boolean check(InputStream inputstream, Class<?> pojoClass, ImportParams params, Double screenRate) {
        Workbook book = null;
        int errorNum = 0;
        int successNum = 0;
        if (!inputstream.markSupported()) {
            inputstream = new PushbackInputStream(inputstream, 8);
        }
        try {
            book = WorkbookFactory.create((InputStream)inputstream);
            LOGGER.info("  >>>  poi3\u5347\u7ea7\u52304\u517c\u5bb9\u6539\u9020\u5de5\u4f5c, pojoClass=" + pojoClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < params.getSheetNum(); ++i) {
            Iterator rows;
            Row row = null;
            try {
                rows = book.getSheetAt(i).rowIterator();
            }
            catch (Exception e) {
                throw new RuntimeException("\u8bf7\u5bfc\u5165\u6b63\u786e\u683c\u5f0f\u7684excel\u6587\u4ef6\uff01");
            }
            for (int j = 0; j < params.getTitleRows() + params.getHeadRows(); ++j) {
                try {
                    row = (Row)rows.next();
                    continue;
                }
                catch (NoSuchElementException e) {
                    throw new RuntimeException("\u8bf7\u586b\u5199\u5185\u5bb9\u6807\u9898\uff01");
                }
            }
            Sheet sheet = book.getSheetAt(i);
            Map<Integer, String> titlemap = null;
            try {
                titlemap = ExcelImportCheckUtil.getTitleMap(sheet, params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Set<Integer> columnIndexSet = titlemap.keySet();
            Integer maxColumnIndex = Collections.max(columnIndexSet);
            Integer minColumnIndex = Collections.min(columnIndexSet);
            while (rows.hasNext() && (row == null || sheet.getLastRowNum() - row.getRowNum() > params.getLastOfInvalidRow())) {
                row = (Row)rows.next();
                HashMap<String, ExcelImportEntity> excelParams = new HashMap<String, ExcelImportEntity>();
                ArrayList<ExcelCollectionParams> excelCollection = new ArrayList<ExcelCollectionParams>();
                String targetId = null;
                if (!Map.class.equals(pojoClass)) {
                    Field[] fileds = PoiPublicUtil.getClassFields(pojoClass);
                    ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
                    if (etarget != null) {
                        targetId = etarget.value();
                    }
                    try {
                        ExcelImportCheckUtil.getAllExcelField(targetId, fileds, excelParams, excelCollection, pojoClass, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                try {
                    int lastCellNum;
                    int firstCellNum = row.getFirstCellNum();
                    if (firstCellNum > minColumnIndex) {
                        firstCellNum = minColumnIndex;
                    }
                    if ((lastCellNum = row.getLastCellNum()) < maxColumnIndex + 1) {
                        lastCellNum = maxColumnIndex + 1;
                    }
                    int le = lastCellNum;
                    for (int j = firstCellNum; j < le; ++j) {
                        String titleString = titlemap.get(j);
                        if (excelParams.containsKey(titleString) || Map.class.equals(pojoClass)) {
                            ++successNum;
                            continue;
                        }
                        if (excelCollection.size() > 0) {
                            Iterator var33 = excelCollection.iterator();
                            ExcelCollectionParams param = (ExcelCollectionParams)var33.next();
                            if (param.getExcelParams().containsKey(titleString)) {
                                ++successNum;
                                continue;
                            }
                            ++errorNum;
                            continue;
                        }
                        ++errorNum;
                    }
                    if (successNum < errorNum) {
                        return false;
                    }
                    if (successNum > errorNum) {
                        if (errorNum > 0) {
                            double newNumber = (double)successNum / (double)(successNum + errorNum);
                            BigDecimal bg = new BigDecimal(newNumber);
                            double f1 = bg.setScale(1, 4).doubleValue();
                            if (f1 < screenRate) {
                                return false;
                            }
                            return true;
                        }
                        return true;
                    }
                    if (successNum == errorNum) {
                        return false;
                    }
                    return false;
                }
                catch (ExcelImportException e) {
                    if (e.getType().equals((Object)ExcelImportEnum.VERIFY_ERROR)) continue;
                    throw new ExcelImportException(e.getType(), (Throwable)e);
                }
            }
        }
        return null;
    }

    private static Map<Integer, String> getTitleMap(Sheet sheet, ImportParams params) throws Exception {
        HashMap<Integer, String> titlemap = new HashMap<Integer, String>();
        Iterator cellTitle = null;
        String collectionName = null;
        Row headRow = null;
        int headBegin = params.getTitleRows();
        int allRowNum = sheet.getPhysicalNumberOfRows();
        while (headRow == null && headBegin < allRowNum) {
            headRow = sheet.getRow(headBegin++);
        }
        if (headRow == null) {
            throw new Exception("\u4e0d\u8bc6\u522b\u8be5\u6587\u4ef6");
        }
        if (ExcelUtil.isMergedRegion(sheet, headRow.getRowNum(), 0)) {
            params.setHeadRows(2);
        } else {
            params.setHeadRows(1);
        }
        cellTitle = headRow.cellIterator();
        while (cellTitle.hasNext()) {
            Cell cell = (Cell)cellTitle.next();
            String value = ExcelImportCheckUtil.getKeyValue(cell);
            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
            titlemap.put(cell.getColumnIndex(), value);
        }
        for (int j = headBegin; j < headBegin + params.getHeadRows() - 1; ++j) {
            headRow = sheet.getRow(j);
            cellTitle = headRow.cellIterator();
            while (cellTitle.hasNext()) {
                Cell cell = (Cell)cellTitle.next();
                String value = ExcelImportCheckUtil.getKeyValue(cell);
                if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                int columnIndex = cell.getColumnIndex();
                if (ExcelUtil.isMergedRegion(sheet, cell.getRowIndex() - 1, columnIndex)) {
                    collectionName = ExcelUtil.getMergedRegionValue(sheet, cell.getRowIndex() - 1, columnIndex);
                    if (params.isIgnoreHeader(collectionName)) {
                        titlemap.put(cell.getColumnIndex(), value);
                        continue;
                    }
                    titlemap.put(cell.getColumnIndex(), collectionName + "_" + value);
                    continue;
                }
                titlemap.put(cell.getColumnIndex(), value);
            }
        }
        return titlemap;
    }

    private static String getKeyValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        Object obj = null;
        switch (cell.getCellType()) {
            case STRING: {
                obj = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                obj = cell.getBooleanCellValue();
                break;
            }
            case NUMERIC: {
                obj = cell.getNumericCellValue();
                break;
            }
            case FORMULA: {
                obj = cell.getCellFormula();
            }
        }
        return obj == null ? null : obj.toString().trim();
    }

    public static void getAllExcelField(String targetId, Field[] fields, Map<String, ExcelImportEntity> excelParams, List<ExcelCollectionParams> excelCollection, Class<?> pojoClass, List<Method> getMethods) throws Exception {
        ExcelImportEntity excelEntity = null;
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (PoiPublicUtil.isNotUserExcelUserThis(null, field, targetId)) continue;
            if (PoiPublicUtil.isCollection(field.getType())) {
                ExcelCollectionParams collection = new ExcelCollectionParams();
                collection.setName(field.getName());
                HashMap<String, ExcelImportEntity> temp = new HashMap<String, ExcelImportEntity>();
                ParameterizedType pt = (ParameterizedType)field.getGenericType();
                Class clz = (Class)pt.getActualTypeArguments()[0];
                collection.setType(clz);
                ExcelImportCheckUtil.getExcelFieldList(targetId, PoiPublicUtil.getClassFields(clz), clz, temp, null);
                collection.setExcelParams(temp);
                collection.setExcelName(field.getAnnotation(ExcelCollection.class).name());
                ExcelImportCheckUtil.additionalCollectionName(collection);
                excelCollection.add(collection);
                continue;
            }
            if (PoiPublicUtil.isJavaClass(field)) {
                ExcelImportCheckUtil.addEntityToMap(targetId, field, excelEntity, pojoClass, getMethods, excelParams);
                continue;
            }
            ArrayList<Method> newMethods = new ArrayList<Method>();
            if (getMethods != null) {
                newMethods.addAll(getMethods);
            }
            newMethods.add(PoiPublicUtil.getMethod(field.getName(), pojoClass));
            ExcelImportCheckUtil.getAllExcelField(targetId, PoiPublicUtil.getClassFields(field.getType()), excelParams, excelCollection, field.getType(), newMethods);
        }
    }

    public static void getExcelFieldList(String targetId, Field[] fields, Class<?> pojoClass, Map<String, ExcelImportEntity> temp, List<Method> getMethods) throws Exception {
        ExcelImportEntity excelEntity = null;
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (PoiPublicUtil.isNotUserExcelUserThis(null, field, targetId)) continue;
            if (PoiPublicUtil.isJavaClass(field)) {
                ExcelImportCheckUtil.addEntityToMap(targetId, field, excelEntity, pojoClass, getMethods, temp);
                continue;
            }
            ArrayList<Method> newMethods = new ArrayList<Method>();
            if (getMethods != null) {
                newMethods.addAll(getMethods);
            }
            newMethods.add(PoiPublicUtil.getMethod(field.getName(), pojoClass, field.getType()));
            ExcelImportCheckUtil.getExcelFieldList(targetId, PoiPublicUtil.getClassFields(field.getType()), field.getType(), temp, newMethods);
        }
    }

    private static void additionalCollectionName(ExcelCollectionParams collection) {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(collection.getExcelParams().keySet());
        for (String key : keys) {
            collection.getExcelParams().put(collection.getExcelName() + "_" + key, collection.getExcelParams().get(key));
            collection.getExcelParams().remove(key);
        }
    }

    public static void addEntityToMap(String targetId, Field field, ExcelImportEntity excelEntity, Class<?> pojoClass, List<Method> getMethods, Map<String, ExcelImportEntity> temp) throws Exception {
        Excel excel = field.getAnnotation(Excel.class);
        excelEntity = new ExcelImportEntity();
        excelEntity.setType(excel.type());
        excelEntity.setSaveUrl(excel.savePath());
        excelEntity.setSaveType(excel.imageType());
        excelEntity.setReplace(excel.replace());
        excelEntity.setDatabaseFormat(excel.databaseFormat());
        excelEntity.setVerify(ExcelImportCheckUtil.getImportVerify(field));
        excelEntity.setSuffix(excel.suffix());
        excelEntity.setNumFormat(excel.numFormat());
        excelEntity.setGroupName(excel.groupName());
        excelEntity.setMultiReplace(excel.multiReplace());
        if (StringUtils.isNotEmpty((CharSequence)excel.dicCode())) {
            AutoPoiDictServiceI jeecgDictService = null;
            try {
                jeecgDictService = (AutoPoiDictServiceI)ApplicationContextUtil.getContext().getBean(AutoPoiDictServiceI.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (jeecgDictService != null) {
                String[] dictReplace = jeecgDictService.queryDict(excel.dictTable(), excel.dicCode(), excel.dicText());
                if (excelEntity.getReplace() != null && dictReplace != null && dictReplace.length != 0) {
                    excelEntity.setReplace(dictReplace);
                }
            }
        }
        ExcelImportCheckUtil.getExcelField(targetId, field, excelEntity, excel, pojoClass);
        if (getMethods != null) {
            ArrayList<Method> newMethods = new ArrayList<Method>();
            newMethods.addAll(getMethods);
            newMethods.add(excelEntity.getMethod());
            excelEntity.setMethods(newMethods);
        }
        temp.put(excelEntity.getName(), excelEntity);
    }

    public static void getExcelField(String targetId, Field field, ExcelImportEntity excelEntity, Excel excel, Class<?> pojoClass) throws Exception {
        excelEntity.setName(ExcelImportCheckUtil.getExcelName(excel.name(), targetId));
        String fieldname = field.getName();
        excelEntity.setMethod(PoiPublicUtil.getMethod(fieldname, pojoClass, field.getType(), excel.importConvert()));
        if (StringUtils.isNotEmpty((CharSequence)excel.importFormat())) {
            excelEntity.setFormat(excel.importFormat());
        } else {
            excelEntity.setFormat(excel.format());
        }
    }

    public static String getExcelName(String exportName, String targetId) {
        String[] arr;
        if (exportName.indexOf("_") < 0) {
            return exportName;
        }
        for (String str : arr = exportName.split(",")) {
            if (str.indexOf(targetId) == -1) continue;
            return str.split("_")[0];
        }
        return null;
    }

    public static ExcelVerifyEntity getImportVerify(Field field) {
        ExcelVerify verify = field.getAnnotation(ExcelVerify.class);
        if (verify != null) {
            ExcelVerifyEntity entity = new ExcelVerifyEntity();
            entity.setEmail(verify.isEmail());
            entity.setInterHandler(verify.interHandler());
            entity.setMaxLength(verify.maxLength());
            entity.setMinLength(verify.minLength());
            entity.setMobile(verify.isMobile());
            entity.setNotNull(verify.notNull());
            entity.setRegex(verify.regex());
            entity.setRegexTip(verify.regexTip());
            entity.setTel(verify.isTel());
            return entity;
        }
        return null;
    }
}

