/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.eoa.filemanage.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jeecg.common.util.DateUtils;
import org.jeecg.modules.eoa.filemanage.entity.EoaFile;

public class EoaFileModel {
    private String id;
    private String value;
    private boolean open;
    private String type;
    private String date;
    private long size;
    private String isFolder;
    private Integer downCount;
    private Integer readCount;
    private List<EoaFileModel> data;

    public EoaFileModel() {
    }

    public EoaFileModel(EoaFile file) {
        this.id = file.getId();
        this.value = file.getTitle();
        this.open = true;
        this.type = file.getDocType();
        this.date = String.valueOf(DateUtils.getMillis((Date)file.getCreateTime()));
        this.size = file.getDocSize();
        this.isFolder = file.getIsFolder();
        this.downCount = file.getDownCount() == null ? 0 : file.getDownCount();
        this.readCount = file.getReadCount() == null ? 0 : file.getReadCount();
        this.data = new ArrayList<EoaFileModel>();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public List<EoaFileModel> getData() {
        return this.data;
    }

    public void setData(List<EoaFileModel> data) {
        this.data = data;
    }

    public Integer getDownCount() {
        return this.downCount;
    }

    public void setDownCount(Integer downCount) {
        this.downCount = downCount;
    }

    public Integer getReadCount() {
        return this.readCount;
    }

    public void setReadCount(Integer readCount) {
        this.readCount = readCount;
    }

    public String getIsFolder() {
        return this.isFolder;
    }

    public void setIsFolder(String isFolder) {
        this.isFolder = isFolder;
    }
}

