/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.eoa.im.scoket;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.gexin.rp.sdk.base.IPushResult;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.apache.commons.lang.StringUtil;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.eoa.config.UniappUtil;
import org.jeecg.modules.eoa.im.entity.EoaChatOffMessage;
import org.jeecg.modules.eoa.im.entity.EoaChatOnMessage;
import org.jeecg.modules.eoa.im.entity.EoaChatUserGroup;
import org.jeecg.modules.eoa.im.service.IEoaChatOffMessageService;
import org.jeecg.modules.eoa.im.service.IEoaChatOnMessageService;
import org.jeecg.modules.eoa.im.service.IEoaChatUserGroupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/eoaSocket/{userId}")
public class EoaChatSocket {
    private static final Logger log = LoggerFactory.getLogger(EoaChatSocket.class);
    private String userId;
    private Session session;
    private static Map<String, EoaChatSocket> webSocketmap = new ConcurrentHashMap<String, EoaChatSocket>();
    private static CopyOnWriteArraySet<EoaChatSocket> webSockets = new CopyOnWriteArraySet();
    private static IEoaChatUserGroupService eoaChatUserGroupService;
    private static IEoaChatOnMessageService eoaChatRealTimeService;
    private static IEoaChatOffMessageService offMessageService;
    private static ISysBaseAPI iSysBaseAPI;

    @Autowired
    public void setChatService(IEoaChatUserGroupService eoaChatUserGroupService, IEoaChatOnMessageService eoaChatRealTimeService, IEoaChatOffMessageService offMessageService, ISysBaseAPI iSysBaseAPI) {
        EoaChatSocket.eoaChatUserGroupService = eoaChatUserGroupService;
        EoaChatSocket.eoaChatRealTimeService = eoaChatRealTimeService;
        EoaChatSocket.offMessageService = offMessageService;
        EoaChatSocket.iSysBaseAPI = iSysBaseAPI;
    }

    @OnOpen
    public void onOpen(Session session, @PathParam(value="userId") String userId) {
        try {
            this.session = session;
            webSockets.add(this);
            webSocketmap.put(userId, this);
            this.userId = userId;
            log.info("\u3010\u5728\u7ebf\u804a\u5929\u6d88\u606f\u3011\u6709\u65b0\u7684\u8fde\u63a5\uff0c\u603b\u6570\u4e3a:" + webSockets.size());
        }
        catch (Exception exception) {
            log.warn(exception.getMessage(), (Throwable)exception);
        }
    }

    @OnClose
    public void onClose() {
        try {
            webSockets.remove(this);
            webSocketmap.remove(this.userId);
            log.info("\u3010\u5728\u7ebf\u804a\u5929\u6d88\u606f\u3011\u8fde\u63a5\u65ad\u5f00\uff0c\u603b\u6570\u4e3a:" + webSockets.size());
        }
        catch (Exception exception) {
            log.warn(exception.getMessage(), (Throwable)exception);
        }
    }

    @OnMessage
    public void onMessage(String message) {
        log.debug("\u3010\u5728\u7ebf\u804a\u5929\u6d88\u606f\u3011\u6536\u5230\u5ba2\u6237\u7aef\u6d88\u606f:" + message);
        JSONObject jSONObject = JSON.parseObject((String)message);
        String string = jSONObject.getString("data");
        JSONObject jSONObject2 = JSON.parseObject((String)string);
        if ("chatMessage".equals(jSONObject.getString("type"))) {
            String string2 = jSONObject2.getString("to");
            JSONObject jSONObject3 = JSON.parseObject((String)string2);
            String string3 = jSONObject3.getString("id");
            String string4 = jSONObject3.getString("type");
            String string5 = jSONObject2.getString("mine");
            String string6 = JSON.parseObject((String)string5).getString("id");
            String string7 = JSON.parseObject((String)string5).getString("content");
            EoaChatOnMessage eoaChatOnMessage = new EoaChatOnMessage();
            eoaChatOnMessage.setMsgFrom(string6);
            eoaChatOnMessage.setMsgTo(string3);
            eoaChatOnMessage.setSendTime(new Date());
            eoaChatOnMessage.setMsgData(string7);
            eoaChatOnMessage.setType(string4);
            eoaChatOnMessage.setReaded(CommonConstant.HAS_READ_FLAG.toString());
            EoaChatOffMessage eoaChatOffMessage = new EoaChatOffMessage();
            BeanUtils.copyProperties((Object)eoaChatOnMessage, (Object)eoaChatOffMessage);
            eoaChatOffMessage.setMsgType(jSONObject.getString("type"));
            eoaChatRealTimeService.save(eoaChatOnMessage);
            if ("friend".equals(string4)) {
                if (null == webSocketmap.get(string3) && null == webSocketmap.get(string3.concat("_app"))) {
                    offMessageService.save(eoaChatOffMessage);
                    JSONObject jSONObject4 = JSON.parseObject((String)string5);
                    String string8 = jSONObject4.getString("username");
                    LoginUser loginUser = iSysBaseAPI.getUserById(string3);
                    String string9 = loginUser.getClientId();
                    if (StringUtil.isNotBlank((String)string9)) {
                        IPushResult iPushResult = UniappUtil.a(string8, "\u7ed9\u4f60\u53d1\u6765\u4e00\u6761\u6d88\u606f", string9, string6, string3);
                        log.info("ret----->", (Object)iPushResult);
                    }
                } else {
                    String string10 = null == webSocketmap.get(string3) ? string3.concat("_app") : string3;
                    this.sendMessageTo(message, string10);
                }
            } else if ("group".equals(string4)) {
                LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)lambdaQueryWrapper.eq(EoaChatUserGroup::getGroupId, (Object)string3)).select((Object[])new SFunction[]{EoaChatUserGroup::getUserId});
                List list = eoaChatUserGroupService.list((Wrapper)lambdaQueryWrapper);
                for (EoaChatUserGroup eoaChatUserGroup : list) {
                    if (this.userId.equals(eoaChatUserGroup.getUserId())) continue;
                    if (null == webSocketmap.get(eoaChatUserGroup.getUserId())) {
                        eoaChatOffMessage.setMsgTo(eoaChatUserGroup.getUserId());
                        eoaChatOffMessage.setGroupId(eoaChatOnMessage.getMsgTo());
                        offMessageService.save(eoaChatOffMessage);
                        continue;
                    }
                    this.sendMessageTo(message, eoaChatUserGroup.getUserId());
                }
            }
        } else {
            String string11 = jSONObject2.getString("to");
            JSONObject jSONObject5 = JSON.parseObject((String)string11);
            if (null == webSocketmap.get(jSONObject5.getString("id"))) {
                EoaChatOffMessage eoaChatOffMessage = new EoaChatOffMessage();
                eoaChatOffMessage.setMsgType(jSONObject.getString("type"));
                eoaChatOffMessage.setMsgTo(jSONObject5.getString("id"));
                eoaChatOffMessage.setType(jSONObject5.getString("type"));
                eoaChatOffMessage.setSendMsg(message);
                offMessageService.save(eoaChatOffMessage);
            } else {
                this.sendMessageTo(message, jSONObject5.getString("id"));
            }
        }
    }

    public void sendMessageTo(String message, String toId) {
        for (EoaChatSocket eoaChatSocket : webSocketmap.values()) {
            if (!eoaChatSocket.userId.equals(toId)) continue;
            try {
                Session session;
                log.info("\u3010\u5728\u7ebf\u804a\u5929\u6d88\u606f\u3011\u53d1\u9001\u6d88\u606f" + message);
                eoaChatSocket.session.getAsyncRemote().sendText(message);
                EoaChatSocket eoaChatSocket2 = webSocketmap.get(toId + "_app");
                if (eoaChatSocket2 == null || !(session = eoaChatSocket2.session).isOpen()) break;
                session.getAsyncRemote().sendText(message);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break;
        }
    }
}

